/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.vfs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileListener;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystem {
    protected VirtualFileSystem() {
    }

    @NonNls
    @NotNull
    public abstract String getProtocol();

    @Nullable
    public abstract VirtualFile findFileByPath(@NotNull @NonNls String var1);

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            VirtualFileSystem.$$$reportNull$$$0(0);
        }
        String string = path.replace('/', File.separatorChar);
        if (string == null) {
            VirtualFileSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    public abstract void refresh(boolean var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByPath(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    protected abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    protected abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    protected abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    public abstract boolean isReadOnly();

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isValidName(@NotNull String name) {
        if (name == null) {
            VirtualFileSystem.$$$reportNull$$$0(2);
        }
        return !name.isEmpty() && name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    @Nullable
    public Path getNioPath(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFileSystem.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/vfs/VirtualFileSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/vfs/VirtualFileSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNioPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

