/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi;

import sqldelight.com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import sqldelight.com.intellij.lang.jvm.types.JvmType;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.psi.JavaPsiFacade;
import sqldelight.com.intellij.psi.PsiAnnotation;
import sqldelight.com.intellij.psi.PsiAnnotationOwner;
import sqldelight.com.intellij.psi.PsiArrayType;
import sqldelight.com.intellij.psi.PsiClassType;
import sqldelight.com.intellij.psi.PsiElementFactory;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.psi.PsiPrimitiveType;
import sqldelight.com.intellij.psi.PsiTypeVisitor;
import sqldelight.com.intellij.psi.TypeAnnotationProvider;
import sqldelight.com.intellij.psi.search.GlobalSearchScope;
import sqldelight.com.intellij.psi.util.TypeConversionUtil;
import sqldelight.com.intellij.util.ArrayFactory;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner,
Cloneable,
JvmType {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType(JvmPrimitiveTypeKind.BYTE);
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType(JvmPrimitiveTypeKind.CHAR);
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType(JvmPrimitiveTypeKind.DOUBLE);
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType(JvmPrimitiveTypeKind.FLOAT);
    public static final PsiPrimitiveType INT = new PsiPrimitiveType(JvmPrimitiveTypeKind.INT);
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType(JvmPrimitiveTypeKind.LONG);
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType(JvmPrimitiveTypeKind.SHORT);
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType(JvmPrimitiveTypeKind.BOOLEAN);
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType(JvmPrimitiveTypeKind.VOID);
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType(null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiType[count];
    private TypeAnnotationProvider myAnnotationProvider;

    public static PsiType @NotNull [] createArray(int count) {
        PsiType[] psiTypeArray = ARRAY_FACTORY.create(count);
        if (psiTypeArray == null) {
            PsiType.$$$reportNull$$$0(0);
        }
        return psiTypeArray;
    }

    protected PsiType(PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            PsiType.$$$reportNull$$$0(1);
        }
        this(TypeAnnotationProvider.Static.create(annotations));
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations) {
        if (annotations == null) {
            PsiType.$$$reportNull$$$0(2);
        }
        this.myAnnotationProvider = annotations;
    }

    @NotNull
    public PsiType annotate(@NotNull TypeAnnotationProvider provider) {
        PsiType psiType;
        if (provider == null) {
            PsiType.$$$reportNull$$$0(3);
        }
        if (provider == this.myAnnotationProvider) {
            PsiType psiType2 = this;
            if (psiType2 == null) {
                PsiType.$$$reportNull$$$0(4);
            }
            return psiType2;
        }
        try {
            PsiType copy = (PsiType)this.clone();
            copy.myAnnotationProvider = provider;
            psiType = copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (psiType == null) {
            PsiType.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        return new PsiArrayType(this);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        if (annotations == null) {
            PsiType.$$$reportNull$$$0(6);
        }
        return new PsiArrayType(this, annotations);
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getPresentableText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public abstract String getPresentableText();

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getCanonicalText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public abstract String getCanonicalText();

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText();
        if (string == null) {
            PsiType.$$$reportNull$$$0(9);
        }
        return string;
    }

    public abstract boolean isValid();

    @Contract(pure=true)
    public boolean isAssignableFrom(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiType.$$$reportNull$$$0(10);
        }
        return TypeConversionUtil.isAssignable(this, type2);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiType.$$$reportNull$$$0(11);
        }
        return TypeConversionUtil.areTypesConvertible(type2, this);
    }

    public abstract boolean equalsToText(@NotNull String var1);

    @NotNull
    public static PsiClassType getTypeByName(@NotNull String qName, @NotNull Project project, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiType.$$$reportNull$$$0(12);
        }
        if (project == null) {
            PsiType.$$$reportNull$$$0(13);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(14);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
        PsiClassType psiClassType = factory.createTypeByFQClassName(qName, resolveScope);
        if (psiClassType == null) {
            PsiType.$$$reportNull$$$0(15);
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(16);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(17);
        }
        return PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangClass(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(18);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(19);
        }
        return PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangThrowable(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(20);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(21);
        }
        return PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangString(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(22);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(23);
        }
        return PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangError(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(24);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(25);
        }
        return PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangRuntimeException(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            PsiType.$$$reportNull$$$0(26);
        }
        if (resolveScope == null) {
            PsiType.$$$reportNull$$$0(27);
        }
        return PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type2 = this;
        int dims = 0;
        while (type2 instanceof PsiArrayType) {
            ++dims;
            type2 = ((PsiArrayType)type2).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type2 = this;
        while (type2 instanceof PsiArrayType) {
            type2 = ((PsiArrayType)type2).getComponentType();
        }
        PsiType psiType = type2;
        if (psiType == null) {
            PsiType.$$$reportNull$$$0(28);
        }
        return psiType;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    public abstract PsiType @NotNull [] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        TypeAnnotationProvider typeAnnotationProvider = this.myAnnotationProvider;
        if (typeAnnotationProvider == null) {
            PsiType.$$$reportNull$$$0(29);
        }
        return typeAnnotationProvider;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myAnnotationProvider.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiType.$$$reportNull$$$0(30);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiType.$$$reportNull$$$0(31);
        }
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiType.$$$reportNull$$$0(32);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            PsiType.$$$reportNull$$$0(33);
        }
        return psiAnnotationArray;
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/PsiType";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/PsiType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepComponentType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProvider";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangObject";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangThrowable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangString";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangError";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJavaLangRuntimeException";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(PsiAnnotation @NotNull [] annotations) {
            if (annotations == null) {
                Stub.$$$reportNull$$$0(0);
            }
            super(annotations);
        }

        protected Stub(@NotNull TypeAnnotationProvider annotations) {
            if (annotations == null) {
                Stub.$$$reportNull$$$0(1);
            }
            super(annotations);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            String string = this.getPresentableText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                Stub.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/psi/PsiType$Stub";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/psi/PsiType$Stub";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

