/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.smartPointers;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import sqldelight.com.intellij.extapi.psi.ASTDelegatePsiElement;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.lang.LanguageUtil;
import sqldelight.com.intellij.lang.injection.InjectedLanguageManager;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.openapi.util.ProperTextRange;
import sqldelight.com.intellij.openapi.util.Segment;
import sqldelight.com.intellij.openapi.util.TextRange;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.FileViewProvider;
import sqldelight.com.intellij.psi.PsiAnchor;
import sqldelight.com.intellij.psi.PsiCompiledElement;
import sqldelight.com.intellij.psi.PsiDirectory;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiLanguageInjectionHost;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.psi.SmartPointerManager;
import sqldelight.com.intellij.psi.SmartPsiElementPointer;
import sqldelight.com.intellij.psi.StubBasedPsiElement;
import sqldelight.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import sqldelight.com.intellij.psi.impl.PsiDocumentManagerBase;
import sqldelight.com.intellij.psi.impl.PsiManagerEx;
import sqldelight.com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.ClsElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.DirElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.FileElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.HardElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.Identikit;
import sqldelight.com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerEx;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import sqldelight.com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import sqldelight.com.intellij.psi.impl.source.PsiFileImpl;
import sqldelight.com.intellij.psi.tree.IStubFileElementType;
import sqldelight.com.intellij.psi.util.PsiTreeUtil;
import sqldelight.com.intellij.reference.SoftReference;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance(SmartPsiElementPointerImpl.class);
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    protected final SmartPointerManagerImpl myManager;
    private byte myReferenceCount;
    @Nullable
    SmartPointerTracker.PointerReference pointerReference;

    SmartPsiElementPointerImpl(SmartPointerManagerImpl manager, @NotNull E element, @Nullable PsiFile containingFile, boolean forInjected) {
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(0);
        }
        this(manager, element, SmartPsiElementPointerImpl.createElementInfo(manager, element, containingFile, forInjected));
    }

    SmartPsiElementPointerImpl(SmartPointerManagerImpl manager, @NotNull E element, @NotNull SmartPointerElementInfo elementInfo) {
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(1);
        }
        if (elementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(2);
        }
        this.myReferenceCount = 1;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementInfo = elementInfo;
        this.myManager = manager;
        this.cacheElement(element);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    @Override
    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    @Nullable
    public E getElement() {
        if (this.getProject().isDisposed()) {
            return null;
        }
        E element = this.getCachedElement();
        if (element == null || !element.isValid()) {
            element = this.doRestoreElement();
            this.cacheElement(element);
        }
        return element;
    }

    @Nullable
    E doRestoreElement() {
        PsiElement element = this.myElementInfo.restoreElement(this.myManager);
        if (element != null && !element.isValid()) {
            return null;
        }
        return (E)element;
    }

    void cacheElement(@Nullable E element) {
        this.myElement = element == null ? null : (PsiManagerEx.getInstanceEx(this.getProject()).isBatchFilesProcessingMode() ? new WeakReference<E>(element) : new java.lang.ref.SoftReference<E>(element));
    }

    public E getCachedElement() {
        return (E)((PsiElement)SoftReference.dereference(this.myElement));
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file = this.getElementInfo().restoreFile(this.myManager);
        if (file != null) {
            return file;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved2 = this.getElement();
            return resolved2 == null ? null : resolved2.getContainingFile();
        }
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(doc);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.myElementInfo.getRange(this.myManager);
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange(this.myManager);
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(SmartPointerManagerImpl manager, @NotNull E element, PsiFile containingFile, boolean forInjected) {
        PsiElement restored;
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(4);
        }
        SmartPointerElementInfo elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(manager.getProject(), element, containingFile, forInjected);
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest() && !element.equals(restored = elementInfo.restoreElement(manager))) {
            LOG.error("Cannot restore " + element + " of " + element.getClass() + " from " + elementInfo + "; restored=" + restored + " in " + element.getProject());
        }
        SmartPointerElementInfo smartPointerElementInfo = elementInfo;
        if (smartPointerElementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(5);
        }
        return smartPointerElementInfo;
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo doCreateElementInfo(@NotNull Project project, @NotNull E element, PsiFile containingFile, boolean forInjected) {
        SmartPointerElementInfo info;
        if (project == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiDirectory) {
            return new DirElementInfo((PsiDirectory)element);
        }
        if (element instanceof PsiCompiledElement || containingFile == null) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    return new FileElementInfo((PsiFile)element);
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    return new ClsElementInfo(stubReference);
                }
            }
            return new HardElementInfo(element);
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider && SmartPsiElementPointerImpl.hasReliableRange(element, containingFile)) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile);
            TextRange elementRange = element.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(hostContext);
                return new InjectedSelfElementInfo(project, element, elementRange, containingFile, hostPointer);
            }
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        if (element instanceof PsiFile) {
            FileViewProvider restored = PsiManager.getInstance(project).findViewProvider(virtualFile);
            return restored != null && restored.getPsi(LanguageUtil.getRootLanguage(element)) == element ? new FileElementInfo((PsiFile)element) : new HardElementInfo(element);
        }
        if (!SmartPsiElementPointerImpl.hasReliableRange(element, containingFile)) {
            return new HardElementInfo(element);
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).getSynchronizer().isDocumentAffectedByTransactions(document)) {
            LOG.error("Smart pointers must not be created during PSI changes");
        }
        if ((info = SmartPsiElementPointerImpl.createAnchorInfo(element, containingFile)) != null) {
            SmartPointerElementInfo smartPointerElementInfo = info;
            if (smartPointerElementInfo == null) {
                SmartPsiElementPointerImpl.$$$reportNull$$$0(8);
            }
            return smartPointerElementInfo;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            return new HardElementInfo(element);
        }
        Identikit.ByType identikit = Identikit.fromPsi(element, LanguageUtil.getRootLanguage(element));
        if (elementRange.isEmpty() && identikit.findPsiElement(containingFile, elementRange.getStartOffset(), elementRange.getEndOffset()) != element) {
            return new HardElementInfo(element);
        }
        if (!containingFile.isPhysical() && document == null) {
            return new HardElementInfo(element);
        }
        ProperTextRange proper = ProperTextRange.create(elementRange);
        return new SelfElementInfo(proper, identikit, containingFile, forInjected);
    }

    private static boolean hasReliableRange(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(9);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(10);
        }
        return (element instanceof ASTDelegatePsiElement || element instanceof ASTNode) && !SmartPsiElementPointerImpl.isFakePsiInNormalFile(element, containingFile);
    }

    private static boolean isFakePsiInNormalFile(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(11);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(12);
        }
        if (element.isPhysical()) {
            return false;
        }
        if (containingFile.isPhysical()) {
            return true;
        }
        TextRange range = element.getTextRange();
        return range == null || PsiTreeUtil.findElementOfClassAtRange(containingFile, range.getStartOffset(), range.getEndOffset(), element.getClass()) != element;
    }

    @Nullable
    private static SmartPointerElementInfo createAnchorInfo(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        StubBasedPsiElement stubPsi;
        int stubId;
        IStubFileElementType stubType;
        if (element == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(14);
        }
        if (element instanceof StubBasedPsiElement && containingFile instanceof PsiFileImpl && (stubType = ((PsiFileImpl)containingFile).getElementTypeForStubBuilder()) != null && stubType.shouldBuildStubFor(containingFile.getViewProvider().getVirtualFile()) && (stubId = PsiAnchor.calcStubIndex(stubPsi = (StubBasedPsiElement)element)) != -1) {
            return new AnchorElementInfo(element, (PsiFileImpl)containingFile, stubId, stubPsi.getElementType());
        }
        Pair<Identikit.ByAnchor, PsiElement> pair = Identikit.withAnchor(element, LanguageUtil.getRootLanguage(containingFile));
        if (pair != null) {
            return new AnchorElementInfo((PsiElement)pair.second, containingFile, (Identikit.ByAnchor)pair.first);
        }
        return null;
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        SmartPointerElementInfo smartPointerElementInfo = this.myElementInfo;
        if (smartPointerElementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(15);
        }
        return smartPointerElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(16);
        }
        if (pointer2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(17);
        }
        if (pointer1 == pointer2) {
            return true;
        }
        ProgressManager.checkCanceled();
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo(), ((SmartPsiElementPointerImpl)pointer1).myManager)) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || Comparing.equal(cachedElement1, cachedElement2);
        }
        return Comparing.equal(pointer1.getElement(), pointer2.getElement());
    }

    synchronized int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        if (this.myReferenceCount == 0) {
            return -1;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }

    public String toString() {
        return this.myElementInfo.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInfo";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateElementInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createElementInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateElementInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasReliableRange";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFakePsiInNormalFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAnchorInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

