/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.Set;
import java.util.function.Function;
import sqldelight.com.intellij.psi.JavaResolveResult;
import sqldelight.com.intellij.psi.JavaTokenType;
import sqldelight.com.intellij.psi.PsiArrayInitializerExpression;
import sqldelight.com.intellij.psi.PsiAssignmentExpression;
import sqldelight.com.intellij.psi.PsiBreakStatement;
import sqldelight.com.intellij.psi.PsiCallExpression;
import sqldelight.com.intellij.psi.PsiConditionalExpression;
import sqldelight.com.intellij.psi.PsiDiamondType;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiExpression;
import sqldelight.com.intellij.psi.PsiExpressionList;
import sqldelight.com.intellij.psi.PsiExpressionStatement;
import sqldelight.com.intellij.psi.PsiFunctionalExpression;
import sqldelight.com.intellij.psi.PsiLambdaExpression;
import sqldelight.com.intellij.psi.PsiMember;
import sqldelight.com.intellij.psi.PsiMethod;
import sqldelight.com.intellij.psi.PsiMethodCallExpression;
import sqldelight.com.intellij.psi.PsiNewExpression;
import sqldelight.com.intellij.psi.PsiParenthesizedExpression;
import sqldelight.com.intellij.psi.PsiPrimitiveType;
import sqldelight.com.intellij.psi.PsiReturnStatement;
import sqldelight.com.intellij.psi.PsiSubstitutor;
import sqldelight.com.intellij.psi.PsiSwitchExpression;
import sqldelight.com.intellij.psi.PsiSwitchLabeledRuleStatement;
import sqldelight.com.intellij.psi.PsiThrowStatement;
import sqldelight.com.intellij.psi.PsiType;
import sqldelight.com.intellij.psi.PsiTypeElement;
import sqldelight.com.intellij.psi.PsiTypeParameter;
import sqldelight.com.intellij.psi.PsiVariable;
import sqldelight.com.intellij.psi.PsiYieldStatement;
import sqldelight.com.intellij.psi.infos.MethodCandidateInfo;
import sqldelight.com.intellij.psi.util.PsiTreeUtil;
import sqldelight.com.intellij.psi.util.PsiTypesUtil;
import sqldelight.com.intellij.psi.util.PsiUtil;
import sqldelight.com.intellij.psi.util.TypeConversionUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.Nullable;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression) {
        return !(expression instanceof PsiFunctionalExpression) && !(expression instanceof PsiParenthesizedExpression) && !(expression instanceof PsiConditionalExpression) && !(expression instanceof PsiSwitchExpression) && !(expression instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression) {
        ConditionalKind conditionalKind;
        if (expression instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression)) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        if (expression instanceof PsiMethodCallExpression) {
            return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, (? super PsiExpression expr) -> ((PsiMethodCallExpression)expr).resolveMethod());
        }
        if (expression instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression)) == null) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        if (expression instanceof PsiSwitchExpression) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression, PsiMethod method) {
        return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, (? super PsiExpression e) -> method);
    }

    private static boolean isMethodCallPolyExpression(PsiExpression expression, Function<? super PsiExpression, ? extends PsiMethod> methodResolver) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression) && ((PsiCallExpression)expression).getTypeArguments().length == 0) {
            PsiMethod method = methodResolver.apply(expression);
            return method == null || PsiPolyExpressionUtil.isMethodCallTypeDependsOnInference(expression, method);
        }
        return false;
    }

    private static boolean isMethodCallTypeDependsOnInference(PsiExpression expression, PsiMethod method) {
        Set<PsiTypeParameter> typeParameters = ContainerUtil.set(method.getTypeParameters());
        if (!typeParameters.isEmpty()) {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                return PsiTypesUtil.mentionsTypeParameters(returnType, typeParameters);
            }
        } else if (method.isConstructor() && expression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression)) {
            return true;
        }
        return false;
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isSwitchExpressionAssignmentOrInvocationContext(expr) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isSwitchExpressionAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr).getParent();
        if (parent instanceof PsiExpressionStatement && parent.getParent() instanceof PsiSwitchLabeledRuleStatement || parent instanceof PsiBreakStatement || parent instanceof PsiYieldStatement || parent instanceof PsiThrowStatement) {
            PsiSwitchExpression switchExpression = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiSwitchExpression.class, true, PsiMember.class, PsiLambdaExpression.class);
            return switchExpression != null && PsiUtil.getSwitchResultExpressions(switchExpression).contains(expr) && PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(switchExpression);
        }
        return false;
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition(expr, context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable && !PsiPolyExpressionUtil.isVarContext((PsiVariable)context) || context instanceof PsiLambdaExpression;
    }

    private static boolean isVarContext(PsiVariable variable) {
        PsiTypeElement typeElement;
        return PsiUtil.isLanguageLevel10OrHigher(variable) && (typeElement = variable.getTypeElement()) != null && typeElement.isInferredType();
    }

    public static boolean isExpressionOfPrimitiveType(@Nullable PsiExpression arg) {
        if (arg != null && !PsiPolyExpressionUtil.isPolyExpression(arg)) {
            PsiType type2 = arg.getType();
            return type2 instanceof PsiPrimitiveType && type2 != PsiType.NULL;
        }
        if (arg instanceof PsiNewExpression || arg instanceof PsiFunctionalExpression) {
            return false;
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isExpressionOfPrimitiveType(((PsiParenthesizedExpression)arg).getExpression());
        }
        if (arg instanceof PsiConditionalExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)arg).resolveMethod();
            return method != null && method.getReturnType() instanceof PsiPrimitiveType;
        }
        if (arg instanceof PsiSwitchExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        assert (false) : arg;
        return false;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        JavaResolveResult result;
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type2 = null;
        if (expr instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)expr) || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type2 = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = (PsiMethod)(result = ((PsiMethodCallExpression)expr).getMethodExpression().advancedResolve(false)).getElement()) != null) {
            type2 = method.getReturnType();
            if (result instanceof MethodCandidateInfo) {
                PsiSubstitutor substitutor = ((MethodCandidateInfo)result).getSubstitutorFromQualifier();
                type2 = substitutor.substitute(type2);
            }
        }
        ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(type2);
        if (kind != null) {
            return kind;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == ConditionalKind.NULL) {
                return thenKind;
            }
            if (thenKind == ConditionalKind.NULL) {
                return elseKind;
            }
        }
        if (expr instanceof PsiSwitchExpression) {
            ConditionalKind switchKind = null;
            for (PsiExpression resultExpression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expr)) {
                ConditionalKind resultKind = PsiPolyExpressionUtil.isBooleanOrNumeric(resultExpression);
                if (resultKind == null) {
                    return null;
                }
                if (switchKind == null) {
                    switchKind = resultKind;
                    continue;
                }
                if (switchKind == resultKind) continue;
                if (switchKind == ConditionalKind.NULL) {
                    switchKind = resultKind;
                    continue;
                }
                if (resultKind == ConditionalKind.NULL) continue;
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static ConditionalKind isBooleanOrNumericType(PsiType type2) {
        if (type2 == PsiType.NULL) {
            return ConditionalKind.NULL;
        }
        if (TypeConversionUtil.isNumericType(type2)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type2)) {
            return ConditionalKind.BOOLEAN;
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC,
        NULL;

    }
}

