/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.stubs;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.AbstractExtensionPointBean;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointName;
import sqldelight.com.intellij.openapi.extensions.RequiredElement;
import sqldelight.com.intellij.psi.stubs.StubFieldAccessor;
import sqldelight.com.intellij.util.xmlb.annotations.Attribute;
import sqldelight.org.jetbrains.annotations.Nullable;

public class StubElementTypeHolderEP
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance(StubElementTypeHolderEP.class);
    public static final ExtensionPointName<StubElementTypeHolderEP> EP_NAME = ExtensionPointName.create("sqldelight.com.intellij.stubElementTypeHolder");
    @Attribute(value="class")
    @RequiredElement
    public String holderClass;
    @Attribute(value="externalIdPrefix")
    @Nullable
    public String externalIdPrefix;

    List<StubFieldAccessor> initializeOptimized() {
        try {
            if (this.externalIdPrefix != null) {
                ArrayList<StubFieldAccessor> result = new ArrayList<StubFieldAccessor>();
                Class<?> aClass = Class.forName(this.holderClass, false, this.getLoaderForClass());
                assert (aClass.isInterface());
                for (Field field : aClass.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    result.add(new StubFieldAccessor(this.externalIdPrefix + field.getName(), field));
                }
                return result;
            }
            this.findExtensionClass(this.holderClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error(new PluginException(e, this.getPluginId()));
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void initialize() {
        this.findClassNoExceptions(this.holderClass);
    }

    public String toString() {
        return this.holderClass;
    }
}

