/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.progress.ProgressIndicator;
import sqldelight.com.intellij.util.Chunk;
import sqldelight.com.intellij.util.containers.Stack;
import sqldelight.com.intellij.util.graph.CachingSemiGraph;
import sqldelight.com.intellij.util.graph.DFSTBuilder;
import sqldelight.com.intellij.util.graph.Graph;
import sqldelight.com.intellij.util.graph.GraphAlgorithms;
import sqldelight.com.intellij.util.graph.GraphGenerator;
import sqldelight.com.intellij.util.graph.InboundSemiGraph;
import sqldelight.com.intellij.util.graph.impl.CycleFinder;
import sqldelight.com.intellij.util.graph.impl.KShortestPathsFinder;
import sqldelight.com.intellij.util.graph.impl.ShortestPathFinder;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class GraphAlgorithmsImpl
extends GraphAlgorithms {
    @Override
    public <Node> List<Node> findShortestPath(@NotNull Graph<Node> graph, @NotNull Node start, @NotNull Node finish) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(0);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(2);
        }
        return this.findShortestPath((InboundSemiGraph<Node>)graph, start, finish);
    }

    @Override
    @Nullable
    public <Node> List<Node> findShortestPath(@NotNull InboundSemiGraph<Node> graph, @NotNull Node start, @NotNull Node finish) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(3);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(4);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(5);
        }
        return new ShortestPathFinder<Node>(graph).findPath(start, finish);
    }

    @Override
    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph, @NotNull Node start, @NotNull Node finish, int k, @NotNull ProgressIndicator progressIndicator) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(6);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(7);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(8);
        }
        if (progressIndicator == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(9);
        }
        List<List<Node>> list = new KShortestPathsFinder<Node>(graph, start, finish, progressIndicator).findShortestPaths(k);
        if (list == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph, @NotNull Node node) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(11);
        }
        if (node == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(12);
        }
        Set<List<Node>> set = new CycleFinder<Node>(graph).getNodeCycles(node);
        if (set == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Override
    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(14);
        }
        return new Graph<Node>(){

            @Override
            @NotNull
            public Collection<Node> getNodes() {
                Collection collection = graph.getNodes();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @Override
            @NotNull
            public Iterator<Node> getIn(Node n) {
                Iterator iterator = graph.getOut(n);
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            @Override
            @NotNull
            public Iterator<Node> getOut(Node n) {
                Iterator iterator = graph.getIn(n);
                if (iterator == null) {
                    1.$$$reportNull$$$0(2);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/graph/impl/GraphAlgorithmsImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(15);
        }
        DFSTBuilder<Node> builder = new DFSTBuilder<Node>(graph);
        Collection<Collection<Node>> components = builder.getComponents();
        final ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(components.size());
        final LinkedHashMap<Node, Chunk<Node>> nodeToChunkMap = new LinkedHashMap<Node, Chunk<Node>>();
        for (Collection<Node> component : components) {
            Set<Node> chunkNodes = component.size() == 1 ? Collections.singleton(component.iterator().next()) : new LinkedHashSet<Node>(component);
            Chunk<Node> chunk = new Chunk<Node>(chunkNodes);
            chunks.add(chunk);
            for (Node node : component) {
                nodeToChunkMap.put(node, chunk);
            }
        }
        Graph<Chunk<Node>> graph2 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Chunk<Node>>(){

            @Override
            @NotNull
            public Collection<Chunk<Node>> getNodes() {
                List list = chunks;
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @NotNull
            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet<Chunk> ins = new LinkedHashSet<Chunk>();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add((Chunk)nodeToChunkMap.get(in));
                    }
                }
                Iterator iterator = ins.iterator();
                if (iterator == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "sqldelight/com/intellij/util/graph/impl/GraphAlgorithmsImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(16);
        }
        return graph2;
    }

    @Override
    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph, Node start, Set<? super Node> set) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(17);
        }
        if (!set.add(start)) {
            return;
        }
        Stack<Node> stack = new Stack<Node>();
        stack.push(start);
        while (!stack.empty()) {
            Object currentNode = stack.pop();
            Iterator<Node> successorIterator = graph.getOut(currentNode);
            while (successorIterator.hasNext()) {
                Node successor = successorIterator.next();
                if (!set.add(successor)) continue;
                stack.push(successor);
            }
        }
    }

    @Override
    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph) {
        if (graph == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(18);
        }
        Collection<Chunk<Node>> collection = this.computeSCCGraph(graph).getNodes();
        if (collection == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @Override
    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<? extends List<Node>> paths) {
        if (paths == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(20);
        }
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        for (List<Node> path : paths) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result.add(path);
        }
        ArrayList<List<Node>> arrayList = result;
        if (arrayList == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findKShortestPaths";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSCCGraph";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStronglyConnectedComponents";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removePathsWithCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findShortestPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findKShortestPaths";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCycles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invertEdgeDirections";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeSCCGraph";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectOutsRecursively";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeStronglyConnectedComponents";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removePathsWithCycles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

