/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.EventDispatcher;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.concurrency.AppExecutorUtil;
import sqldelight.com.intellij.util.messages.MessageBus;
import sqldelight.com.intellij.util.messages.MessageBusConnection;
import sqldelight.com.intellij.util.messages.MessageBusOwner;
import sqldelight.com.intellij.util.messages.MessageHandler;
import sqldelight.com.intellij.util.messages.SimpleMessageBusConnection;
import sqldelight.com.intellij.util.messages.Topic;
import sqldelight.com.intellij.util.messages.impl.CompositeMessageBus;
import sqldelight.com.intellij.util.messages.impl.JobQueue;
import sqldelight.com.intellij.util.messages.impl.Message;
import sqldelight.com.intellij.util.messages.impl.MessageBusConnectionImpl;
import sqldelight.com.intellij.util.messages.impl.MessageDeliveryListener;
import sqldelight.com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    protected static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final int DISPOSE_IN_PROGRESS = 1;
    private static final int DISPOSED_STATE = 2;
    private static final Object NA = new Object();
    protected final ThreadLocal<JobQueue> myMessageQueue;
    protected final int[] myOrder;
    protected final ConcurrentMap<Topic<?>, Object> publisherCache;
    protected final Collection<MessageHandlerHolder> mySubscribers;
    protected final Map<Topic<?>, List<Object>> subscriberCache;
    @Nullable
    protected final CompositeMessageBus myParentBus;
    protected final RootBus myRootBus;
    protected final MessageBusOwner owner;
    private int disposeState;
    private Disposable myConnectionDisposable;
    protected MessageDeliveryListener messageDeliveryListener;

    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(0);
        }
        if (parentBus == null) {
            MessageBusImpl.$$$reportNull$$$0(1);
        }
        this.myMessageQueue = ThreadLocal.withInitial(JobQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.mySubscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.myConnectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.myParentBus = parentBus;
        this.myRootBus = parentBus.myRootBus;
        MessageBusImpl p = this;
        while ((p = p.myParentBus) != null) {
            p.subscriberCache.clear();
        }
        this.myOrder = parentBus.addChild(this);
    }

    MessageBusImpl(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        this.myMessageQueue = ThreadLocal.withInitial(JobQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.mySubscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.myConnectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.myOrder = ArrayUtil.EMPTY_INT_ARRAY;
        this.myRootBus = (RootBus)this;
        this.myParentBus = null;
    }

    @Override
    public final MessageBus getParent() {
        return this.myParentBus;
    }

    public final String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ")";
    }

    @Override
    @NotNull
    public final MessageBusConnection connect() {
        return this.connect(this.myConnectionDisposable);
    }

    @Override
    @NotNull
    public final MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.mySubscribers.add(connection);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.mySubscribers.add(connection);
        SimpleMessageBusConnectionImpl simpleMessageBusConnectionImpl = connection;
        if (simpleMessageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return simpleMessageBusConnectionImpl;
    }

    @Override
    @NotNull
    public final <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        this.checkNotDisposed();
        Object object = this.publisherCache.computeIfAbsent(topic, this::createPublisherInvocationHandler);
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)object;
    }

    @NotNull
    private Object createPublisherInvocationHandler(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        Class<?> listenerClass = topic.getListenerClass();
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)this.createPublisher(topic, topic.getBroadcastDirection()));
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    protected MessagePublisher createPublisher(@NotNull Topic<?> topic, Topic.BroadcastDirection direction) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new ToParentMessagePublisher(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
        }
        LOG.warn("Broadcast direction TO_CHILDREN  is not allowed for module level message bus. Please change to NONE or TO_PARENT");
        return new MessagePublisher(topic, this);
    }

    protected static List<Throwable> executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, Object[] args, @NotNull List<Object> handlers, @Nullable JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        if (method == null) {
            MessageBusImpl.$$$reportNull$$$0(12);
        }
        if (handlers == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        if (jobQueue == null) {
            for (Object handler : handlers) {
                exceptions = MessageBusImpl.invokeListener(method, args, handler, topic, messageDeliveryListener, exceptions);
            }
        } else {
            jobQueue.queue.offerLast(new Message(topic, method, args, handlers));
        }
        return exceptions;
    }

    public final void disposeConnectionChildren() {
        this.disposeState = 1;
        Disposer.disposeChildren(this.myConnectionDisposable);
    }

    public final void disposeConnection() {
        Disposer.dispose(this.myConnectionDisposable);
        this.myConnectionDisposable = null;
    }

    @Override
    public void dispose() {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        this.disposeState = 2;
        this.disposeChildren();
        if (this.myConnectionDisposable != null) {
            Disposer.dispose(this.myConnectionDisposable);
        }
        JobQueue jobs = this.myMessageQueue.get();
        this.myMessageQueue.remove();
        if (!jobs.queue.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        if (this.myParentBus == null) {
            this.myRootBus.myWaitingBuses.remove();
        } else {
            this.myParentBus.onChildBusDisposed(this);
        }
    }

    protected void disposeChildren() {
    }

    @Override
    public final boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    @Override
    public final boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        if (this.isDisposed()) {
            return false;
        }
        Set waitingBuses = this.myRootBus.myWaitingBuses.get();
        if (waitingBuses == null || waitingBuses.isEmpty()) {
            return false;
        }
        for (MessageBusImpl bus : waitingBuses) {
            JobQueue jobQueue = bus.myMessageQueue.get();
            Message current = jobQueue.current;
            if (current != null && current.topic == topic) {
                return true;
            }
            for (Message message : jobQueue.queue) {
                if (message.topic != topic) continue;
                return true;
            }
        }
        return false;
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    protected void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result, boolean subscribeLazyListeners) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        if (result == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        for (MessageHandlerHolder subscriber : this.mySubscribers) {
            subscriber.collectHandlers(topic, result);
        }
    }

    @NotNull
    protected List<Object> computeSubscribers(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.doComputeSubscribers(topic, result, true);
        List<Object> list = result.isEmpty() ? Collections.emptyList() : result;
        if (list == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    private void jobRemoved(@NotNull JobQueue jobQueue) {
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        if (jobQueue.current == null && jobQueue.queue.isEmpty()) {
            this.myRootBus.myWaitingBuses.get().remove(this);
        }
    }

    private static void pumpMessages(@NotNull Set<MessageBusImpl> waitingBuses) {
        if (waitingBuses == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(waitingBuses.size());
        for (MessageBusImpl bus : waitingBuses) {
            if (bus.isDisposed()) {
                waitingBuses.remove(bus);
                LOG.error("Accessing disposed message bus " + bus);
                continue;
            }
            liveBuses.add(bus);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl bus : buses) {
            if (bus.isDisposed()) continue;
            JobQueue jobQueue = bus.myMessageQueue.get();
            Message job = jobQueue.current;
            if (job != null) {
                exceptions = bus.deliverMessage(job, jobQueue, bus.messageDeliveryListener, exceptions);
            }
            while ((job = jobQueue.queue.pollFirst()) != null) {
                exceptions = bus.deliverMessage(job, jobQueue, bus.messageDeliveryListener, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private List<Throwable> deliverMessage(@NotNull Message job, @NotNull JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (job == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        jobQueue.current = job;
        List<Object> handlers = job.handlers;
        int index = job.currentHandlerIndex;
        int size = handlers.size();
        int lastIndex = size - 1;
        while (index < size) {
            if (index == lastIndex) {
                jobQueue.current = null;
                this.jobRemoved(jobQueue);
            }
            ++job.currentHandlerIndex;
            exceptions = MessageBusImpl.invokeListener(job.listenerMethod, job.args, handlers.get(index), job.topic, messageDeliveryListener, exceptions);
            if (++index == job.currentHandlerIndex) continue;
            return exceptions;
        }
        return exceptions;
    }

    protected boolean hasChildren() {
        return false;
    }

    final void notifyOnSubscription(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while ((parentBus = parentBus.myParentBus) != null) {
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    protected void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
    }

    protected void removeChildConnectionsRecursively(@NotNull Topic<?> topic, @Nullable Object handlers) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
    }

    protected void clearSubscriberCacheRecursively(@Nullable Map<Topic<?>, Object> handlers, @Nullable Topic<?> topic) {
        MessageBusImpl.clearSubscriberCache(this, handlers, topic);
    }

    protected static boolean clearSubscriberCache(@NotNull MessageBusImpl bus, @Nullable Map<Topic<?>, Object> handlers, @Nullable Topic<?> singleTopic) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        if (handlers == null) {
            if (singleTopic == null) {
                bus.subscriberCache.clear();
                return true;
            }
            return bus.subscriberCache.remove(singleTopic) != null;
        }
        ToChildrenTopicSubscriberCleaner cleaner = new ToChildrenTopicSubscriberCleaner(bus);
        handlers.forEach(cleaner);
        return cleaner.removed;
    }

    protected void removeEmptyConnectionsRecursively() {
        this.mySubscribers.removeIf(MessageHandlerHolder::isDisposed);
    }

    boolean notifyConnectionTerminated(Object[] topicAndHandlerPairs) {
        if (this.disposeState != 0) {
            return false;
        }
        this.myRootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImpl.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    private static boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, @NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        boolean isChildClearingNeeded = false;
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Topic.BroadcastDirection direction;
            Topic topic = (Topic)topicAndHandlerPairs[i];
            if (bus.subscriberCache.remove(topic) != null) {
                bus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if ((direction = topic.getBroadcastDirection()) != Topic.BroadcastDirection.TO_CHILDREN) continue;
            MessageBusImpl parentBus = bus;
            while ((parentBus = parentBus.myParentBus) != null) {
                if (parentBus.subscriberCache.remove(topic) == null) continue;
                parentBus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if (!bus.hasChildren()) continue;
            isChildClearingNeeded = true;
        }
        return isChildClearingNeeded;
    }

    protected void clearSubscriberCache(Object[] topicAndHandlerPairs) {
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            this.subscriberCache.remove(topicAndHandlerPairs[i]);
        }
    }

    final void deliverImmediately(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        if (this.owner.isDisposed()) {
            return;
        }
        JobQueue jobQueue = this.myMessageQueue.get();
        Deque<Message> jobs = jobQueue.queue;
        if (jobs.isEmpty()) {
            return;
        }
        SmartList<Message> newJobs = null;
        Iterator<Message> jobIterator = jobs.iterator();
        while (jobIterator.hasNext()) {
            Message filteredJob;
            Message job = jobIterator.next();
            SmartList<Object> connectionHandlers = null;
            Iterator<Object> handlerIterator = job.handlers.iterator();
            while (handlerIterator.hasNext()) {
                Object handler = handlerIterator.next();
                if (!connection.isMyHandler(job.topic, handler)) continue;
                handlerIterator.remove();
                if (connectionHandlers == null) {
                    connectionHandlers = new SmartList<Object>();
                }
                connectionHandlers.add(handler);
            }
            if (connectionHandlers == null) continue;
            if (job.handlers.isEmpty()) {
                jobIterator.remove();
                filteredJob = job;
                job.handlers.addAll(connectionHandlers);
            } else {
                filteredJob = new Message(job.topic, job.listenerMethod, job.args, (List<Object>)connectionHandlers);
            }
            if (newJobs == null) {
                newJobs = new SmartList<Message>();
            }
            newJobs.add(filteredJob);
        }
        if (newJobs == null) {
            return;
        }
        for (int i = newJobs.size() - 1; i >= 0; --i) {
            jobs.addFirst((Message)newJobs.get(i));
        }
        List<Throwable> exceptions = null;
        for (Message job : newJobs) {
            jobs.removeFirstOccurrence(job);
            exceptions = this.deliverMessage(job, jobQueue, this.messageDeliveryListener, exceptions);
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    public final void setMessageDeliveryListener(@Nullable MessageDeliveryListener listener) {
        if (this.messageDeliveryListener != null && listener != null) {
            throw new IllegalStateException("Already set: " + this.messageDeliveryListener);
        }
        this.messageDeliveryListener = listener;
    }

    @Nullable
    private static List<Throwable> invokeListener(@NotNull Method method, Object[] args, @NotNull Object handler, @NotNull Topic<?> topic, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (method == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        if (handler == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        try {
            if (handler instanceof MessageHandler) {
                ((MessageHandler)handler).handle(method, args);
            } else if (messageDeliveryListener == null) {
                method.invoke(handler, args);
            } else {
                long startTime = System.nanoTime();
                method.invoke(handler, args);
                messageDeliveryListener.messageDelivered(topic, method.getName(), handler, System.nanoTime() - startTime);
            }
        }
        catch (Throwable e) {
            exceptions = EventDispatcher.handleException(e, exceptions);
        }
        return exceptions;
    }

    protected void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        if (predicate == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        for (MessageHandlerHolder holder : this.mySubscribers) {
            holder.disconnectIfNeeded(predicate);
        }
    }

    private void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        if (handler == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        JobQueue jobQueue = this.myMessageQueue.get();
        if (!jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> job.topic == topic && job.handlers.removeIf(it -> it == handler) && job.handlers.isEmpty())) {
            this.jobRemoved(jobQueue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobQueue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingBuses";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleConnect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublisherInvocationHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPublisherInvocationHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeOrAddToQueue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "jobRemoved";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "pumpMessages";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeChildConnectionsRecursively";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCache";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCacheOnConnectionTerminated";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deliverImmediately";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeDisposedHandlers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends CompositeMessageBus {
        private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
        private final AtomicInteger emptyConnectionCounter;
        final ThreadLocal<SortedSet<MessageBusImpl>> myWaitingBuses;

        RootBus(@NotNull MessageBusOwner owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.compactionFutureRef = new AtomicReference();
            this.emptyConnectionCounter = new AtomicInteger();
            this.myWaitingBuses = ThreadLocal.withInitial(() -> new TreeSet((bus1, bus2) -> ArrayUtil.lexicographicCompare(bus1.myOrder, bus2.myOrder)));
        }

        void scheduleEmptyConnectionRemoving() {
            CompletableFuture<Void> future;
            int counter = this.emptyConnectionCounter.incrementAndGet();
            if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
                return;
            }
            CompletableFuture<?> oldFuture = this.compactionFutureRef.get();
            if (oldFuture == null && !this.compactionFutureRef.compareAndSet(null, future = CompletableFuture.runAsync(() -> {
                this.removeEmptyConnectionsRecursively();
                this.compactionFutureRef.set(null);
            }, AppExecutorUtil.getAppExecutorService()))) {
                future.cancel(false);
            }
        }

        void _removeEmptyConnectionsRecursively() {
            this.removeEmptyConnectionsRecursively();
        }

        @Override
        public void dispose() {
            CompletableFuture compactionFuture = this.compactionFutureRef.getAndSet(null);
            if (compactionFuture != null) {
                compactionFuture.cancel(false);
            }
            super.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "sqldelight/com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    private static final class ToChildrenTopicSubscriberCleaner
    implements BiConsumer<Topic<?>, Object> {
        private final MessageBusImpl bus;
        boolean removed;

        ToChildrenTopicSubscriberCleaner(@NotNull MessageBusImpl bus) {
            if (bus == null) {
                ToChildrenTopicSubscriberCleaner.$$$reportNull$$$0(0);
            }
            this.bus = bus;
        }

        @Override
        public void accept(Topic<?> topic, Object __) {
            Topic.BroadcastDirection direction = topic.getBroadcastDirection();
            if (direction == Topic.BroadcastDirection.TO_CHILDREN && this.bus.subscriberCache.remove(topic) != null) {
                this.removed = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "sqldelight/com/intellij/util/messages/impl/MessageBusImpl$ToChildrenTopicSubscriberCleaner", "<init>"));
        }
    }

    protected static final class ToParentMessagePublisher
    extends MessagePublisher
    implements InvocationHandler {
        ToParentMessagePublisher(@NotNull Topic<?> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            if (method == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            MessageBusImpl parentBus = this.bus;
            boolean hasHandlers = false;
            do {
                List handlers;
                if ((handlers = parentBus.subscriberCache.computeIfAbsent(this.topic, parentBus::computeSubscribers)).isEmpty()) continue;
                hasHandlers = true;
                exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, exceptions);
            } while ((parentBus = parentBus.myParentBus) != null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/util/messages/impl/MessageBusImpl$ToParentMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MessagePublisher
    implements InvocationHandler {
        @NotNull
        protected final Topic<?> topic;
        @NotNull
        protected final MessageBusImpl bus;

        MessagePublisher(@NotNull Topic<?> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                MessagePublisher.$$$reportNull$$$0(1);
            }
            this.topic = topic;
            this.bus = bus;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) {
            JobQueue jobQueue;
            Set busQueue;
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy, args, method.getName());
            }
            this.bus.checkNotDisposed();
            boolean isImmediateDelivery = this.topic.isImmediateDelivery();
            if (isImmediateDelivery) {
                busQueue = null;
                jobQueue = null;
            } else {
                busQueue = this.bus.myRootBus.myWaitingBuses.get();
                jobQueue = this.bus.myMessageQueue.get();
                MessageBusImpl.pumpMessages(busQueue);
            }
            if (this.publish(method, args, jobQueue) && !isImmediateDelivery) {
                busQueue.add(this.bus);
                MessageBusImpl.pumpMessages(busQueue);
            }
            return NA;
        }

        protected boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(2);
            }
            List handlers = this.bus.subscriberCache.computeIfAbsent(this.topic, this.bus::computeSubscribers);
            if (handlers.isEmpty()) {
                return false;
            }
            List<Throwable> exceptions = MessageBusImpl.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/util/messages/impl/MessageBusImpl$MessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface MessageHandlerHolder {
        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<Object> var2);

        public void disconnectIfNeeded(@NotNull Predicate<Class<?>> var1);

        public boolean isDisposed();
    }
}

