/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.text;

import sqldelight.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import sqldelight.com.intellij.openapi.util.text.Strings;
import sqldelight.com.intellij.util.text.CharArrayExternalizable;
import sqldelight.com.intellij.util.text.CharArrayUtil;
import sqldelight.com.intellij.util.text.StringFactory;
import sqldelight.org.jetbrains.annotations.NotNull;

public class CharSequenceSubSequence
implements CharSequence,
CharArrayExternalizable,
CharSequenceWithStringHash {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence chars) {
        if (chars == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length());
    }

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start, int end) {
        if (chars == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(1);
        }
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars.charAt(index + this.myStart);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            CharSequenceSubSequence charSequenceSubSequence = this;
            if (charSequenceSubSequence == null) {
                CharSequenceSubSequence.$$$reportNull$$$0(2);
            }
            return charSequenceSubSequence;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myChars instanceof String) {
            String string = ((String)this.myChars).substring(this.myStart, this.myEnd);
            if (string == null) {
                CharSequenceSubSequence.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = StringFactory.createShared(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
        if (string == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    CharSequence getBaseSequence() {
        CharSequence charSequence = this.myChars;
        if (charSequence == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @Override
    public void getChars(int start, int end, char @NotNull [] dest, int destPos) {
        if (dest == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(6);
        }
        assert (end - start <= this.myEnd - this.myStart);
        CharArrayUtil.getChars(this.myChars, dest, start + this.myStart, destPos, end - start);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/text/CharSequenceSubSequence";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/text/CharSequenceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

