/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.NamedParameterSpec;
import sqldelight.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import sqldelight.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqldelight.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import sqldelight.org.bouncycastle.crypto.CryptoServicesRegistrar;
import sqldelight.org.bouncycastle.crypto.KeyGenerationParameters;
import sqldelight.org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import sqldelight.org.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import sqldelight.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import sqldelight.org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import sqldelight.org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import sqldelight.org.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import sqldelight.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import sqldelight.org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPrivateKey;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec.BC11XDHPublicKey;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import sqldelight.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import sqldelight.org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import sqldelight.org.bouncycastle.jcajce.spec.XDHParameterSpec;
import sqldelight.org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;

public class KeyPairGeneratorSpi
extends java.security.KeyPairGeneratorSpi {
    private static final int EdDSA = -1;
    private static final int XDH = -2;
    private static final int Ed448 = 0;
    private static final int Ed25519 = 1;
    private static final int X448 = 2;
    private static final int X25519 = 3;
    private int algorithm;
    private AsymmetricCipherKeyPairGenerator generator;
    private boolean initialised;
    private SecureRandom secureRandom;

    KeyPairGeneratorSpi(int n, AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator) {
        this.algorithm = n;
        this.generator = asymmetricCipherKeyPairGenerator;
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        try {
            block1 : switch (n) {
                case 255: 
                case 256: {
                    switch (this.algorithm) {
                        case -1: 
                        case 1: {
                            this.algorithmCheck(1);
                            this.generator = new Ed25519KeyPairGenerator();
                            this.setupGenerator(1);
                            break block1;
                        }
                        case -2: 
                        case 3: {
                            this.algorithmCheck(3);
                            this.generator = new X25519KeyPairGenerator();
                            this.setupGenerator(3);
                            break block1;
                        }
                    }
                    throw new InvalidParameterException("key size not configurable");
                }
                case 448: {
                    switch (this.algorithm) {
                        case -1: 
                        case 0: {
                            this.algorithmCheck(0);
                            this.generator = new Ed448KeyPairGenerator();
                            this.setupGenerator(0);
                            break block1;
                        }
                        case -2: 
                        case 2: {
                            this.algorithmCheck(2);
                            this.generator = new X448KeyPairGenerator();
                            this.setupGenerator(2);
                            break block1;
                        }
                    }
                    throw new InvalidParameterException("key size not configurable");
                }
                default: {
                    throw new InvalidParameterException("unknown key size");
                }
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.secureRandom = secureRandom;
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            this.initializeGenerator(((ECGenParameterSpec)algorithmParameterSpec).getName());
        } else if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            this.initializeGenerator(((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName());
        } else if (algorithmParameterSpec instanceof NamedParameterSpec) {
            this.initializeGenerator(((NamedParameterSpec)algorithmParameterSpec).getName());
        } else if (algorithmParameterSpec instanceof EdDSAParameterSpec) {
            this.initializeGenerator(((EdDSAParameterSpec)algorithmParameterSpec).getCurveName());
        } else if (algorithmParameterSpec instanceof XDHParameterSpec) {
            this.initializeGenerator(((XDHParameterSpec)algorithmParameterSpec).getCurveName());
        } else {
            String string = ECUtil.getNameFrom((AlgorithmParameterSpec)algorithmParameterSpec);
            if (string != null) {
                this.initializeGenerator(string);
            } else {
                throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + algorithmParameterSpec);
            }
        }
    }

    private void algorithmCheck(int n) throws InvalidAlgorithmParameterException {
        if (this.algorithm != n) {
            if (this.algorithm == 1 || this.algorithm == 0) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == -1 && n != 1 && n != 0) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == 3 || this.algorithm == 2) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            if (this.algorithm == -2 && n != 3 && n != 2) {
                throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
            }
            this.algorithm = n;
        }
    }

    private void initializeGenerator(String string) throws InvalidAlgorithmParameterException {
        if (string.equalsIgnoreCase("Ed448") || string.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
            this.algorithmCheck(0);
            this.generator = new Ed448KeyPairGenerator();
            this.setupGenerator(0);
        } else if (string.equalsIgnoreCase("Ed25519") || string.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
            this.algorithmCheck(1);
            this.generator = new Ed25519KeyPairGenerator();
            this.setupGenerator(1);
        } else if (string.equalsIgnoreCase("X448") || string.equals(EdECObjectIdentifiers.id_X448.getId())) {
            this.algorithmCheck(2);
            this.generator = new X448KeyPairGenerator();
            this.setupGenerator(2);
        } else if (string.equalsIgnoreCase("X25519") || string.equals(EdECObjectIdentifiers.id_X25519.getId())) {
            this.algorithmCheck(3);
            this.generator = new X25519KeyPairGenerator();
            this.setupGenerator(3);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.generator == null) {
            throw new IllegalStateException("generator not correctly initialized");
        }
        if (!this.initialised) {
            this.setupGenerator(this.algorithm);
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.generator.generateKeyPair();
        switch (this.algorithm) {
            case 0: {
                return new KeyPair((PublicKey)new BCEdDSAPublicKey(asymmetricCipherKeyPair.getPublic()), (PrivateKey)new BCEdDSAPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
            case 1: {
                return new KeyPair((PublicKey)new BCEdDSAPublicKey(asymmetricCipherKeyPair.getPublic()), (PrivateKey)new BCEdDSAPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
            case 2: {
                return new KeyPair((PublicKey)new BC11XDHPublicKey(asymmetricCipherKeyPair.getPublic()), (PrivateKey)new BC11XDHPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
            case 3: {
                return new KeyPair((PublicKey)new BC11XDHPublicKey(asymmetricCipherKeyPair.getPublic()), (PrivateKey)new BC11XDHPrivateKey(asymmetricCipherKeyPair.getPrivate()));
            }
        }
        throw new IllegalStateException("generator not correctly initialized");
    }

    private void setupGenerator(int n) {
        this.initialised = true;
        if (this.secureRandom == null) {
            this.secureRandom = CryptoServicesRegistrar.getSecureRandom();
        }
        switch (n) {
            case 0: {
                this.generator.init((KeyGenerationParameters)new Ed448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -1: 
            case 1: {
                this.generator.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(this.secureRandom));
                break;
            }
            case 2: {
                this.generator.init((KeyGenerationParameters)new X448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -2: 
            case 3: {
                this.generator.init((KeyGenerationParameters)new X25519KeyGenerationParameters(this.secureRandom));
            }
        }
    }
}

