/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.alecstrong.sql.psi.core;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.roots.ContentIterator;
import sqldelight.com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileSystem;
import sqldelight.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lsqldelight/com/alecstrong/sql/psi/core/CoreFileIndex;", "Lsqldelight/com/intellij/openapi/roots/impl/ProjectFileIndexImpl;", "sourceFolders", "", "Ljava/io/File;", "localFileSystem", "Lsqldelight/com/intellij/openapi/vfs/VirtualFileSystem;", "project", "Lsqldelight/com/intellij/openapi/project/Project;", "(Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFileSystem;Lcom/intellij/openapi/project/Project;)V", "getSourceFolders", "()Ljava/util/List;", "iterateContent", "", "iterator", "Lsqldelight/com/intellij/openapi/roots/ContentIterator;", "iterateContentUnderDirectory", "file", "Lsqldelight/com/intellij/openapi/vfs/VirtualFile;", "core"})
final class CoreFileIndex
extends ProjectFileIndexImpl {
    @NotNull
    private final List<File> sourceFolders;
    @NotNull
    private final VirtualFileSystem localFileSystem;

    public CoreFileIndex(@NotNull List<? extends File> sourceFolders, @NotNull VirtualFileSystem localFileSystem, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(sourceFolders, (String)"sourceFolders");
        Intrinsics.checkNotNullParameter((Object)localFileSystem, (String)"localFileSystem");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.sourceFolders = sourceFolders;
        this.localFileSystem = localFileSystem;
    }

    @NotNull
    public final List<File> getSourceFolders() {
        return this.sourceFolders;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator iterator) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
            Iterable $this$all$iv = this.sourceFolders;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VirtualFile file;
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (this.localFileSystem.findFileByPath(it.getAbsolutePath()) == null) {
                        throw new NullPointerException("File " + it.getAbsolutePath() + " not found");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"localFileSystem.findFile\u2026absolutePath} not found\")");
                    if (this.iterateContentUnderDirectory(file, iterator)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile file, @NotNull ContentIterator iterator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        if (file.isDirectory()) {
            VirtualFile[] virtualFileArray = file.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"file.children");
            Object[] $this$forEach$iv = virtualFileArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.iterateContentUnderDirectory(it, iterator)) continue;
                return false;
            }
            return true;
        }
        return iterator.processFile(file);
    }
}

