/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.github.benmanes.caffeine.cache;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.checkerframework.checker.nullness.qual.Nullable;
import sqldelight.com.github.benmanes.caffeine.cache.BoundedLocalCache;
import sqldelight.com.github.benmanes.caffeine.cache.CacheLoader;
import sqldelight.com.github.benmanes.caffeine.cache.Caffeine;

final class LocalCacheFactory {
    public static final String MAXIMUM = "maximum";
    public static final String WINDOW_MAXIMUM = "windowMaximum";
    public static final String MAIN_PROTECTED_MAXIMUM = "mainProtectedMaximum";
    public static final String WEIGHTED_SIZE = "weightedSize";
    public static final String WINDOW_WEIGHTED_SIZE = "windowWeightedSize";
    public static final String MAIN_PROTECTED_WEIGHTED_SIZE = "mainProtectedWeightedSize";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String ACCESS_TIME = "accessTime";
    public static final String WRITE_TIME = "writeTime";
    public static final MethodType FACTORY = MethodType.methodType(Void.TYPE, Caffeine.class, CacheLoader.class, Boolean.TYPE);
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private LocalCacheFactory() {
    }

    static <K, V> BoundedLocalCache<K, V> newBoundedLocalCache(Caffeine<K, V> caffeine, @Nullable CacheLoader<? super K, V> cacheLoader, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("sqldelight.com.github.benmanes.caffeine.cache.");
        if (caffeine.isStrongKeys()) {
            stringBuilder.append('S');
        } else {
            stringBuilder.append('W');
        }
        if (caffeine.isStrongValues()) {
            stringBuilder.append('S');
        } else {
            stringBuilder.append('I');
        }
        if (caffeine.removalListener != null) {
            stringBuilder.append('L');
        }
        if (caffeine.isRecordingStats()) {
            stringBuilder.append('S');
        }
        if (caffeine.evicts()) {
            stringBuilder.append('M');
            if (caffeine.isWeighted()) {
                stringBuilder.append('W');
            } else {
                stringBuilder.append('S');
            }
        }
        if (caffeine.expiresAfterAccess() || caffeine.expiresVariable()) {
            stringBuilder.append('A');
        }
        if (caffeine.expiresAfterWrite()) {
            stringBuilder.append('W');
        }
        if (caffeine.refreshAfterWrite()) {
            stringBuilder.append('R');
        }
        try {
            Class<?> clazz = Class.forName(stringBuilder.toString());
            MethodHandle methodHandle = LOOKUP.findConstructor(clazz, FACTORY);
            return methodHandle.invoke(caffeine, cacheLoader, bl);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(stringBuilder.toString(), throwable);
        }
    }
}

