/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.github.benmanes.caffeine.cache;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.ReferenceQueue;
import sqldelight.com.github.benmanes.caffeine.cache.Caffeine;
import sqldelight.com.github.benmanes.caffeine.cache.Node;
import sqldelight.com.github.benmanes.caffeine.cache.References;
import sqldelight.com.github.benmanes.caffeine.cache.Weigher;

interface NodeFactory<K, V> {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String ACCESS_TIME = "accessTime";
    public static final String WRITE_TIME = "writeTime";
    public static final Object RETIRED_STRONG_KEY = new Object();
    public static final Object DEAD_STRONG_KEY = new Object();
    public static final References.WeakKeyReference<Object> RETIRED_WEAK_KEY = new References.WeakKeyReference<Object>(null, null);
    public static final References.WeakKeyReference<Object> DEAD_WEAK_KEY = new References.WeakKeyReference<Object>(null, null);
    public static final MethodType FACTORY = MethodType.methodType(Void.TYPE);
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public Node<K, V> newNode(K var1, ReferenceQueue<K> var2, V var3, ReferenceQueue<V> var4, int var5, long var6);

    public Node<K, V> newNode(Object var1, V var2, ReferenceQueue<V> var3, int var4, long var5);

    default public Object newReferenceKey(K k, ReferenceQueue<K> referenceQueue) {
        return k;
    }

    default public Object newLookupKey(Object object) {
        return object;
    }

    public static <K, V> NodeFactory<K, V> newFactory(Caffeine<K, V> caffeine, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("sqldelight.com.github.benmanes.caffeine.cache.");
        if (caffeine.isStrongKeys()) {
            stringBuilder.append('P');
        } else {
            stringBuilder.append('F');
        }
        if (caffeine.isStrongValues()) {
            stringBuilder.append('S');
        } else if (caffeine.isWeakValues()) {
            stringBuilder.append('W');
        } else {
            stringBuilder.append('D');
        }
        if (caffeine.expiresVariable()) {
            if (caffeine.refreshAfterWrite()) {
                stringBuilder.append('A');
                if (caffeine.evicts()) {
                    stringBuilder.append('W');
                }
            } else {
                stringBuilder.append('W');
            }
        } else {
            if (caffeine.expiresAfterAccess()) {
                stringBuilder.append('A');
            }
            if (caffeine.expiresAfterWrite()) {
                stringBuilder.append('W');
            }
        }
        if (caffeine.refreshAfterWrite()) {
            stringBuilder.append('R');
        }
        if (caffeine.evicts()) {
            stringBuilder.append('M');
            if (bl || caffeine.isWeighted() && caffeine.weigher != Weigher.singletonWeigher()) {
                stringBuilder.append('W');
            } else {
                stringBuilder.append('S');
            }
        }
        try {
            Class<?> clazz = Class.forName(stringBuilder.toString());
            MethodHandle methodHandle = LOOKUP.findConstructor(clazz, FACTORY);
            return methodHandle.invoke();
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(stringBuilder.toString(), throwable);
        }
    }

    default public boolean weakValues() {
        return false;
    }

    default public boolean softValues() {
        return false;
    }
}

