/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.github.benmanes.caffeine.cache;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sqldelight.com.github.benmanes.caffeine.cache.DisabledScheduler;
import sqldelight.com.github.benmanes.caffeine.cache.ExecutorServiceScheduler;
import sqldelight.com.github.benmanes.caffeine.cache.GuardedScheduler;
import sqldelight.com.github.benmanes.caffeine.cache.SystemScheduler;

@FunctionalInterface
public interface Scheduler {
    public Future<?> schedule(Executor var1, Runnable var2, long var3, TimeUnit var5);

    public static Scheduler disabledScheduler() {
        return DisabledScheduler.INSTANCE;
    }

    public static Scheduler systemScheduler() {
        return SystemScheduler.INSTANCE;
    }

    public static Scheduler forScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return new ExecutorServiceScheduler(scheduledExecutorService);
    }

    public static Scheduler guardedScheduler(Scheduler scheduler) {
        return scheduler instanceof GuardedScheduler ? scheduler : new GuardedScheduler(scheduler);
    }
}

