/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import sqldelight.com.intellij.BundleBase;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.reference.SoftReference;
import sqldelight.com.intellij.util.DefaultBundleService;
import sqldelight.com.intellij.util.containers.CollectionFactory;
import sqldelight.com.intellij.util.lang.UrlClassLoader;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.Nls;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();
    private Reference<ResourceBundle> myBundle;
    private Reference<ResourceBundle> myDefaultBundle;
    @NonNls
    private final String myPathToBundle;

    public AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(0);
        }
        this.myPathToBundle = pathToBundle;
    }

    @ApiStatus.Internal
    @NotNull
    public static ResourceBundle.Control getControl() {
        MyResourceControl myResourceControl = MyResourceControl.INSTANCE;
        if (myResourceControl == null) {
            AbstractBundle.$$$reportNull$$$0(1);
        }
        return myResourceControl;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getMessage(@NotNull @NonNls String key, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(2);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(3);
        }
        String string = BundleBase.messageOrDefault(this.getResourceBundle(this.getClass().getClassLoader()), key, null, params2);
        if (string == null) {
            AbstractBundle.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public String getPartialMessage(@NotNull @NonNls String key, int unassignedParams, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(5);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(6);
        }
        String string = BundleBase.partialMessage(this.getResourceBundle(), key, unassignedParams, params2);
        if (string == null) {
            AbstractBundle.$$$reportNull$$$0(7);
        }
        return string;
    }

    public @NotNull Supplier<@Nls String> getLazyMessage(@NotNull @NonNls String key, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(8);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(9);
        }
        Supplier<String> supplier = () -> this.getMessage(key, params2);
        if (supplier == null) {
            AbstractBundle.$$$reportNull$$$0(10);
        }
        return supplier;
    }

    @Nullable
    @Nls
    public String messageOrNull(@NotNull @NonNls String key, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(11);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(12);
        }
        return AbstractBundle.messageOrNull(this.getResourceBundle(), key, params2);
    }

    @Nls
    public String messageOrDefault(@NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(13);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(14);
        }
        return AbstractBundle.messageOrDefault(this.getResourceBundle(), key, defaultValue, params2);
    }

    @Contract(value="null, _, _, _ -> param3")
    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull @NonNls String key, @Nullable @Nls String defaultValue, Object ... params2) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(15);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(16);
        }
        if (bundle == null) {
            return defaultValue;
        }
        if (!bundle.containsKey(key)) {
            return BundleBase.postprocessValue(bundle, BundleBase.useDefaultValue(bundle, key, defaultValue), params2);
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params2);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params2) {
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(17);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(18);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(19);
        }
        String string = BundleBase.messageOrDefault(bundle, key, null, params2);
        if (string == null) {
            AbstractBundle.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    @Nls
    public static String messageOrNull(@NotNull ResourceBundle bundle, @NotNull @NonNls String key, Object ... params2) {
        String value;
        if (bundle == null) {
            AbstractBundle.$$$reportNull$$$0(21);
        }
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(22);
        }
        if (params2 == null) {
            AbstractBundle.$$$reportNull$$$0(23);
        }
        return key.equals(value = AbstractBundle.messageOrDefault(bundle, key, key, params2)) ? null : value;
    }

    public boolean containsKey(@NotNull @NonNls String key) {
        if (key == null) {
            AbstractBundle.$$$reportNull$$$0(24);
        }
        return this.getResourceBundle().containsKey(key);
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.getClass().getClassLoader());
    }

    @ApiStatus.Internal
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull ClassLoader classLoader) {
        boolean isDefault;
        ResourceBundle bundle;
        if (classLoader == null) {
            AbstractBundle.$$$reportNull$$$0(25);
        }
        if ((bundle = SoftReference.dereference((isDefault = DefaultBundleService.isDefaultBundle()) ? this.myDefaultBundle : this.myBundle)) == null) {
            bundle = this.resolveResourceBundle(this.myPathToBundle, classLoader);
            java.lang.ref.SoftReference<ResourceBundle> ref = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
            if (isDefault) {
                this.myDefaultBundle = ref;
            } else {
                this.myBundle = ref;
            }
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(26);
        }
        return resourceBundle;
    }

    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(27);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(28);
        }
        if (pathToBundle.equals(this.myPathToBundle)) {
            return this.getResourceBundle(loader);
        }
        Map cache = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader, __ -> CollectionFactory.createConcurrentSoftValueMap());
        ResourceBundle result = (ResourceBundle)cache.get(pathToBundle);
        if (result == null) {
            result = this.resolveResourceBundle(pathToBundle, loader);
            cache.put(pathToBundle, result);
        }
        ResourceBundle resourceBundle = result;
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(29);
        }
        return resourceBundle;
    }

    @NotNull
    private ResourceBundle resolveResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        ResourceBundle resourceBundle;
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(30);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(31);
        }
        try {
            resourceBundle = this.findBundle(pathToBundle, loader, MyResourceControl.INSTANCE);
        }
        catch (MissingResourceException e) {
            LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
            ResourceBundle.clearCache(loader);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            if (resourceBundle2 == null) {
                AbstractBundle.$$$reportNull$$$0(33);
            }
            return resourceBundle2;
        }
        if (resourceBundle == null) {
            AbstractBundle.$$$reportNull$$$0(32);
        }
        return resourceBundle;
    }

    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            AbstractBundle.$$$reportNull$$$0(34);
        }
        if (loader == null) {
            AbstractBundle.$$$reportNull$$$0(35);
        }
        if (control == null) {
            AbstractBundle.$$$reportNull$$$0(36);
        }
        return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
    }

    protected static void clearGlobalLocaleCache() {
        ourCache.clear();
    }

    public void clearLocaleCache() {
        if (this.myBundle != null) {
            this.myBundle.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/AbstractBundle";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/AbstractBundle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getControl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyMessage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPartialMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLazyMessage";
                break;
            }
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "messageOrNull";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 20: 
            case 26: 
            case 29: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyResourceControl
    extends ResourceBundle.Control {
        static final MyResourceControl INSTANCE = new MyResourceControl();

        private MyResourceControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            return FORMAT_PROPERTIES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String resourceName;
            String bundleName = this.toBundleName(baseName, locale);
            String string = resourceName = bundleName.contains("://") ? null : this.toResourceName(bundleName, "properties");
            if (resourceName == null) {
                return null;
            }
            if (loader instanceof UrlClassLoader) {
                byte[] data = ((UrlClassLoader)loader).getResourceAsBytes(resourceName, true);
                if (data == null) {
                    return null;
                }
                return new PropertyResourceBundle(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
            }
            InputStream stream = loader.getResourceAsStream(resourceName);
            if (stream == null) {
                return null;
            }
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                return propertyResourceBundle;
            }
            finally {
                stream.close();
            }
        }
    }
}

