/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.NlsSafe;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.text.OrdinalFormat;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.Nls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    @NlsSafe
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    public static final boolean SHOW_DEFAULT_MESSAGES = Boolean.getBoolean("idea.l10n.english");
    public static final boolean SHOW_KEYS = Boolean.getBoolean("idea.l10n.keys");
    static final String L10N_MARKER = "\ud83d\udd05";
    private static final Logger LOG = Logger.getInstance(BundleBase.class);
    private static boolean assertOnMissedKeys;
    private static final String[] SUFFIXES;
    @Nullable
    private static volatile BiConsumer<String, String> ourTranslationConsumer;

    public static void assertOnMissedKeys(boolean doAssert) {
        assertOnMissedKeys = doAssert;
    }

    @Nls
    public static String partialMessage(@NotNull ResourceBundle bundle, @NotNull String key, int unassignedParams, Object ... params2) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(0);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(1);
        }
        if (params2 == null) {
            BundleBase.$$$reportNull$$$0(2);
        }
        if (unassignedParams <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] newParams = Arrays.copyOf(params2, params2.length + unassignedParams);
        String prefix = "#$$$TemplateParameter$$$#";
        String suffix = "#$$$/TemplateParameter$$$#";
        for (int i = 0; i < unassignedParams; ++i) {
            newParams[i + params2.length] = prefix + i + suffix;
        }
        String message2 = BundleBase.message(bundle, key, newParams);
        return BundleBase.quotePattern(message2).replace(prefix, "{").replace(suffix, "}");
    }

    @NlsSafe
    private static String quotePattern(String message2) {
        boolean inQuotes = false;
        StringBuilder sb = new StringBuilder(message2.length() + 5);
        for (int i = 0; i < message2.length(); ++i) {
            boolean needToQuote;
            char c = message2.charAt(i);
            boolean bl = needToQuote = c == '{' || c == '}';
            if (needToQuote != inQuotes) {
                inQuotes = needToQuote;
                sb.append('\'');
            }
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        if (inQuotes) {
            sb.append('\'');
        }
        return sb.toString();
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params2) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(3);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(4);
        }
        if (params2 == null) {
            BundleBase.$$$reportNull$$$0(5);
        }
        String string = BundleBase.messageOrDefault(bundle, key, null, params2);
        if (string == null) {
            BundleBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable @Nls String defaultValue, Object ... params2) {
        String value;
        if (key == null) {
            BundleBase.$$$reportNull$$$0(7);
        }
        if (params2 == null) {
            BundleBase.$$$reportNull$$$0(8);
        }
        if (bundle == null) {
            return defaultValue;
        }
        boolean resourceFound = true;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            resourceFound = false;
            value = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String result = BundleBase.postprocessValue(bundle, value, params2);
        BiConsumer<String, String> consumer = ourTranslationConsumer;
        if (consumer != null) {
            consumer.accept(key, result);
        }
        if (!resourceFound) {
            return result;
        }
        if (SHOW_KEYS && SHOW_DEFAULT_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result, " (" + key + "=" + BundleBase.getDefaultMessage(bundle, key) + ")");
        }
        if (SHOW_KEYS) {
            return BundleBase.appendLocalizationSuffix(result, " (" + key + ")");
        }
        if (SHOW_DEFAULT_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result, " (" + BundleBase.getDefaultMessage(bundle, key) + ")");
        }
        if (SHOW_LOCALIZED_MESSAGES) {
            return BundleBase.appendLocalizationSuffix(result, L10N_MARKER);
        }
        return result;
    }

    @NotNull
    public static String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        block5: {
            String string;
            if (bundle == null) {
                BundleBase.$$$reportNull$$$0(9);
            }
            if (key == null) {
                BundleBase.$$$reportNull$$$0(10);
            }
            try {
                Object parentBundle;
                Field parent = ReflectionUtil.getDeclaredField(ResourceBundle.class, "parent");
                if (parent == null || !((parentBundle = parent.get(bundle)) instanceof ResourceBundle)) break block5;
                string = ((ResourceBundle)parentBundle).getString(key);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + "'");
            }
            if (string == null) {
                BundleBase.$$$reportNull$$$0(11);
            }
            return string;
        }
        return "undefined";
    }

    @NlsSafe
    @NotNull
    protected static String appendLocalizationSuffix(@NotNull String result, @NotNull String suffixToAppend) {
        if (result == null) {
            BundleBase.$$$reportNull$$$0(12);
        }
        if (suffixToAppend == null) {
            BundleBase.$$$reportNull$$$0(13);
        }
        for (String suffix : SUFFIXES) {
            if (!result.endsWith(suffix)) continue;
            String string = result.substring(0, result.length() - suffix.length()) + L10N_MARKER + suffix;
            if (string == null) {
                BundleBase.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = result + suffixToAppend;
        if (string == null) {
            BundleBase.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nls
    @NotNull
    static String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable @Nls String defaultValue) {
        if (key == null) {
            BundleBase.$$$reportNull$$$0(16);
        }
        if (defaultValue != null) {
            String string = defaultValue;
            if (string == null) {
                BundleBase.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (assertOnMissedKeys) {
            String bundleName = bundle != null ? "(" + bundle.getBaseBundleName() + ")" : "";
            LOG.error("'" + key + "' is not found in " + bundle + bundleName);
        }
        String string = "!" + key + "!";
        if (string == null) {
            BundleBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nls
    @NotNull
    static String postprocessValue(@NotNull ResourceBundle bundle, @NotNull @Nls String value, Object ... params2) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(19);
        }
        if (value == null) {
            BundleBase.$$$reportNull$$$0(20);
        }
        if (params2 == null) {
            BundleBase.$$$reportNull$$$0(21);
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params2.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
                OrdinalFormat.apply(format);
                value = format.format(params2);
            }
            catch (IllegalArgumentException e) {
                value = "!invalid format: `" + value + "`!";
            }
        }
        String string = value;
        if (string == null) {
            BundleBase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String format(@NotNull String value, Object ... params2) {
        if (value == null) {
            BundleBase.$$$reportNull$$$0(23);
        }
        if (params2 == null) {
            BundleBase.$$$reportNull$$$0(24);
        }
        String string = params2.length > 0 && value.indexOf(123) >= 0 ? MessageFormat.format(value, params2) : value;
        if (string == null) {
            BundleBase.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nls
    public static String replaceMnemonicAmpersand(@Nullable @Nls String value) {
        if (value == null || value.indexOf(38) < 0 || value.indexOf(27) >= 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        boolean mnemonicAdded = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac) {
                        if (!mnemonicAdded) {
                            mnemonicAdded = true;
                            builder.append('\u001b');
                        } else {
                            LOG.warn("ignore extra mnemonic in " + value);
                        }
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic) continue;
                if (!mnemonicAdded) {
                    mnemonicAdded = true;
                    builder.append('\u001b');
                    continue;
                }
                LOG.warn("ignore extra mnemonic in " + value);
                continue;
            }
            builder.append(c);
        }
        @NlsSafe String result = builder.toString();
        return result;
    }

    @TestOnly
    public static void setTranslationConsumer(@Nullable BiConsumer<String, String> consumer) {
        ourTranslationConsumer = consumer;
    }

    static {
        SUFFIXES = new String[]{"</body></html>", "</html>"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/BundleBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixToAppend";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/BundleBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMessage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLocalizationSuffix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "useDefaultValue";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "postprocessValue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "partialMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendLocalizationSuffix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "useDefaultValue";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "postprocessValue";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

