/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sqldelight.com.intellij.codeInsight.TailType;
import sqldelight.com.intellij.codeInsight.completion.CompletionData;
import sqldelight.com.intellij.codeInsight.completion.InsertHandler;
import sqldelight.com.intellij.codeInsight.lookup.LookupElement;
import sqldelight.com.intellij.codeInsight.lookup.LookupItem;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiReference;
import sqldelight.com.intellij.psi.filters.ElementFilter;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.org.jetbrains.annotations.NonNls;

@Deprecated(forRemoval=true)
public class CompletionVariant {
    protected static final TailType DEFAULT_TAIL_TYPE = TailType.SPACE;
    private final Set<Scope> myScopeClasses = new HashSet<Scope>();
    private ElementFilter myPosition;
    private final List<CompletionVariantItem> myCompletionsList = new ArrayList<CompletionVariantItem>();
    private InsertHandler myInsertHandler = null;
    private final Map<Object, Object> myItemProperties = new HashMap<Object, Object>();

    public CompletionVariant() {
    }

    public CompletionVariant(Class scopeClass, ElementFilter position) {
        this.includeScopeClass(scopeClass);
        this.myPosition = position;
    }

    public CompletionVariant(ElementFilter position) {
        this.myPosition = position;
    }

    boolean isScopeAcceptable(PsiElement scope) {
        return this.isScopeClassAcceptable(scope.getClass());
    }

    boolean isScopeFinal(PsiElement scope) {
        return this.isScopeClassFinal(scope.getClass());
    }

    InsertHandler getInsertHandler() {
        return this.myInsertHandler;
    }

    public void setInsertHandler(InsertHandler handler) {
        this.myInsertHandler = handler;
    }

    Map<Object, Object> getItemProperties() {
        return this.myItemProperties;
    }

    private boolean isScopeClassFinal(Class<?> scopeClass) {
        for (Scope myScopeClass : this.myScopeClasses) {
            if (!ReflectionUtil.isAssignable(myScopeClass.myClass, scopeClass) || !myScopeClass.myIsFinalScope) continue;
            return true;
        }
        return false;
    }

    private boolean isScopeClassAcceptable(Class<?> scopeClass) {
        boolean ret = false;
        for (Scope myScopeClass : this.myScopeClasses) {
            Class<?> aClass = myScopeClass.myClass;
            if (!ReflectionUtil.isAssignable(aClass, scopeClass)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public void includeScopeClass(Class<?> aClass) {
        this.myScopeClasses.add(new Scope(aClass, false));
    }

    public void includeScopeClass(Class<?> aClass, boolean isFinalScope) {
        this.myScopeClasses.add(new Scope(aClass, isFinalScope));
    }

    public void addCompletionFilter(ElementFilter filter, TailType tailType) {
        this.addCompletion(filter, tailType);
    }

    public void addCompletionFilter(ElementFilter filter) {
        this.addCompletionFilter(filter, TailType.NONE);
    }

    public void addCompletion(@NonNls String keyword) {
        this.addCompletion(keyword, DEFAULT_TAIL_TYPE);
    }

    public void addCompletion(@NonNls String keyword, TailType tailType) {
        this.addCompletion((Object)keyword, tailType);
    }

    private void addCompletion(Object completion, TailType tail) {
        this.myCompletionsList.add(new CompletionVariantItem(completion, tail));
    }

    boolean isVariantApplicable(PsiElement position, PsiElement scope) {
        return this.isScopeAcceptable(scope) && this.myPosition.isAcceptable(position, scope);
    }

    void addReferenceCompletions(PsiReference reference, PsiElement position, Set<? super LookupElement> set, PsiFile file, CompletionData completionData) {
        for (CompletionVariantItem ce : this.myCompletionsList) {
            if (!(ce.myCompletion instanceof ElementFilter)) continue;
            ElementFilter filter = (ElementFilter)ce.myCompletion;
            completionData.completeReference(reference, position, set, ce.myTailType, filter, this);
        }
    }

    void addKeywords(Set<LookupElement> set, CompletionData completionData) {
        for (CompletionVariantItem ce : this.myCompletionsList) {
            completionData.addKeywords(set, this, ce.myCompletion, ce.myTailType);
        }
    }

    boolean hasReferenceFilter() {
        for (CompletionVariantItem item : this.myCompletionsList) {
            if (!(item.myCompletion instanceof ElementFilter)) continue;
            return true;
        }
        return false;
    }

    boolean hasKeywordCompletions() {
        for (CompletionVariantItem item : this.myCompletionsList) {
            if (item.myCompletion instanceof ElementFilter) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "completion variant at " + this.myPosition.toString() + " completions: " + this.myCompletionsList;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.myItemProperties.put(LookupItem.CASE_INSENSITIVE, caseInsensitive);
    }

    private static class CompletionVariantItem {
        public Object myCompletion;
        public TailType myTailType;

        CompletionVariantItem(Object completion, TailType tailtype) {
            this.myCompletion = completion;
            this.myTailType = tailtype;
        }

        public String toString() {
            return this.myCompletion.toString();
        }
    }

    private static class Scope {
        Class<?> myClass;
        boolean myIsFinalScope;

        Scope(Class<?> aClass, boolean isFinalScope) {
            this.myClass = aClass;
            this.myIsFinalScope = isFinalScope;
        }
    }
}

