/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight.completion;

import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import sqldelight.com.intellij.codeInsight.completion.OffsetMap;
import sqldelight.com.intellij.injected.editor.DocumentWindow;
import sqldelight.com.intellij.injected.editor.VirtualFileWindow;
import sqldelight.com.intellij.lang.FileASTNode;
import sqldelight.com.intellij.lang.injection.InjectedLanguageManager;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.editor.impl.DocumentImpl;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.pom.PomManager;
import sqldelight.com.intellij.pom.PomModel;
import sqldelight.com.intellij.pom.core.impl.PomModelImpl;
import sqldelight.com.intellij.psi.FileViewProvider;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.impl.source.tree.FileElement;
import sqldelight.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lsqldelight/com/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lsqldelight/com/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "offsets", "Lsqldelight/com/intellij/codeInsight/completion/OffsetMap;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "copyWithReplacement", "startOffset", "", "endOffset", "replacement", "", "replaceInCopy", "Ljava/util/function/Supplier;", "fileCopy", "toInjectedIfAny", "offset", "toTopLevelFile", "intellij.platform.analysis.impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile(this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            return this;
        }
        PsiFile psiFile = hostFile;
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"hostFile");
        FileViewProvider fileViewProvider = hostFile.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"hostFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        Intrinsics.checkNotNull((Object)document);
        OffsetMap offsetMap = this.offsets.mapOffsets(document, new Function(this, manager){
            final /* synthetic */ OffsetsInFile this$0;
            final /* synthetic */ InjectedLanguageManager $manager;

            public final Integer apply(Integer it) {
                PsiElement psiElement = this.this$0.getFile();
                Integer n = it;
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it");
                return this.$manager.injectedToHost(psiElement, n);
            }
            {
                this.this$0 = offsetsInFile;
                this.$manager = injectedLanguageManager;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"offsets.mapOffsets(hostF\u2026njectedToHost(file, it) }");
        return new OffsetsInFile(psiFile, offsetMap);
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.file.getProject());
        PsiElement psiElement = manager.findInjectedElementAt(this.file, offset);
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return this;
        }
        PsiElement injected = psiElement;
        VirtualFile virtualFile = injected.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)((Object)virtualFile)).getDocumentWindow();
            Intrinsics.checkNotNullExpressionValue((Object)documentWindow, (String)"virtualFile.documentWindow");
            DocumentWindow documentWindow2 = documentWindow;
            OffsetMap offsetMap = this.offsets.mapOffsets(documentWindow2, new Function(documentWindow2){
                final /* synthetic */ DocumentWindow $documentWindow;

                public final Integer apply(Integer it) {
                    Integer n = it;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it");
                    return this.$documentWindow.hostToInjected(n);
                }
                {
                    this.$documentWindow = documentWindow;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"offsets.mapOffsets(\n    \u2026ndow.hostToInjected(it) }");
            return new OffsetsInFile((PsiFile)injected, offsetMap);
        }
        return this;
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        PsiElement psiElement = this.file.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        OffsetsInFile offsetsInFile = this.replaceInCopy((PsiFile)psiElement, startOffset, endOffset, replacement).get();
        Intrinsics.checkNotNullExpressionValue((Object)offsetsInFile, (String)"replaceInCopy(file.copy(\u2026ffset, replacement).get()");
        return offsetsInFile;
    }

    @NotNull
    public final Supplier<OffsetsInFile> replaceInCopy(@NotNull PsiFile fileCopy, int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Document document = this.offsets.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"offsets.document");
        CharSequence charSequence = document.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"offsets.document.immutableCharSequence");
        CharSequence originalText = charSequence;
        DocumentImpl tempDocument = new DocumentImpl(originalText, StringsKt.contains$default((CharSequence)originalText, (char)'\r', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)replacement, (char)'\r', (boolean)false, (int)2, null), true);
        OffsetMap offsetMap = this.offsets.copyOffsets(tempDocument);
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"offsets.copyOffsets(tempDocument)");
        OffsetMap tempMap = offsetMap;
        tempDocument.replaceString(startOffset, endOffset, replacement);
        FileViewProvider fileViewProvider = fileCopy.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"fileCopy.viewProvider");
        Document document2 = fileViewProvider.getDocument();
        Intrinsics.checkNotNull((Object)document2);
        Document copyDocument = document2;
        FileASTNode fileASTNode = fileCopy.getNode();
        if (!(fileASTNode instanceof FileElement)) {
            fileASTNode = null;
        }
        FileElement fileElement = (FileElement)fileASTNode;
        if (fileElement == null) {
            throw (Throwable)new IllegalStateException("Node is not a FileElement " + fileCopy.getClass().getName() + " / " + fileCopy.getFileType() + " / " + fileCopy.getNode());
        }
        FileElement node = fileElement;
        PomModel pomModel = PomManager.getModel(this.file.getProject());
        if (pomModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.pom.core.impl.PomModelImpl");
        }
        Runnable applyPsiChange = ((PomModelImpl)pomModel).reparseFile(fileCopy, node, tempDocument.getImmutableCharSequence());
        return new Supplier(applyPsiChange, fileCopy, tempMap, copyDocument){
            final /* synthetic */ Runnable $applyPsiChange;
            final /* synthetic */ PsiFile $fileCopy;
            final /* synthetic */ OffsetMap $tempMap;
            final /* synthetic */ Document $copyDocument;

            @NotNull
            public final OffsetsInFile get() {
                Runnable runnable = this.$applyPsiChange;
                if (runnable != null) {
                    runnable.run();
                }
                OffsetMap offsetMap = this.$tempMap.copyOffsets(this.$copyDocument);
                Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"tempMap.copyOffsets(copyDocument)");
                return new OffsetsInFile(this.$fileCopy, offsetMap);
            }
            {
                this.$applyPsiChange = runnable;
                this.$fileCopy = psiFile;
                this.$tempMap = offsetMap;
                this.$copyDocument = document;
            }
        };
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file, @NotNull OffsetMap offsets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
        this.file = file;
        this.offsets = offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileViewProvider fileViewProvider = file.getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file.viewProvider");
        Document document = fileViewProvider.getDocument();
        Intrinsics.checkNotNull((Object)document);
        this(file, new OffsetMap(document));
    }
}

