/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight.lookup;

import sqldelight.com.intellij.application.options.CodeStyle;
import sqldelight.com.intellij.codeInsight.TailType;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.editor.Editor;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import sqldelight.com.intellij.psi.util.PsiEditorUtil;
import sqldelight.com.intellij.psi.util.PsiUtilCore;

public class EqTailType
extends TailType {
    public static final TailType INSTANCE = new EqTailType();

    protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
        PsiFile psiFile = PsiEditorUtil.getPsiFile(editor);
        Language language = PsiUtilCore.getLanguageAtOffset(psiFile, tailOffset);
        CodeStyleSettingsFacade codeStyleFacade = CodeStyle.getFacade(psiFile).withLanguage(language);
        return codeStyleFacade.isSpaceAroundAssignmentOperators();
    }

    @Override
    public int processTail(Editor editor, int tailOffset) {
        Document document = editor.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == '=') {
            return EqTailType.moveCaret(editor, tailOffset, 2);
        }
        if (tailOffset < textLength && chars.charAt(tailOffset) == '=') {
            return EqTailType.moveCaret(editor, tailOffset, 1);
        }
        if (this.isSpaceAroundAssignmentOperators(editor, tailOffset)) {
            document.insertString(tailOffset, " =");
            tailOffset = EqTailType.moveCaret(editor, tailOffset, 2);
            tailOffset = EqTailType.insertChar(editor, tailOffset, ' ');
        } else {
            document.insertString(tailOffset, "=");
            tailOffset = EqTailType.moveCaret(editor, tailOffset, 1);
        }
        return tailOffset;
    }
}

