/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.concurrency;

import java.util.concurrent.Callable;
import kotlin.coroutines.CoroutineContext;
import sqldelight.com.intellij.concurrency.ThreadContext;
import sqldelight.com.intellij.openapi.application.AccessToken;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ContextCallable<V>
implements Callable<V> {
    @NotNull
    private final CoroutineContext myParentContext;
    @NotNull
    private final Callable<? extends V> myCallable;

    public ContextCallable(@NotNull Callable<? extends V> callable) {
        if (callable == null) {
            ContextCallable.$$$reportNull$$$0(0);
        }
        this.myParentContext = ThreadContext.currentThreadContext();
        this.myCallable = callable;
    }

    @Override
    public V call() throws Exception {
        ThreadContext.checkUninitializedThreadContext();
        try (AccessToken ignored = ThreadContext.resetThreadContext(this.myParentContext);){
            V v = this.myCallable.call();
            return v;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "sqldelight/com/intellij/concurrency/ContextCallable", "<init>"));
    }
}

