/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.diagnostic;

import java.awt.AWTEvent;
import sqldelight.com.intellij.diagnostic.InstanceHolder;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.util.concurrency.annotations.RequiresEdt;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface EventWatcher {
    public static boolean isEnabled() {
        return InstanceHolder.isEnabled;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application app;
        if (!EventWatcher.isEnabled()) {
            return null;
        }
        EventWatcher result = InstanceHolder.instance;
        if (result == null && LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            InstanceHolder.instance = result = app.getService(EventWatcher.class);
        }
        return result;
    }

    @RequiresEdt
    public void runnableStarted(@NotNull Runnable var1, long var2);

    @RequiresEdt
    public void runnableFinished(@NotNull Runnable var1, long var2);

    @RequiresEdt
    public void edtEventStarted(@NotNull AWTEvent var1, long var2);

    @RequiresEdt
    public void edtEventFinished(@NotNull AWTEvent var1, long var2);

    public void reset();

    public void logTimeMillis(@NotNull String var1, long var2, @NotNull Class<? extends Runnable> var4);

    default public void logTimeMillis(@NotNull String processId, long startedAt) {
        if (processId == null) {
            EventWatcher.$$$reportNull$$$0(0);
        }
        this.logTimeMillis(processId, startedAt, Runnable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processId", "sqldelight/com/intellij/diagnostic/EventWatcher", "logTimeMillis"));
    }
}

