/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.execution.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeMap;
import sqldelight.com.intellij.execution.process.Java8Helper;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.openapi.util.SystemInfo;
import sqldelight.com.intellij.util.Processor;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.lang.JavaVersion;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class UnixProcessManager {
    private static final Logger LOG = Logger.getInstance(UnixProcessManager.class);
    private static final MethodHandle signalStringToIntConverter;
    public static final int SIGINT = 2;
    public static final int SIGABRT = 6;
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;

    private UnixProcessManager() {
    }

    public static int getProcessId(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(0);
        }
        try {
            if (JavaVersion.current().feature >= 9 && "java.lang.ProcessImpl".equals(process.getClass().getName())) {
                return ((Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process, new Object[0])).intValue();
            }
            return Objects.requireNonNull(ReflectionUtil.getField(process.getClass(), process, Integer.TYPE, "pid"));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to get PID from an instance of " + process.getClass() + ", OS: " + SystemInfo.OS_NAME, t);
        }
    }

    public static int getCurrentProcessId() {
        return Java8Helper.C_LIB != null ? Java8Helper.C_LIB.getpid() : 0;
    }

    public static int getSignalNumber(@NotNull String signalName) {
        if (signalName == null) {
            UnixProcessManager.$$$reportNull$$$0(1);
        }
        try {
            return signalStringToIntConverter.invokeExact(signalName);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static int sendSignal(int pid, @NotNull String signalName) {
        int signalNumber;
        if (signalName == null) {
            UnixProcessManager.$$$reportNull$$$0(2);
        }
        return (signalNumber = UnixProcessManager.getSignalNumber(signalName)) == -1 ? -1 : UnixProcessManager.sendSignal(pid, signalNumber);
    }

    public static int sendSignal(int pid, int signal) {
        UnixProcessManager.checkCLib();
        return Java8Helper.C_LIB.kill(pid, signal);
    }

    private static void checkCLib() {
        if (Java8Helper.C_LIB == null) {
            throw new IllegalStateException("Couldn't load c library, OS: " + SystemInfo.OS_NAME + ", isUnix: " + SystemInfo.isUnix);
        }
    }

    public static boolean sendSigIntToProcessTree(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(3);
        }
        return UnixProcessManager.sendSignalToProcessTree(process, 2);
    }

    public static boolean sendSigKillToProcessTree(@NotNull Process process) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(4);
        }
        return UnixProcessManager.sendSignalToProcessTree(process, 9);
    }

    public static boolean sendSignalToProcessTree(@NotNull Process process, int signal) {
        if (process == null) {
            UnixProcessManager.$$$reportNull$$$0(5);
        }
        try {
            return UnixProcessManager.sendSignalToProcessTree(UnixProcessManager.getProcessId(process), signal);
        }
        catch (Exception e) {
            LOG.warn("Error killing the process", e);
            return false;
        }
    }

    public static boolean sendSignalToProcessTree(int processId, int signal) {
        UnixProcessManager.checkCLib();
        int ourPid = Java8Helper.C_LIB.getpid();
        return UnixProcessManager.sendSignalToProcessTree(processId, signal, ourPid);
    }

    public static boolean sendSignalToProcessTree(int processId, int signal, int ourPid) {
        boolean result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending signal " + signal + " to process tree with root PID " + processId);
        }
        Ref foundPid = new Ref();
        ProcessInfo processInfo = new ProcessInfo();
        ArrayList childrenPids = new ArrayList();
        UnixProcessManager.findChildProcesses(ourPid, processId, foundPid, processInfo, childrenPids);
        if (!foundPid.isNull()) {
            processInfo.killProcTree((Integer)foundPid.get(), signal);
            result = true;
        } else {
            for (Integer pid : childrenPids) {
                processInfo.killProcTree(pid, signal);
            }
            boolean bl = result = !childrenPids.isEmpty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done sending signal " + signal + "; found: " + foundPid.get() + ", children: " + childrenPids + ", result: " + result);
        }
        return result;
    }

    private static void findChildProcesses(int our_pid, int process_pid, Ref<? super Integer> foundPid, ProcessInfo processInfo, List<? super Integer> childrenPids) {
        Ref<Boolean> ourPidFound = Ref.create(false);
        UnixProcessManager.processPSOutput(UnixProcessManager.getPSCmd(false), s -> {
            StringTokenizer st = new StringTokenizer((String)s, " ");
            int parent_pid = Integer.parseInt(st.nextToken());
            int pid = Integer.parseInt(st.nextToken());
            processInfo.register(pid, parent_pid);
            if (parent_pid == process_pid) {
                childrenPids.add(pid);
            }
            if (pid == our_pid) {
                ourPidFound.set(true);
            } else if (pid == process_pid) {
                if (parent_pid == our_pid || our_pid == -1) {
                    foundPid.set(pid);
                } else {
                    throw new IllegalStateException("Process (pid=" + process_pid + ") is not our child(our pid = " + our_pid + ")");
                }
            }
            return false;
        });
        if (our_pid != -1 && !ourPidFound.get().booleanValue()) {
            throw new IllegalStateException("IDE pid is not found in ps list(" + our_pid + ")");
        }
    }

    public static void processPSOutput(String[] cmd, Processor<? super String> processor) {
        UnixProcessManager.processCommandOutput(cmd, processor, true, true);
    }

    public static void processCommandOutput(String[] cmd, Processor<? super String> processor, boolean skipFirstLine, boolean throwOnError) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            UnixProcessManager.processCommandOutput(p, processor, skipFirstLine, throwOnError);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void processCommandOutput(Process process, Processor<? super String> processor, boolean skipFirstLine, boolean throwOnError) throws IOException {
        try (BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
             BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
            String s;
            if (skipFirstLine) {
                stdOutput.readLine();
            }
            while ((s = stdOutput.readLine()) != null) {
                processor.process(s);
            }
            StringBuilder errorStr = new StringBuilder();
            while ((s = stdError.readLine()) != null) {
                if (s.contains("environment variables being ignored")) continue;
                errorStr.append(s).append("\n");
            }
            if (throwOnError && errorStr.length() > 0) {
                throw new IOException("Error reading ps output:" + errorStr);
            }
        }
    }

    public static String[] getPSCmd(boolean commandLineOnly) {
        return UnixProcessManager.getPSCmd(commandLineOnly, false);
    }

    public static String[] getPSCmd(boolean commandLineOnly, boolean isShortenCommand) {
        String psCommand = "/bin/ps";
        if (!new File(psCommand).isFile()) {
            psCommand = "ps";
        }
        if (SystemInfo.isLinux) {
            return new String[]{psCommand, "-e", "--format", commandLineOnly ? "%a" : "%P%p%a"};
        }
        if (SystemInfo.isMac || SystemInfo.isFreeBSD) {
            @NonNls String command = isShortenCommand ? "comm" : "command";
            return new String[]{psCommand, "-ax", "-o", commandLineOnly ? command : "ppid,pid," + command};
        }
        throw new IllegalStateException(System.getProperty("os.name") + " is not supported.");
    }

    static {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            MethodHandle signalConstructor = MethodHandles.publicLookup().findConstructor(signalClass, MethodType.methodType(Void.TYPE, String.class));
            MethodHandle getNumber = MethodHandles.publicLookup().findVirtual(signalClass, "getNumber", MethodType.methodType(Integer.TYPE));
            signalStringToIntConverter = MethodHandles.filterReturnValue(signalConstructor, getNumber);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/execution/process/UnixProcessManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignalNumber";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSignal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSigIntToProcessTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSigKillToProcessTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSignalToProcessTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProcessInfo {
        private final Map<Integer, List<Integer>> BY_PARENT = new TreeMap<Integer, List<Integer>>();

        private ProcessInfo() {
        }

        public void register(Integer pid, Integer parentPid) {
            List<Integer> children2 = this.BY_PARENT.get(parentPid);
            if (children2 == null) {
                children2 = new LinkedList<Integer>();
                this.BY_PARENT.put(parentPid, children2);
            }
            children2.add(pid);
        }

        public void killProcTree(int pid, int signal) {
            List<Integer> children2 = this.BY_PARENT.get(pid);
            if (children2 != null) {
                for (int child : children2) {
                    this.killProcTree(child, signal);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending signal " + signal + " to PID " + pid);
            }
            UnixProcessManager.sendSignal(pid, signal);
        }
    }
}

