/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.ide.plugins.ClassLoaderConfigurator;
import sqldelight.com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.PluginDependency;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.ide.plugins.PluginSet;
import sqldelight.com.intellij.ide.plugins.cl.PluginClassLoader;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.lang.ClassPath;
import sqldelight.com.intellij.util.lang.ResourceFile;
import sqldelight.com.intellij.util.lang.UrlClassLoader;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J#\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eJ+\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010(\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lsqldelight/com/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lsqldelight/com/intellij/ide/plugins/PluginSet;", "coreLoader", "Ljava/lang/ClassLoader;", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lsqldelight/com/intellij/openapi/extensions/PluginId;", "Lsqldelight/com/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lsqldelight/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lsqldelight/com/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "checkPackagePrefixUniqueness", "", "module", "configure", "configureCorePluginModuleClassLoader", "deps", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "configureDependenciesInOldFormat", "mainDependentClassLoader", "configureDependency", "mainDescriptor", "moduleDescriptor", "configureModule", "createPluginClassLoader", "Lsqldelight/com/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "mainInfo", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "getCoreUrlClassLoaderIfPossible", "Lsqldelight/com/intellij/util/lang/UrlClassLoader;", "setPluginClassLoaderForModuleAndOldSubDescriptors", "rootDescriptor", "classLoader", "MainInfo", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class ClassLoaderConfigurator {
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    private final Function<Path, ResourceFile> resourceFileFactory;
    private final IdentityHashMap<PluginId, MainInfo> mainToClassPath;
    @NotNull
    private final PluginSet pluginSet;
    private final ClassLoader coreLoader;

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    public final void configureDependency(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull IdeaPluginDescriptorImpl moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)mainDescriptor, (String)"mainDescriptor");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        boolean bl = Intrinsics.areEqual((Object)mainDescriptor, (Object)moduleDescriptor) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PluginId pluginId = mainDescriptor.getPluginId();
        boolean bl2 = Intrinsics.areEqual((Object)pluginId, (Object)moduleDescriptor.getPluginId());
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClassLoader classLoader = mainDescriptor.getPluginClassLoader();
        if (classLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.plugins.cl.PluginClassLoader");
        }
        PluginClassLoader mainClassLoader = (PluginClassLoader)classLoader;
        ((Map)this.mainToClassPath).put(pluginId, new MainInfo(mainClassLoader));
        if (mainDescriptor.packagePrefix == null) {
            moduleDescriptor.setPluginClassLoader(mainClassLoader);
        } else {
            this.configureModule(moduleDescriptor);
        }
    }

    public final void configure() {
        for (IdeaPluginDescriptorImpl module : this.pluginSet.getRawListOfEnabledModules()) {
            this.configureModule(module);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void configureModule(@NotNull IdeaPluginDescriptorImpl module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.checkPackagePrefixUniqueness(module);
        boolean isMain = module.moduleName == null;
        Collection<IdeaPluginDescriptorImpl> $this$toTypedArray$iv = this.pluginSet.moduleGraph.getDependencies(module);
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        IdeaPluginDescriptorImpl[] dependencies = ideaPluginDescriptorImplArray;
        ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        if (isMain) {
            ClassLoader classLoader;
            if (module.useCoreClassLoader || Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
                this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
                return;
            }
            List<Path> files = module.jarFiles;
            if (files == null) {
                if (!module.isUseIdeaClassLoader) {
                    ClassLoaderConfiguratorKt.access$getLog$p().error("jarFiles is not set for " + module);
                }
                List list = Collections.emptyList();
                Intrinsics.checkNotNull(list);
                files = list;
            }
            List libDirectories = new SmartList();
            Path libDir = module.path.resolve("lib");
            if (Files.exists(libDir, new LinkOption[0])) {
                libDirectories.add(((Object)libDir.toAbsolutePath()).toString());
            }
            boolean mimicJarUrlConnection = !module.isBundled() && Intrinsics.areEqual((Object)module.getVendor(), (Object)"JetBrains") ^ true;
            ClassPath pluginClassPath = new ClassPath(files, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
            MainInfo mainInfo = new MainInfo(pluginClassPath, files, libDirectories);
            MainInfo existing = this.mainToClassPath.put(module.getPluginId(), mainInfo);
            if (existing != null) {
                ClassLoaderConfiguratorKt.access$getLog$p().error(new PluginException("Main module with " + module.getPluginId() + " is already added (existingClassPath=" + existing.files, module.getPluginId()));
            }
            if (module.isUseIdeaClassLoader) {
                classLoader = ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader(mainInfo.files, module);
            } else {
                IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray2 = dependencies;
                MainInfo mainInfo2 = mainInfo;
                classLoader = this.createPluginClassLoader(module, ideaPluginDescriptorImplArray2, mainInfo2);
            }
            ClassLoader mainDependentClassLoader = classLoader;
            module.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(module, mainDependentClassLoader);
            return;
        } else {
            if (module.packagePrefix == null) {
                throw (Throwable)new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            boolean files = module.pluginDependencies.isEmpty();
            if (_Assertions.ENABLED && !files) {
                boolean bl = false;
                String string = "Module " + module + " shouldn't have plugin dependencies: " + module.pluginDependencies;
                throw new AssertionError((Object)string);
            }
            for (IdeaPluginDescriptorImpl dependency : dependencies) {
                if (dependency.getPluginClassLoader() != null) continue;
                return;
            }
            if (module.useCoreClassLoader) {
                module.setPluginClassLoader(this.coreLoader);
                return;
            }
            MainInfo mainInfo = this.mainToClassPath.get(module.getPluginId());
            if (mainInfo == null) {
                if (!Intrinsics.areEqual((Object)module.getPluginId(), (Object)PluginManagerCore.CORE_ID)) throw (Throwable)new PluginException("Cannot find containing plugin " + module.getPluginId() + " for module " + module.moduleName + ' ', module.getPluginId());
                this.configureCorePluginModuleClassLoader(module, dependencies);
                return;
            } else {
                module.setPluginClassLoader(new PluginClassLoader(mainInfo.files, mainInfo.classPath, dependencies, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, mainInfo.libDirectories));
            }
        }
    }

    private final void configureDependenciesInOldFormat(IdeaPluginDescriptorImpl module, ClassLoader mainDependentClassLoader) {
        for (PluginDependency dependency : module.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null) {
                continue;
            }
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl = false;
                ideaPluginDescriptorImpl = it != module ? ideaPluginDescriptorImpl2 : null;
            } else {
                ideaPluginDescriptorImpl = null;
            }
            if (ideaPluginDescriptorImpl == null) continue;
            subDescriptor.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(subDescriptor, mainDependentClassLoader);
        }
    }

    private final void configureCorePluginModuleClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] deps) {
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible(module);
        if (coreUrlClassLoader == null) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return;
        }
        module.setPluginClassLoader(new PluginClassLoader(Collections.emptyList(), coreUrlClassLoader.getClassPath(), deps, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, new ArrayList()));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible(IdeaPluginDescriptorImpl module) {
        UrlClassLoader coreUrlClassLoader;
        ClassLoader classLoader = this.coreLoader;
        if (!(classLoader instanceof UrlClassLoader)) {
            classLoader = null;
        }
        if ((coreUrlClassLoader = (UrlClassLoader)classLoader) == null) {
            if (!Boolean.getBoolean("idea.use.core.classloader.for.plugin.path")) {
                ClassLoaderConfiguratorKt.access$getLog$p().error("You must run JVM with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
            }
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return null;
        }
        if (coreUrlClassLoader.resolveScopeManager == null) {
            IdeaPluginDescriptorImpl corePlugin = (IdeaPluginDescriptorImpl)CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual((Object)corePlugin.getPluginId(), (Object)PluginManagerCore.CORE_ID);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PluginClassLoader.ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = new BiFunction(resolveScopeManager){
                    final /* synthetic */ PluginClassLoader.ResolveScopeManager $resolveScopeManager;

                    public final String apply(String name, Boolean force) {
                        Boolean bl = force;
                        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"force");
                        return this.$resolveScopeManager.isDefinitelyAlienClass(name, "", bl);
                    }
                    {
                        this.$resolveScopeManager = resolveScopeManager;
                    }
                };
            }
        }
        return coreUrlClassLoader;
    }

    private final void setPluginClassLoaderForModuleAndOldSubDescriptors(IdeaPluginDescriptorImpl rootDescriptor, ClassLoader classLoader) {
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || !this.pluginSet.isPluginEnabled(dependency.getPluginId())) continue;
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(subDescriptor, classLoader);
        }
    }

    private final void checkPackagePrefixUniqueness(IdeaPluginDescriptorImpl module) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module.packagePrefix;
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module)) != null) {
            throw (Throwable)new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module + ", first=" + old + ')', module.getPluginId());
        }
    }

    private final PluginClassLoader createPluginClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] dependencies, MainInfo mainInfo) {
        PluginClassLoader.ResolveScopeManager resolveScopeManager = null;
        if (module.moduleName == null) {
            PluginClassLoader.ResolveScopeManager resolveScopeManager2;
            switch (module.getPluginId().getIdString()) {
                case "sqldelight.com.intellij.diagram": {
                    resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("sqldelight.com.intellij.diagram.");
                    break;
                }
                case "sqldelight.com.intellij.struts2": {
                    resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("sqldelight.com.intellij.lang.ognl.");
                    break;
                }
                case "sqldelight.com.intellij.properties": {
                    resolveScopeManager2 = createPluginClassLoader.1.INSTANCE;
                    break;
                }
                default: {
                    resolveScopeManager2 = ClassLoaderConfiguratorKt.access$createPluginDependencyAndContentBasedScope(module, this.pluginSet);
                }
            }
            resolveScopeManager = resolveScopeManager2;
        } else {
            resolveScopeManager = module.content.modules.isEmpty() ? ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager() : ClassLoaderConfiguratorKt.access$createModuleContentBasedScope(module);
        }
        return new PluginClassLoader(mainInfo.files, mainInfo.classPath, dependencies, module, this.coreLoader, resolveScopeManager, module.packagePrefix, mainInfo.libDirectories);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @NotNull ClassLoader coreLoader) {
        Function function;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        Intrinsics.checkNotNullParameter((Object)coreLoader, (String)"coreLoader");
        this.pluginSet = pluginSet;
        this.coreLoader = coreLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            Function function2 = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("sqldelight.com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
            if (function2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.function.Function<java.nio.file.Path, com.intellij.util.lang.ResourceFile>");
            }
            function = function2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLog$p().error((Throwable)e);
            function = null;
        }
        classLoaderConfigurator.resourceFileFactory = function;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = ClassLoaderConfigurator.class.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ClassLoaderConfigurator::class.java.classLoader");
            classLoader = classLoader2;
        }
        this(pluginSet, classLoader);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rR\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lsqldelight/com/intellij/ide/plugins/ClassLoaderConfigurator$MainInfo;", "", "classLoader", "Lsqldelight/com/intellij/ide/plugins/cl/PluginClassLoader;", "(Lcom/intellij/ide/plugins/cl/PluginClassLoader;)V", "classPath", "Lsqldelight/com/intellij/util/lang/ClassPath;", "files", "", "Ljava/nio/file/Path;", "libDirectories", "", "", "(Lcom/intellij/util/lang/ClassPath;Ljava/util/List;Ljava/util/List;)V", "intellij.platform.core.impl"})
    private static final class MainInfo {
        @JvmField
        @NotNull
        public final ClassPath classPath;
        @JvmField
        @NotNull
        public final List<Path> files;
        @JvmField
        @NotNull
        public final List<String> libDirectories;

        public MainInfo(@NotNull ClassPath classPath, @NotNull List<? extends Path> files, @NotNull List<String> libDirectories) {
            Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter(libDirectories, (String)"libDirectories");
            this.classPath = classPath;
            this.files = files;
            this.libDirectories = libDirectories;
        }

        public MainInfo(@NotNull PluginClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            ClassPath classPath = classLoader.getClassPath();
            Intrinsics.checkNotNullExpressionValue((Object)classPath, (String)"classLoader.classPath");
            Collection collection = classLoader.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"classLoader.files");
            List<String> list = classLoader.getLibDirectories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"classLoader.libDirectories");
            this(classPath, (List<? extends Path>)collection, list);
        }
    }
}

