/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import sqldelight.com.intellij.core.CoreBundle;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import sqldelight.com.intellij.ide.plugins.PluginLoadingError;
import sqldelight.com.intellij.ide.plugins.PluginLoadingResult;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.util.BuildNumber;
import sqldelight.com.intellij.util.PlatformUtils;
import sqldelight.com.intellij.util.text.VersionComparatorUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.TestOnly;
import sqldelight.org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B9\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000bJ\u001f\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0004H\u0002J\u0019\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0012H\u0000\u00a2\u0006\u0002\b,J\u0019\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u000eH\u0000\u00a2\u0006\u0002\b.J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020%J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u000e\u00103\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0010J\u000e\u00103\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u0004J\u0010\u00104\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0018\u00105\u001a\u00020%2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109R\"\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lsqldelight/com/intellij/ide/plugins/PluginLoadingResult;", "", "brokenPluginVersions", "", "Lsqldelight/com/intellij/openapi/extensions/PluginId;", "", "", "productBuildNumber", "Ljava/util/function/Supplier;", "Lsqldelight/com/intellij/openapi/util/BuildNumber;", "checkModuleDependencies", "", "(Ljava/util/Map;Ljava/util/function/Supplier;Z)V", "duplicateModuleMap", "", "", "Lsqldelight/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "enabledPlugins", "", "globalErrors", "Ljava/util/concurrent/CopyOnWriteArrayList;", "hasPluginErrors", "getHasPluginErrors", "()Z", "idMap", "Ljava/util/concurrent/ConcurrentHashMap;", "incompletePlugins", "pluginErrors", "Lsqldelight/com/intellij/ide/plugins/PluginLoadingError;", "plugins", "Ljava/util/HashMap;", "shadowedBundledIds", "Ljava/util/HashSet;", "add", "descriptor", "overrideUseIfCompatible", "addIncompletePlugin", "", "plugin", "error", "addIncompletePlugin$intellij_platform_core_impl", "checkAndAdd", "id", "copyGlobalErrors", "copyGlobalErrors$intellij_platform_core_impl", "copyPluginErrors", "copyPluginErrors$intellij_platform_core_impl", "enabledPluginCount", "", "finishLoading", "getEnabledPlugins", "isBroken", "isCompatible", "reportCannotLoad", "file", "Ljava/nio/file/Path;", "e", "", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginLoadingResult {
    @JvmField
    @NotNull
    public final ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> incompletePlugins;
    private final HashMap<PluginId, IdeaPluginDescriptorImpl> plugins;
    @JvmField
    @NotNull
    public final ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> idMap;
    @JvmField
    @Nullable
    public Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateModuleMap;
    private final ConcurrentHashMap<PluginId, PluginLoadingError> pluginErrors;
    private final CopyOnWriteArrayList<Supplier<String>> globalErrors;
    @VisibleForTesting
    @JvmField
    @NotNull
    public final HashSet<PluginId> shadowedBundledIds;
    private List<IdeaPluginDescriptorImpl> enabledPlugins;
    private final Map<PluginId, Set<String>> brokenPluginVersions;
    @JvmField
    @NotNull
    public final Supplier<BuildNumber> productBuildNumber;
    private final boolean checkModuleDependencies;

    @TestOnly
    public final boolean getHasPluginErrors() {
        return !this.pluginErrors.isEmpty();
    }

    @NotNull
    public final List<IdeaPluginDescriptorImpl> getEnabledPlugins() {
        List<IdeaPluginDescriptorImpl> list = this.enabledPlugins;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public final int enabledPluginCount() {
        return this.plugins.size();
    }

    public final void finishLoading() {
        Collection<IdeaPluginDescriptorImpl> collection = this.plugins.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"plugins.values");
        Collection<IdeaPluginDescriptorImpl> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = $this$toTypedArray$iv;
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        if (ideaPluginDescriptorImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        IdeaPluginDescriptorImpl[] enabledPlugins = ideaPluginDescriptorImplArray;
        this.plugins.clear();
        Arrays.sort(enabledPlugins, Comparator.comparing(finishLoading.1.INSTANCE));
        this.enabledPlugins = Arrays.asList(Arrays.copyOf(enabledPlugins, enabledPlugins.length));
    }

    public final boolean isBroken(@NotNull PluginId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Set<String> set = this.brokenPluginVersions.get(id);
        if (set == null) {
            return false;
        }
        Set<String> set2 = set;
        IdeaPluginDescriptorImpl descriptor = this.idMap.get(id);
        return descriptor != null && set2.contains(descriptor.getVersion());
    }

    public final boolean isBroken(@NotNull IdeaPluginDescriptorImpl descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Set<String> set = this.brokenPluginVersions.get(descriptor.getPluginId());
        if (set == null) {
            return false;
        }
        return set.contains(descriptor.getVersion());
    }

    @NotNull
    public final Map<PluginId, PluginLoadingError> copyPluginErrors$intellij_platform_core_impl() {
        return new HashMap(this.pluginErrors);
    }

    @NotNull
    public final List<Supplier<String>> copyGlobalErrors$intellij_platform_core_impl() {
        return new ArrayList(this.globalErrors);
    }

    public final void addIncompletePlugin$intellij_platform_core_impl(@NotNull IdeaPluginDescriptorImpl plugin, @Nullable PluginLoadingError error) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (this.idMap.containsKey(plugin.getPluginId())) {
            return;
        }
        IdeaPluginDescriptorImpl existingIncompletePlugin = this.incompletePlugins.putIfAbsent(plugin.getPluginId(), plugin);
        if (existingIncompletePlugin != null && VersionComparatorUtil.compare(plugin.getVersion(), existingIncompletePlugin.getVersion()) > 0) {
            this.incompletePlugins.put(plugin.getPluginId(), plugin);
            if (error != null) {
                this.pluginErrors.put(plugin.getPluginId(), error);
            }
        } else if (error != null) {
            this.pluginErrors.putIfAbsent(plugin.getPluginId(), error);
        }
    }

    public final void reportCannotLoad(@NotNull Path file, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PluginManagerCore.getLogger().warn("Cannot load " + file, e);
        this.globalErrors.add(new Supplier(file){
            final /* synthetic */ Path $file;

            @NotNull
            public final String get() {
                return CoreBundle.message("plugin.loading.error.text.file.contains.invalid.plugin.descriptor", IdeaPluginDescriptorImplKt.pluginPathToUserString(this.$file));
            }
            {
                this.$file = path;
            }
        });
    }

    public final boolean add(@NotNull IdeaPluginDescriptorImpl descriptor, boolean overrideUseIfCompatible) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PluginId pluginId = descriptor.getPluginId();
        if (descriptor.isIncomplete) {
            return true;
        }
        if (this.checkModuleDependencies && !descriptor.isBundled() && descriptor.packagePrefix == null && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            this.addIncompletePlugin$intellij_platform_core_impl(descriptor, new PluginLoadingError(descriptor, new Supplier(descriptor){
                final /* synthetic */ IdeaPluginDescriptorImpl $descriptor;

                @NotNull
                public final String get() {
                    return CoreBundle.message("plugin.loading.error.long.compatible.with.intellij.idea.only", this.$descriptor.getName());
                }
                {
                    this.$descriptor = ideaPluginDescriptorImpl;
                }
            }, add.2.INSTANCE, true, null, 16, null));
            return false;
        }
        this.pluginErrors.remove(pluginId);
        this.incompletePlugins.remove(pluginId);
        IdeaPluginDescriptorImpl prevDescriptor = this.plugins.put(pluginId, descriptor);
        if (prevDescriptor == null) {
            this.idMap.put(pluginId, descriptor);
            for (PluginId module : descriptor.modules) {
                this.checkAndAdd(descriptor, module);
            }
            return true;
        }
        if (prevDescriptor.isBundled() || descriptor.isBundled()) {
            this.shadowedBundledIds.add(pluginId);
        }
        if (this.isCompatible(descriptor) && (overrideUseIfCompatible || VersionComparatorUtil.compare(descriptor.getVersion(), prevDescriptor.getVersion()) > 0)) {
            PluginManagerCore.getLogger().info(descriptor + " overrides " + prevDescriptor);
            this.idMap.put(pluginId, descriptor);
            return true;
        }
        this.plugins.put(pluginId, prevDescriptor);
        return false;
    }

    private final boolean isCompatible(IdeaPluginDescriptorImpl descriptor) {
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor, this.productBuildNumber.get()) == null;
    }

    private final void checkAndAdd(IdeaPluginDescriptorImpl descriptor, PluginId id) {
        Map<PluginId, List<IdeaPluginDescriptorImpl>> map = this.duplicateModuleMap;
        if (map != null && (map = map.get(id)) != null) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> map2;
            Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicates = map2 = map;
            boolean bl = false;
            duplicates.add(descriptor);
            return;
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = this.idMap.put(id, descriptor);
        if (ideaPluginDescriptorImpl == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"idMap.put(id, descriptor) ?: return");
        IdeaPluginDescriptorImpl existingDescriptor = ideaPluginDescriptorImpl;
        this.idMap.remove(id);
        if (this.duplicateModuleMap == null) {
            this.duplicateModuleMap = new LinkedHashMap();
        }
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>(2);
        list.add(existingDescriptor);
        list.add(descriptor);
        Map<PluginId, List<IdeaPluginDescriptorImpl>> map3 = this.duplicateModuleMap;
        Intrinsics.checkNotNull(map3);
        map3.put(id, list);
    }

    public PluginLoadingResult(@NotNull Map<PluginId, ? extends Set<String>> brokenPluginVersions, @NotNull Supplier<BuildNumber> productBuildNumber, boolean checkModuleDependencies) {
        Intrinsics.checkNotNullParameter(brokenPluginVersions, (String)"brokenPluginVersions");
        Intrinsics.checkNotNullParameter(productBuildNumber, (String)"productBuildNumber");
        this.brokenPluginVersions = brokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.checkModuleDependencies = checkModuleDependencies;
        this.incompletePlugins = new ConcurrentHashMap();
        this.plugins = new HashMap();
        this.idMap = new ConcurrentHashMap();
        this.pluginErrors = new ConcurrentHashMap();
        this.globalErrors = new CopyOnWriteArrayList();
        this.shadowedBundledIds = new HashSet();
    }

    public /* synthetic */ PluginLoadingResult(Map map, Supplier supplier, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = !PlatformUtils.isIntelliJ();
        }
        this(map, supplier, bl);
    }
}

