/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.JOptionPane;
import sqldelight.com.intellij.core.CoreBundle;
import sqldelight.com.intellij.diagnostic.Activity;
import sqldelight.com.intellij.diagnostic.ActivityCategory;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.icons.AllIcons;
import sqldelight.com.intellij.ide.plugins.ClassLoaderConfigurator;
import sqldelight.com.intellij.ide.plugins.DescriptorListLoadingContext;
import sqldelight.com.intellij.ide.plugins.DisabledPluginsState;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptor;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import sqldelight.com.intellij.ide.plugins.PluginDependency;
import sqldelight.com.intellij.ide.plugins.PluginDescriptorLoader;
import sqldelight.com.intellij.ide.plugins.PluginEnabler;
import sqldelight.com.intellij.ide.plugins.PluginLoadingError;
import sqldelight.com.intellij.ide.plugins.PluginLoadingResult;
import sqldelight.com.intellij.ide.plugins.PluginManagerState;
import sqldelight.com.intellij.ide.plugins.PluginSet;
import sqldelight.com.intellij.ide.plugins.PluginSetBuilder;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.PluginDescriptor;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.util.BuildNumber;
import sqldelight.com.intellij.openapi.util.NlsContexts;
import sqldelight.com.intellij.openapi.util.NlsSafe;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.openapi.util.io.NioFiles;
import sqldelight.com.intellij.openapi.util.text.HtmlChunk;
import sqldelight.com.intellij.util.lang.UrlClassLoader;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.Nls;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.PropertyKey;

public final class PluginManagerCore {
    @NonNls
    public static final String META_INF = "META-INF/";
    public static final String CORE_PLUGIN_ID = "sqldelight.com.intellij";
    public static final PluginId CORE_ID = PluginId.getId("sqldelight.com.intellij");
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("sqldelight.com.intellij.java");
    static final PluginId JAVA_MODULE_ID = PluginId.getId("sqldelight.com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    static final PluginId ALL_MODULES_MARKER = PluginId.getId("sqldelight.com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    public static final String VENDOR_JETBRAINS_SRO = "JetBrains s.r.o.";
    private static final String MODULE_DEPENDENCY_PREFIX = "sqldelight.com.intellij.module";
    public static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    @NonNls
    static final String DISABLE = "disable";
    @NonNls
    static final String ENABLE = "enable";
    @NonNls
    static final String EDIT = "edit";
    private static final boolean IGNORE_DISABLED_PLUGINS = Boolean.getBoolean("idea.ignore.disabled.plugins");
    private static final String THIRD_PARTY_PLUGINS_FILE = "alien_plugins.txt";
    @Nullable
    private static volatile Boolean thirdPartyPluginsNoteAccepted = null;
    private static Reference<Map<PluginId, Set<String>>> brokenPluginVersions;
    @Nullable
    private static volatile PluginSet pluginSet;
    private static Map<PluginId, PluginLoadingError> pluginLoadingErrors;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    private static final List<Supplier<? extends HtmlChunk>> pluginErrors;
    private static Set<PluginId> ourPluginsToDisable;
    private static Set<PluginId> ourPluginsToEnable;
    private static Set<PluginId> shadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<PluginSet> initFuture;
    private static BuildNumber ourBuildNumber;

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPluginSet().allPlugins.toArray(new IdeaPluginDescriptor[0]);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginSet getPluginSet() {
        PluginSet pluginSet = Objects.requireNonNull(PluginManagerCore.pluginSet);
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return pluginSet;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<IdeaPluginDescriptorImpl> list = PluginManagerCore.getPluginSet().enabledPlugins;
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        PluginSet result = pluginSet;
        if (result != null) {
            List<IdeaPluginDescriptorImpl> list = result.enabledPlugins;
            if (list == null) {
                PluginManagerCore.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<IdeaPluginDescriptorImpl> list = PluginManagerCore.loadAndInitializePlugins((DescriptorListLoadingContext)PluginDescriptorLoader.loadDescriptors((boolean)PluginManagerCore.isUnitTestMode, (boolean)PluginManagerCore.isRunningFromSources()), (ClassLoader)(coreClassLoader == null ? PluginManagerCore.class.getClassLoader() : coreClassLoader)).enabledPlugins;
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @NotNull
    public static List<HtmlChunk> getAndClearPluginLoadingErrors() {
        List<Supplier<? extends HtmlChunk>> list = pluginErrors;
        // MONITORENTER : list
        if (pluginErrors.isEmpty()) {
            List<HtmlChunk> list2 = Collections.emptyList();
            // MONITOREXIT : list
            if (list2 != null) return list2;
            PluginManagerCore.$$$reportNull$$$0(5);
            return list2;
        }
        ArrayList<HtmlChunk> errors = new ArrayList<HtmlChunk>(pluginErrors.size());
        Iterator<Supplier<? extends HtmlChunk>> iterator = pluginErrors.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                pluginErrors.clear();
                ArrayList<HtmlChunk> arrayList = errors;
                // MONITOREXIT : list
                if (arrayList != null) return arrayList;
                PluginManagerCore.$$$reportNull$$$0(6);
                return arrayList;
            }
            Supplier<? extends HtmlChunk> t = iterator.next();
            errors.add(t.get());
        }
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return pluginSet != null;
    }

    @ApiStatus.Internal
    public static void setPluginSet(@NotNull PluginSet value) {
        if (value == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        pluginSet = value;
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        return PluginEnabler.HEADLESS.isDisabled(pluginId);
    }

    @ApiStatus.Internal
    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        PluginId pluginId = descriptor.getPluginId();
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set != null && set.contains(descriptor.getVersion());
    }

    @ApiStatus.Internal
    public static void updateBrokenPlugins(Map<PluginId, Set<String>> brokenPlugins) {
        brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(brokenPlugins);
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        try (DataOutputStream out2 = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(updatedBrokenPluginFile, new OpenOption[0]), 32000));){
            out2.write(2);
            out2.writeUTF(PluginManagerCore.getBuildNumber().asString());
            out2.writeInt(brokenPlugins.size());
            for (Map.Entry<PluginId, Set<String>> entry : brokenPlugins.entrySet()) {
                out2.writeUTF(entry.getKey().getIdString());
                out2.writeShort(entry.getValue().size());
                for (String s : entry.getValue()) {
                    out2.writeUTF(s);
                }
            }
        }
        catch (NoSuchFileException out2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + updatedBrokenPluginFile, e);
        }
    }

    @NotNull
    static @NotNull Map<@NotNull PluginId, @NotNull Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result;
        if (IGNORE_DISABLED_PLUGINS) {
            Map<PluginId, Set<String>> map = Collections.emptyMap();
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(10);
            }
            return map;
        }
        Map<PluginId, Set<String>> map = result = brokenPluginVersions == null ? null : brokenPluginVersions.get();
        if (result == null) {
            result = PluginManagerCore.readBrokenPluginFile();
            brokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result);
        }
        Map<PluginId, Set<String>> map2 = result;
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    private static Map<PluginId, Set<String>> readBrokenPluginFile() {
        Map<PluginId, Set<String>> result = null;
        Path updatedBrokenPluginFile = PluginManagerCore.getUpdatedBrokenPluginFile();
        if (Files.exists(updatedBrokenPluginFile, new LinkOption[0]) && (result = PluginManagerCore.tryReadBrokenPluginsFile(updatedBrokenPluginFile)) != null) {
            PluginManagerCore.getLogger().info("Using cached broken plugins file");
        }
        if (result == null && (result = PluginManagerCore.tryReadBrokenPluginsFile(Paths.get(PathManager.getBinPath() + "/brokenPlugins.db", new String[0]))) != null) {
            PluginManagerCore.getLogger().info("Using broken plugins file from IDE distribution");
        }
        if (result != null) {
            Map<PluginId, Set<String>> map = result;
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(12);
            }
            return map;
        }
        Map<PluginId, Set<String>> map = Collections.emptyMap();
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Map<PluginId, Set<String>> tryReadBrokenPluginsFile(Path brokenPluginsStorage) {
        try (DataInputStream stream2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(brokenPluginsStorage, new OpenOption[0]), 32000));){
            int version2 = stream2.readUnsignedByte();
            if (version2 != 2) {
                PluginManagerCore.getLogger().info("Unsupported version of " + brokenPluginsStorage + "(fileVersion=" + version2 + ", supportedVersion=2)");
                Map<PluginId, Set<String>> map = null;
                return map;
            }
            String buildNumber = stream2.readUTF();
            if (!buildNumber.equals(PluginManagerCore.getBuildNumber().toString())) {
                PluginManagerCore.getLogger().info("Ignoring cached broken plugins file from an earlier IDE build (" + buildNumber + ")");
                Map<PluginId, Set<String>> map = null;
                return map;
            }
            int count = stream2.readInt();
            HashMap<PluginId, Set<String>> result = new HashMap<PluginId, Set<String>>(count);
            for (int i = 0; i < count; ++i) {
                PluginId pluginId = PluginId.getId(stream2.readUTF());
                String[] versions = new String[stream2.readUnsignedShort()];
                for (int j = 0; j < versions.length; ++j) {
                    versions[j] = stream2.readUTF();
                }
                result.put(pluginId, versions.length == 1 ? Collections.singleton(versions[0]) : new HashSet<String>(Arrays.asList(versions)));
            }
            HashMap<PluginId, Set<String>> hashMap = result;
            return hashMap;
        }
        catch (NoSuchFileException stream2) {
            return null;
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error("Failed to read " + brokenPluginsStorage, e);
        }
        return null;
    }

    @ApiStatus.Internal
    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer2) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        if (writer2 == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        for (PluginId id : sortedIds) {
            writer2.write(id.getIdString());
            writer2.write(10);
        }
    }

    @ApiStatus.Internal
    public static boolean disablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return PluginEnabler.HEADLESS.disableById(Collections.singleton(id));
    }

    @ApiStatus.Internal
    public static boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return PluginEnabler.HEADLESS.enableById(Collections.singleton(id));
    }

    @ApiStatus.Internal
    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginDescriptor result;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        PluginId id = (result = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result.getPluginId();
        return id == null || CORE_ID.equals(id) ? null : id;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        return (result = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result.getPluginId();
    }

    @ApiStatus.Internal
    public static boolean isPlatformClass(@NotNull @NonNls String className) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.");
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull @NonNls String className) {
        PluginSet pluginSet;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null || PluginManagerCore.isPlatformClass(className) || !className.contains(".")) {
            return null;
        }
        IdeaPluginDescriptorImpl result = null;
        for (IdeaPluginDescriptorImpl descriptor : pluginSet.getRawListOfEnabledModules()) {
            ClassLoader classLoader = descriptor.getPluginClassLoader();
            if (!(classLoader instanceof UrlClassLoader) || !((UrlClassLoader)classLoader).hasLoadedClass(className)) continue;
            result = descriptor;
            break;
        }
        if (result == null) {
            return null;
        }
        if (!CORE_ID.equals(result.getPluginId()) || className.startsWith("sqldelight.com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("sqldelight.com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result;
        }
        return PluginManagerCore.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    @Nullable
    private static IdeaPluginDescriptorImpl findClassInPluginThatUsesCoreClassloader(@NonNls @NotNull String className, PluginSet pluginSet) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        String root = null;
        for (IdeaPluginDescriptorImpl descriptor : pluginSet.enabledPlugins) {
            if (!descriptor.isUseIdeaClassLoader) continue;
            if (root == null && (root = PathManager.getResourceRoot(descriptor.getClassLoader(), className.replace('.', '/') + ".class")) == null) {
                return null;
            }
            Path path = descriptor.getPluginPath();
            if (!root.startsWith(FileUtilRt.toSystemIndependentName(path.toString()))) continue;
            return descriptor;
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorIfIdeaClassLoaderIsUsed(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        String className = aClass.getName();
        PluginSet pluginSet = PluginManagerCore.pluginSet;
        if (pluginSet == null || PluginManagerCore.isPlatformClass(className) || !className.contains(".")) {
            return null;
        }
        return PluginManagerCore.findClassInPluginThatUsesCoreClassloader(className, pluginSet);
    }

    public static boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        return CORE_ID.equals(plugin.getPluginId()) || SPECIAL_IDEA_PLUGIN_ID.equals(plugin.getPluginId()) || PluginManagerCore.isDevelopedByJetBrains(plugin.getVendor()) || PluginManagerCore.isDevelopedByJetBrains(plugin.getOrganization());
    }

    public static boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (PluginManagerCore.isVendorJetBrains(vendorString)) {
            return true;
        }
        for (String vendor : vendorString.split(",")) {
            String vendorItem = vendor.trim();
            if (!PluginManagerCore.isVendorJetBrains(vendorItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVendorJetBrains(@NotNull String vendorItem) {
        if (vendorItem == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        return VENDOR_JETBRAINS.equals(vendorItem) || VENDOR_JETBRAINS_SRO.equals(vendorItem);
    }

    private static Path getUpdatedBrokenPluginFile() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("updatedBrokenPlugins.db");
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            PluginId dependencyPluginId = dependency.getPluginId();
            if (!JAVA_PLUGIN_ID.equals(dependencyPluginId) && !JAVA_MODULE_ID.equals(dependencyPluginId) && !PluginManagerCore.isModuleDependency(dependencyPluginId)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void invalidatePlugins() {
        pluginSet = null;
        CompletableFuture<PluginSet> future = initFuture;
        if (future != null) {
            initFuture = null;
            future.cancel(false);
        }
        DisabledPluginsState.invalidate();
        shadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull List<IdeaPluginDescriptorImpl> plugins, @NotNull Collection<IdeaPluginDescriptorImpl> incompletePlugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (incompletePlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        HashSet<PluginId> disabledPlugins = new HashSet<PluginId>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : plugins) {
            StringBuilder target;
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            if (!ideaPluginDescriptor.isEnabled()) {
                if (!PluginManagerCore.isDisabled(pluginId)) continue;
                disabledPlugins.add(pluginId);
                target = disabled;
            } else {
                target = ideaPluginDescriptor.isBundled() || SPECIAL_IDEA_PLUGIN_ID.equals(pluginId) ? bundled : custom;
            }
            PluginManagerCore.appendPlugin(ideaPluginDescriptor, target);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : incompletePlugins) {
            PluginId pluginId = ideaPluginDescriptorImpl.getPluginId();
            if (!PluginManagerCore.isDisabled(pluginId) || disabledPlugins.contains(pluginId)) continue;
            PluginManagerCore.appendPlugin(ideaPluginDescriptorImpl, disabled);
        }
        Logger logger2 = PluginManagerCore.getLogger();
        logger2.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger2.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger2.info("Disabled plugins: " + disabled);
        }
    }

    private static void appendPlugin(IdeaPluginDescriptor descriptor, StringBuilder target) {
        if (target.length() > 0) {
            target.append(", ");
        }
        target.append(descriptor.getName());
        String version2 = descriptor.getVersion();
        if (version2 != null) {
            target.append(" (").append(version2).append(')');
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result = isRunningFromSources;
        if (result == null) {
            isRunningFromSources = result = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result;
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> preparePluginErrors(@NotNull List<Supplier<@NlsContexts.DetailedDescription String>> globalErrorsSuppliers) {
        if (globalErrorsSuppliers == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (pluginLoadingErrors.isEmpty() && globalErrorsSuppliers.isEmpty()) {
            return new ArrayList<Supplier<HtmlChunk>>();
        }
        List<@NlsContexts.DetailedDescription T> globalErrors = globalErrorsSuppliers.stream().map(Supplier::get).collect(Collectors.toList());
        List loadingErrors = pluginLoadingErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        String logMessage = "Problems found loading plugins:\n  " + Stream.concat(globalErrors.stream(), loadingErrors.stream().map(PluginLoadingError::getInternalMessage)).collect(Collectors.joining("\n  "));
        if (isUnitTestMode || !GraphicsEnvironment.isHeadless()) {
            PluginManagerCore.getLogger().warn(logMessage);
            List<Supplier<HtmlChunk>> list = Stream.concat(globalErrors.stream(), loadingErrors.stream().filter(PluginLoadingError::isNotifyUser).map(PluginLoadingError::getDetailedMessage)).map(text -> () -> HtmlChunk.text(text)).collect(Collectors.toList());
            if (list == null) {
                PluginManagerCore.$$$reportNull$$$0(31);
            }
            return list;
        }
        PluginManagerCore.getLogger().error(logMessage);
        return new ArrayList<Supplier<HtmlChunk>>();
    }

    @Nullable
    public static PluginLoadingError getLoadingError(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        return pluginLoadingErrors.get(pluginId);
    }

    @NotNull
    private static List<Supplier<HtmlChunk>> prepareActions(@NotNull Set<IdeaPluginDescriptorImpl> disabledIds, @NotNull Set<IdeaPluginDescriptorImpl> disabledRequiredIds) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        if (disabledIds.isEmpty()) {
            List<Supplier<HtmlChunk>> list = Collections.emptyList();
            if (list == null) {
                PluginManagerCore.$$$reportNull$$$0(35);
            }
            return list;
        }
        ArrayList<Supplier<HtmlChunk>> actions = new ArrayList<Supplier<HtmlChunk>>();
        String nameToDisable = PluginManagerCore.getFirstPluginName(disabledIds);
        actions.add(() -> HtmlChunk.link(DISABLE, nameToDisable == null ? CoreBundle.message("link.text.disable.not.loaded.plugins", new Object[0]) : CoreBundle.message("link.text.disable.plugin", nameToDisable)));
        if (!disabledRequiredIds.isEmpty()) {
            String nameToEnable = PluginManagerCore.getFirstPluginName(disabledRequiredIds);
            actions.add(() -> HtmlChunk.link(ENABLE, nameToEnable == null ? CoreBundle.message("link.text.enable.all.necessary.plugins", new Object[0]) : CoreBundle.message("link.text.enable.plugin", nameToEnable)));
        }
        actions.add(() -> HtmlChunk.link(EDIT, CoreBundle.message("link.text.open.plugin.manager", new Object[0])));
        ArrayList<Supplier<HtmlChunk>> arrayList = actions;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Nullable
    @NlsSafe
    private static String getFirstPluginName(@NotNull Set<IdeaPluginDescriptorImpl> modules) {
        if (modules == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        switch (modules.size()) {
            case 0: {
                throw new IllegalArgumentException("Plugins set should not be empty");
            }
            case 1: {
                return modules.iterator().next().getName();
            }
        }
        return null;
    }

    @ApiStatus.Internal
    static synchronized boolean onEnable(boolean enabled) {
        boolean applied;
        Set<PluginId> pluginIds = enabled ? ourPluginsToEnable : ourPluginsToDisable;
        ourPluginsToEnable = null;
        ourPluginsToDisable = null;
        boolean bl = applied = pluginIds != null;
        if (applied) {
            for (IdeaPluginDescriptorImpl module : PluginManagerCore.getPluginSet().allPlugins) {
                if (!pluginIds.contains(module.getPluginId())) continue;
                module.setEnabled(enabled);
            }
            DisabledPluginsState.setEnabledState(pluginIds, enabled);
        }
        return applied;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<PluginSet> getOrScheduleLoading() {
        CompletableFuture<PluginSet> future = initFuture;
        if (future != null) {
            CompletableFuture<PluginSet> completableFuture = future;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        initFuture = future = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity("plugin descriptor loading", ActivityCategory.DEFAULT);
            DescriptorListLoadingContext context2 = PluginDescriptorLoader.loadDescriptors(isUnitTestMode, PluginManagerCore.isRunningFromSources());
            activity.end();
            return PluginManagerCore.loadAndInitializePlugins(context2, PluginManagerCore.class.getClassLoader());
        }, ForkJoinPool.commonPool());
        CompletableFuture<PluginSet> completableFuture = future;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<List<IdeaPluginDescriptorImpl>> getEnabledPluginRawList() {
        CompletionStage completionStage = PluginManagerCore.getOrScheduleLoading().thenApply(it -> it.enabledPlugins);
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletableFuture<PluginSet> getInitPluginFuture() {
        CompletableFuture<PluginSet> future = initFuture;
        if (future == null) {
            throw new IllegalStateException("Call scheduleDescriptorLoading() first");
        }
        CompletableFuture<PluginSet> completableFuture = future;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        return completableFuture;
    }

    @NotNull
    public static BuildNumber getBuildNumber() {
        BuildNumber result = ourBuildNumber;
        if (result == null) {
            result = BuildNumber.fromPluginsCompatibleBuild();
            if (result == null) {
                if (isUnitTestMode) {
                    result = BuildNumber.currentVersion();
                } else {
                    try {
                        result = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result;
        }
        BuildNumber buildNumber = result;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull PluginSetBuilder builder, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Map<PluginId, PluginLoadingError> errors) {
        if (builder == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set = new HashSet();
            for (String it : selectedIds.split(",")) {
                set.add(PluginId.getId(it));
            }
            set.addAll(ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PluginId id = (PluginId)iterator.next();
                IdeaPluginDescriptorImpl descriptor = idMap.get(id);
                if (descriptor == null) continue;
                explicitlyEnabled.add(descriptor);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl descriptor : builder.getUnsortedPlugins()) {
                if (!selectedCategory.equals(descriptor.getCategory())) continue;
                explicitlyEnabled.add(descriptor);
            }
        }
        if (explicitlyEnabled != null) {
            ArrayList nonOptionalDependencies = new ArrayList();
            Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
            for (IdeaPluginDescriptorImpl descriptor : explicitlyEnabled) {
                PluginManagerCore.processAllNonOptionalDependencies(descriptor, pluginIdMap, dependency -> {
                    nonOptionalDependencies.add(dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
            explicitlyEnabled.addAll(nonOptionalDependencies);
        }
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        boolean shouldLoadPlugins = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor : builder.getUnsortedPlugins()) {
            if (descriptor == coreDescriptor) continue;
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor)) continue;
                descriptor.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin '" + descriptor.getName() + "' " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (shouldLoadPlugins) continue;
            descriptor.setEnabled(false);
            errors.put(descriptor.getPluginId(), new PluginLoadingError(descriptor, PluginManagerCore.message("plugin.loading.error.long.plugin.loading.disabled", descriptor.getName()), PluginManagerCore.message("plugin.loading.error.short.plugin.loading.disabled", new Object[0])));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        return !PluginManagerCore.isIncompatible(descriptor);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        return !PluginManagerCore.isIncompatible(descriptor, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        return PluginManagerCore.isIncompatible(descriptor, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.checkBuildNumberCompatibility(descriptor, buildNumber) != null;
    }

    @Nullable
    public static PluginLoadingError checkBuildNumberCompatibility(@NotNull IdeaPluginDescriptor descriptor, @NotNull BuildNumber ideBuildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (ideBuildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        String sinceBuild = descriptor.getSinceBuild();
        String untilBuild = descriptor.getUntilBuild();
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            BuildNumber buildNumber = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString(sinceBuild, descriptor.getName(), null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(ideBuildNumber) > 0) {
                return new PluginLoadingError(descriptor, PluginManagerCore.message("plugin.loading.error.long.incompatible.since.build", descriptor.getName(), descriptor.getVersion(), sinceBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.since.build", sinceBuild));
            }
            BuildNumber buildNumber2 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString(untilBuild, descriptor.getName(), null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(ideBuildNumber) < 0) {
                return new PluginLoadingError(descriptor, PluginManagerCore.message("plugin.loading.error.long.incompatible.until.build", descriptor.getName(), descriptor.getVersion(), untilBuild, ideBuildNumber), PluginManagerCore.message("plugin.loading.error.short.incompatible.until.build", untilBuild));
            }
            return null;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return new PluginLoadingError(descriptor, PluginManagerCore.message("plugin.loading.error.long.failed.to.load.requirements.for.ide.version", descriptor.getName()), PluginManagerCore.message("plugin.loading.error.short.failed.to.load.requirements.for.ide.version", new Object[0]));
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        List<PluginId> required = ApplicationInfoImpl.getShadowInstance().getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id : required) {
            IdeaPluginDescriptorImpl descriptor = idMap.get(id);
            if (descriptor != null && descriptor.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins, @Nullable Activity parentActivity) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        PluginLoadingResult loadingResult2 = context2.result;
        Map<PluginId, PluginLoadingError> pluginErrorsById = loadingResult2.copyPluginErrors$intellij_platform_core_impl();
        List<Supplier<String>> globalErrors = loadingResult2.copyGlobalErrors$intellij_platform_core_impl();
        if (loadingResult2.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : loadingResult2.duplicateModuleMap.entrySet()) {
                globalErrors.add(() -> CoreBundle.message("plugin.loading.error.module.declared.by.multiple.plugins", entry.getKey(), ((List)entry.getValue()).stream().map(IdeaPluginDescriptorImpl::toString).collect(Collectors.joining("\n  "))));
            }
        }
        ConcurrentHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult2.idMap;
        if (checkEssentialPlugins && !idMap.containsKey(CORE_ID)) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        Activity activity = parentActivity == null ? null : parentActivity.startChild("3rd-party plugins consent");
        Collection<IdeaPluginDescriptorImpl> aliens = PluginManagerCore.get3rdPartyPlugins(idMap);
        if (!aliens.isEmpty()) {
            PluginManagerCore.check3rdPartyPluginsPrivacyConsent(aliens);
        }
        if (activity != null) {
            activity.end();
        }
        PluginSetBuilder pluginSetBuilder = new PluginSetBuilder(loadingResult2.getEnabledPlugins());
        PluginManagerCore.disableIncompatiblePlugins(pluginSetBuilder, idMap, pluginErrorsById);
        pluginSetBuilder.checkPluginCycles(globalErrors);
        HashSet<IdeaPluginDescriptorImpl> disabledAfterInit = new HashSet<IdeaPluginDescriptorImpl>();
        HashSet<IdeaPluginDescriptorImpl> disabledRequired = new HashSet<IdeaPluginDescriptorImpl>();
        pluginSetBuilder.computeEnabledModuleMap(descriptor -> {
            if (pluginSetBuilder.initEnableState$intellij_platform_core_impl((IdeaPluginDescriptorImpl)descriptor, (Map<PluginId, IdeaPluginDescriptorImpl>)idMap, (Set<IdeaPluginDescriptorImpl>)disabledRequired, context2.disabledPlugins, pluginErrorsById)) {
                return false;
            }
            descriptor.setEnabled(false);
            disabledAfterInit.add((IdeaPluginDescriptorImpl)descriptor);
            return true;
        });
        List<Supplier<HtmlChunk>> actions = PluginManagerCore.prepareActions(disabledAfterInit, disabledRequired);
        pluginLoadingErrors = pluginErrorsById;
        List<Supplier<HtmlChunk>> errorList = PluginManagerCore.preparePluginErrors(globalErrors);
        if (!errorList.isEmpty()) {
            List<Supplier<? extends HtmlChunk>> list = pluginErrors;
            synchronized (list) {
                pluginErrors.addAll(errorList);
                pluginErrors.addAll(actions);
            }
        }
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        PluginSet pluginSet = pluginSetBuilder.createPluginSet(context2.result.incompletePlugins.values());
        new ClassLoaderConfigurator(pluginSet, coreLoader).configure();
        return new PluginManagerState(pluginSet, disabledRequired, disabledAfterInit);
    }

    private static void check3rdPartyPluginsPrivacyConsent(Collection<? extends IdeaPluginDescriptor> aliens) {
        if (GraphicsEnvironment.isHeadless()) {
            PluginManagerCore.getLogger().info("3rd-party plugin privacy note not accepted yet; disabling plugins for this headless session");
            aliens.forEach(descriptor -> descriptor.setEnabled(false));
        } else if (!PluginManagerCore.ask3rdPartyPluginsPrivacyConsent(aliens)) {
            PluginManagerCore.getLogger().info("3rd-party plugin privacy note declined; disabling plugins");
            aliens.forEach(descriptor -> descriptor.setEnabled(false));
            PluginEnabler.HEADLESS.disableById(aliens.stream().map(descriptor -> descriptor.getPluginId()).collect(Collectors.toSet()));
            thirdPartyPluginsNoteAccepted = Boolean.FALSE;
        } else {
            thirdPartyPluginsNoteAccepted = Boolean.TRUE;
        }
    }

    @ApiStatus.Internal
    @Nullable
    static Boolean isThirdPartyPluginsNoteAccepted() {
        Boolean result = thirdPartyPluginsNoteAccepted;
        thirdPartyPluginsNoteAccepted = null;
        return result;
    }

    @ApiStatus.Internal
    static synchronized void write3rdPartyPlugins(@NotNull Collection<? extends IdeaPluginDescriptor> aliens) {
        if (aliens == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        Path file = Paths.get(PathManager.getConfigPath(), THIRD_PARTY_PLUGINS_FILE);
        try {
            NioFiles.createDirectories(file.getParent());
            try (BufferedWriter writer2 = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                PluginManagerCore.writePluginsList(aliens.stream().map(PluginDescriptor::getPluginId).collect(Collectors.toList()), writer2);
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().error(file.toString(), e);
        }
    }

    private static Collection<IdeaPluginDescriptorImpl> get3rdPartyPlugins(Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        Path file = Paths.get(PathManager.getConfigPath(), THIRD_PARTY_PLUGINS_FILE);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                List<String> ids = Files.readAllLines(file);
                Files.delete(file);
                return ids.stream().map(id -> (IdeaPluginDescriptorImpl)descriptors.get(PluginId.getId(id))).filter(descriptor -> descriptor != null).collect(Collectors.toList());
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().error(file.toString(), e);
            }
        }
        return Collections.emptyList();
    }

    private static boolean ask3rdPartyPluginsPrivacyConsent(Iterable<? extends IdeaPluginDescriptor> descriptors) {
        String title = CoreBundle.message("third.party.plugins.privacy.note.title", new Object[0]);
        String pluginList = StreamSupport.stream(descriptors.spliterator(), false).map(descriptor -> "&nbsp;&nbsp;&nbsp;" + descriptor.getName() + " (" + descriptor.getVendor() + ')').collect(Collectors.joining("<br>"));
        String text = CoreBundle.message("third.party.plugins.privacy.note.text", pluginList);
        Object[] buttons = new String[]{CoreBundle.message("third.party.plugins.privacy.note.accept", new Object[0]), CoreBundle.message("third.party.plugins.privacy.note.disable", new Object[0])};
        int choice = JOptionPane.showOptionDialog(null, text, title, 2, 2, AllIcons.General.WarningDialog, buttons, buttons[0]);
        return choice == 0;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull PluginId id, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id)) != null) {
            duplicates.add(descriptor);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id, descriptor);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        list.add(existingDescriptor);
        list.add(descriptor);
        duplicateMap.put(id, list);
        return duplicateMap;
    }

    @NotNull
    @Nls
    private static Supplier<String> message(final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String key, final Object ... params2) {
        if (key == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (params2 == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        return new Supplier<String>(){

            @Override
            public String get() {
                return CoreBundle.message(key, params2);
            }
        };
    }

    @NotNull
    private static synchronized PluginSet loadAndInitializePlugins(@NotNull DescriptorListLoadingContext context2, @NotNull ClassLoader coreLoader) {
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (IdeaPluginDescriptorImpl.disableNonBundledPlugins) {
            PluginManagerCore.getLogger().info("Running with disableThirdPartyPlugins argument, third-party plugins will be disabled");
        }
        Activity activity = StartUpMeasurer.startActivity("plugin initialization", ActivityCategory.DEFAULT);
        PluginManagerState initResult = PluginManagerCore.initializePlugins(context2, coreLoader, !isUnitTestMode, activity);
        PluginLoadingResult result = context2.result;
        ourPluginsToDisable = initResult.effectiveDisabledIds;
        ourPluginsToEnable = initResult.disabledRequiredIds;
        shadowedBundledPlugins = result.shadowedBundledIds;
        activity.end();
        activity.setDescription("plugin count: " + initResult.pluginSet.enabledPlugins.size());
        PluginManagerCore.logPlugins(initResult.pluginSet.allPlugins, result.incompletePlugins.values());
        pluginSet = initResult.pluginSet;
        PluginSet pluginSet = initResult.pluginSet;
        if (pluginSet == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        return pluginSet;
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger2 = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger2 == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        return logger2;
    }

    @Contract(value="null -> null")
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        return id != null ? PluginManagerCore.findPlugin(id) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPlugin(@NotNull PluginId id) {
        PluginSet pluginSet;
        IdeaPluginDescriptorImpl result;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if ((result = (pluginSet = PluginManagerCore.getPluginSet()).findEnabledPlugin(id)) != null) {
            return result;
        }
        return pluginSet.findInstalledPlugin(id);
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl findPluginByModuleDependency(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        for (IdeaPluginDescriptorImpl descriptor : PluginManagerCore.getPluginSet().allPlugins) {
            if (!descriptor.modules.contains(id)) continue;
            return descriptor;
        }
        return null;
    }

    public static boolean isPluginInstalled(@NotNull PluginId id) {
        PluginSet pluginSet;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if ((pluginSet = PluginManagerCore.pluginSet) == null) {
            return false;
        }
        return pluginSet.isPluginEnabled(id) || pluginSet.isPluginInstalled(id);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        HashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new HashMap<PluginId, IdeaPluginDescriptorImpl>(PluginManagerCore.getPluginSet().allPlugins.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor : PluginManagerCore.getPluginSet().allPlugins) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor, descriptor.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor.modules) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        HashMap<PluginId, IdeaPluginDescriptorImpl> hashMap = idMap;
        if (hashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        return hashMap;
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencyIds(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Function<? super PluginId, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, new HashSet<IdeaPluginDescriptorImpl>(), pluginIdMap, (? super PluginId pluginId, ? super IdeaPluginDescriptorImpl __) -> (FileVisitResult)((Object)((Object)consumer.apply((PluginId)pluginId))));
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Function<? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, new HashSet<IdeaPluginDescriptorImpl>(), pluginIdMap, consumer);
    }

    @ApiStatus.Internal
    public static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Set<IdeaPluginDescriptorImpl> depProcessed, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Function<? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        return PluginManagerCore.processAllNonOptionalDependencies(rootDescriptor, depProcessed, pluginIdMap, (? super PluginId __, ? super IdeaPluginDescriptorImpl descriptor) -> (FileVisitResult)((Object)((Object)consumer.apply((IdeaPluginDescriptorImpl)descriptor))));
    }

    private static boolean processAllNonOptionalDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Set<IdeaPluginDescriptorImpl> depProcessed, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull BiFunction<? super PluginId, ? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (pluginIdMap == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        for (PluginId dependencyId : PluginManagerCore.getNonOptionalDependenciesIds(rootDescriptor)) {
            IdeaPluginDescriptorImpl descriptor = pluginIdMap.get(dependencyId);
            PluginId pluginId = descriptor != null ? descriptor.getPluginId() : dependencyId;
            switch (consumer.apply(pluginId, descriptor)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor == null || !depProcessed.add(descriptor)) break;
                    PluginManagerCore.processAllNonOptionalDependencies(descriptor, depProcessed, pluginIdMap, consumer);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    @NotNull
    private static List<PluginId> getNonOptionalDependenciesIds(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        ArrayList<PluginId> dependencies = new ArrayList<PluginId>();
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            if (dependency.isOptional()) continue;
            dependencies.add(dependency.getPluginId());
        }
        for (ModuleDependenciesDescriptor.PluginReference plugin : descriptor.dependencies.plugins) {
            dependencies.add(plugin.id);
        }
        List<PluginId> list = Collections.unmodifiableList(dependencies);
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        return list;
    }

    @ApiStatus.Internal
    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        return shadowedBundledPlugins != null && shadowedBundledPlugins.contains(plugin.getPluginId());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        return PluginManagerCore.isDisabled(PluginId.getId(pluginId));
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void addDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        DisabledPluginsState.addDisablePluginListener(listener);
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        pluginErrors = new ArrayList<Supplier<? extends HtmlChunk>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 32: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 9: 
            case 27: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 56: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 16: 
            case 17: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 25: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorItem";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompletePlugins";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrorsSuppliers";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 44: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideBuildNumber";
                break;
            }
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 54: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliens";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 69: 
            case 72: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 70: 
            case 73: 
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 71: 
            case 74: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearPluginLoadingErrors";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readBrokenPluginFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePluginErrors";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareActions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitPluginFuture";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndInitializePlugins";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPluginSet";
                break;
            }
            case 8: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 16: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPlatformClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClassInPluginThatUsesCoreClassloader";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorIfIdeaClassLoaderIsUsed";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isVendorJetBrains";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "preparePluginErrors";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepareActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPluginName";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildNumberCompatibility";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "write3rdPartyPlugins";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "loadAndInitializePlugins";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isPluginInstalled";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processAllNonOptionalDependencyIds";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "processAllNonOptionalDependencies";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getNonOptionalDependenciesIds";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "sqldelight/com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

