/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.ui;

import java.awt.Dimension;
import java.lang.reflect.Field;
import sqldelight.com.intellij.openapi.diagnostic.Logger;

public final class FontSubpixelResolution {
    private static final Logger LOG;
    public static final Dimension RESOLUTION;
    public static final boolean ENABLED;

    static {
        Dimension resolution;
        LOG = Logger.getInstance(FontSubpixelResolution.class);
        try {
            Field field = Class.forName("sun.font.FontUtilities").getDeclaredField("supplementarySubpixelGlyphResolution");
            field.setAccessible(true);
            resolution = (Dimension)field.get(null);
        }
        catch (ReflectiveOperationException ignore) {
            resolution = null;
        }
        catch (Throwable e) {
            resolution = null;
            LOG.error("Couldn't get font subpixel resolution settings", e);
        }
        RESOLUTION = resolution;
        ENABLED = RESOLUTION != null && (FontSubpixelResolution.RESOLUTION.width > 1 || FontSubpixelResolution.RESOLUTION.height > 1);
    }
}

