/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.jna;

import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.util.system.CpuArch;
import sqldelight.com.sun.jna.Native;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(@NotNull Logger logger2) {
        if (logger2 == null) {
            JnaLoader.$$$reportNull$$$0(0);
        }
        if (ourJnaLoaded == null) {
            ourJnaLoaded = Boolean.FALSE;
            try {
                long t = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t = System.currentTimeMillis() - t;
                logger2.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t) {
                logger2.warn("Unable to load JNA library (OS: " + SystemInfoRt.OS_NAME + " " + SystemInfoRt.OS_VERSION + ")", t);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }

    public static boolean isSupportsDirectMapping() {
        return !SystemInfoRt.isMac || !CpuArch.isArm64();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "sqldelight/com/intellij/jna/JnaLoader", "load"));
    }
}

