/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.lang.jvm.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class JvmPrimitiveTypeKind {
    public static final JvmPrimitiveTypeKind BOOLEAN = new JvmPrimitiveTypeKind("boolean", "java.lang.Boolean", "Z");
    public static final JvmPrimitiveTypeKind BYTE = new JvmPrimitiveTypeKind("byte", "java.lang.Byte", "B");
    public static final JvmPrimitiveTypeKind CHAR = new JvmPrimitiveTypeKind("char", "java.lang.Character", "C");
    public static final JvmPrimitiveTypeKind DOUBLE = new JvmPrimitiveTypeKind("double", "java.lang.Double", "D");
    public static final JvmPrimitiveTypeKind FLOAT = new JvmPrimitiveTypeKind("float", "java.lang.Float", "F");
    public static final JvmPrimitiveTypeKind INT = new JvmPrimitiveTypeKind("int", "java.lang.Integer", "I");
    public static final JvmPrimitiveTypeKind LONG = new JvmPrimitiveTypeKind("long", "java.lang.Long", "J");
    public static final JvmPrimitiveTypeKind SHORT = new JvmPrimitiveTypeKind("short", "java.lang.Short", "S");
    public static final JvmPrimitiveTypeKind VOID = new JvmPrimitiveTypeKind("void", "java.lang.Void", "V");
    private final String myName;
    private final String myBoxedFqn;
    private final String myBinaryName;
    private static final Map<String, JvmPrimitiveTypeKind> ourNameToKind;
    private static final Map<String, JvmPrimitiveTypeKind> ourFqnToKind;

    private JvmPrimitiveTypeKind(@NotNull String name, @NotNull String boxedFqn, @NotNull String binaryName) {
        if (name == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(0);
        }
        if (boxedFqn == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(1);
        }
        if (binaryName == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myBoxedFqn = boxedFqn;
        this.myBinaryName = binaryName;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public String getBoxedFqn() {
        String string = this.myBoxedFqn;
        if (string == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public String getBinaryName() {
        String string = this.myBinaryName;
        if (string == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JvmPrimitiveTypeKind getKindByName(@Nullable String name) {
        return ourNameToKind.get(name);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JvmPrimitiveTypeKind getKindByFqn(@Nullable String fqn) {
        return ourFqnToKind.get(fqn);
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<String> getBoxedFqns() {
        Collection<String> collection = Collections.unmodifiableCollection(ourFqnToKind.keySet());
        if (collection == null) {
            JvmPrimitiveTypeKind.$$$reportNull$$$0(6);
        }
        return collection;
    }

    static {
        JvmPrimitiveTypeKind[] values = new JvmPrimitiveTypeKind[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID};
        HashMap<String, JvmPrimitiveTypeKind> nameToKind = new HashMap<String, JvmPrimitiveTypeKind>(values.length);
        HashMap<String, JvmPrimitiveTypeKind> fqnToKind = new HashMap<String, JvmPrimitiveTypeKind>(values.length);
        for (JvmPrimitiveTypeKind kind : values) {
            nameToKind.put(kind.getName(), kind);
            fqnToKind.put(kind.getBoxedFqn(), kind);
        }
        ourNameToKind = nameToKind;
        ourFqnToKind = fqnToKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/lang/jvm/types/JvmPrimitiveTypeKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/lang/jvm/types/JvmPrimitiveTypeKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFqn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoxedFqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

