/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.model;

import java.util.function.Consumer;
import sqldelight.com.intellij.injected.editor.VirtualFileWindow;
import sqldelight.com.intellij.model.BranchService;
import sqldelight.com.intellij.model.BranchableSyntheticPsiElement;
import sqldelight.com.intellij.model.BranchedVirtualFile;
import sqldelight.com.intellij.model.ModelPatch;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.UserDataHolder;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiDirectory;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiReference;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ModelBranch
extends UserDataHolder {
    @NotNull
    public Project getProject();

    @NotNull
    public static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<? super ModelBranch> action) {
        if (project == null) {
            ModelBranch.$$$reportNull$$$0(0);
        }
        if (action == null) {
            ModelBranch.$$$reportNull$$$0(1);
        }
        ModelPatch modelPatch = BranchService.getInstance().performInBranch(project, action);
        if (modelPatch == null) {
            ModelBranch.$$$reportNull$$$0(2);
        }
        return modelPatch;
    }

    @NotNull
    public VirtualFile findFileCopy(@NotNull VirtualFile var1);

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T var1);

    @NotNull
    public <T extends PsiReference> T obtainReferenceCopy(@NotNull T var1);

    @Nullable
    public VirtualFile findFileByUrl(@NotNull String var1);

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T var1);

    @Nullable
    public VirtualFile findOriginalFile(@NotNull VirtualFile var1);

    @Nullable
    public static ModelBranch getPsiBranch(@NotNull PsiElement element) {
        if (element == null) {
            ModelBranch.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiDirectory) {
            return ModelBranch.getFileBranch(((PsiDirectory)element).getVirtualFile());
        }
        if (element instanceof BranchableSyntheticPsiElement) {
            return ((BranchableSyntheticPsiElement)element).getModelBranch();
        }
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        return psiFile == null ? null : ModelBranch.getFileBranch(psiFile.getViewProvider().getVirtualFile());
    }

    @Nullable
    public static ModelBranch getFileBranch(@NotNull VirtualFile file) {
        if (file == null) {
            ModelBranch.$$$reportNull$$$0(4);
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        return file instanceof BranchedVirtualFile ? ((BranchedVirtualFile)file).getBranch() : null;
    }

    public long getBranchedPsiModificationCount();

    public long getBranchedVfsStructureModificationCount();

    public void runAfterMerge(@NotNull Runnable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/model/ModelBranch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/model/ModelBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "performInBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInBranch";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileBranch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

