/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.actionSystem;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.actionSystem.ActionManager;
import sqldelight.com.intellij.openapi.actionSystem.AnActionEvent;
import sqldelight.com.intellij.openapi.actionSystem.CommonDataKeys;
import sqldelight.com.intellij.openapi.actionSystem.CustomShortcutSet;
import sqldelight.com.intellij.openapi.actionSystem.Presentation;
import sqldelight.com.intellij.openapi.actionSystem.ShortcutSet;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.project.PossiblyDumbAware;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.NlsActions;
import sqldelight.com.intellij.ui.ComponentUtil;
import sqldelight.com.intellij.util.SmartFMap;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.org.intellij.lang.annotations.JdkConstants;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.Nls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class AnAction
implements PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(AnAction.class);
    public static final Key<List<AnAction>> ACTIONS_KEY = Key.create("AnAction.shortcutSet");
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    private Presentation myTemplatePresentation;
    @NotNull
    private ShortcutSet myShortcutSet;
    private boolean myEnabledInModalContext;
    private boolean myIsDefaultIcon;
    private boolean myWorksInInjected;
    private SmartFMap<String, Supplier<String>> myActionTextOverrides;
    private List<Supplier<@Nls String>> mySynonyms;

    public AnAction() {
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
    }

    public AnAction(Icon icon2) {
        this(Presentation.NULL_STRING, Presentation.NULL_STRING, icon2);
    }

    public AnAction(@Nullable @NlsActions.ActionText String text) {
        this(text, null, null);
    }

    public AnAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(0);
        }
        this(dynamicText, Presentation.NULL_STRING, null);
    }

    public AnAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon2) {
        this(() -> text, () -> description, icon2);
    }

    public AnAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @Nullable Icon icon2) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(1);
        }
        this(dynamicText, Presentation.NULL_STRING, icon2);
    }

    public AnAction(@NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, @Nullable Icon icon2) {
        if (dynamicText == null) {
            AnAction.$$$reportNull$$$0(2);
        }
        if (dynamicDescription == null) {
            AnAction.$$$reportNull$$$0(3);
        }
        this.myShortcutSet = CustomShortcutSet.EMPTY;
        this.myIsDefaultIcon = true;
        this.myActionTextOverrides = SmartFMap.emptyMap();
        this.mySynonyms = Collections.emptyList();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(dynamicText);
        presentation.setDescription(dynamicDescription);
        presentation.setIcon(icon2);
    }

    @NotNull
    public final ShortcutSet getShortcutSet() {
        ShortcutSet shortcutSet = this.myShortcutSet;
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(4);
        }
        return shortcutSet;
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(5);
        }
        this.registerCustomShortcutSet(shortcutSet, component, null);
    }

    public final void registerCustomShortcutSet(int keyCode, @JdkConstants.InputEventMask int modifiers, @Nullable JComponent component) {
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, modifiers)), component);
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(6);
        }
        this.setShortcutSet(shortcutSet);
        this.registerCustomShortcutSet(component, parentDisposable);
    }

    public final void registerCustomShortcutSet(@Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (component == null) {
            return;
        }
        List<AnAction> actionList = ComponentUtil.getClientProperty(component, ACTIONS_KEY);
        if (actionList == null) {
            actionList = new SmartList<AnAction>();
            SmartList<AnAction> value = actionList;
            ComponentUtil.putClientProperty(component, ACTIONS_KEY, value);
        }
        if (!actionList.contains(this)) {
            actionList.add(this);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.unregisterCustomShortcutSet(component));
        }
    }

    public final void unregisterCustomShortcutSet(@NotNull JComponent component) {
        List<AnAction> actionList;
        if (component == null) {
            AnAction.$$$reportNull$$$0(7);
        }
        if ((actionList = ComponentUtil.getClientProperty(component, ACTIONS_KEY)) != null) {
            actionList.remove(this);
        }
    }

    public final void copyFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(8);
        }
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        presentation.copyFrom(sourcePresentation);
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(9);
        }
        this.setShortcutSet(sourceAction.getShortcutSet());
    }

    public final boolean isEnabledInModalContext() {
        return this.myEnabledInModalContext;
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myEnabledInModalContext = enabledInModalContext;
    }

    public boolean displayTextInToolbar() {
        return false;
    }

    public boolean useSmallerFontForTextInToolbar() {
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(10);
        }
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(11);
        }
        this.update(e);
    }

    @NotNull
    public final Presentation getTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation;
        if (presentation == null) {
            presentation = this.createTemplatePresentation();
            LOG.assertTrue(presentation.isTemplate(), "Not a template presentation");
            this.myTemplatePresentation = presentation;
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            AnAction.$$$reportNull$$$0(12);
        }
        return presentation2;
    }

    @NotNull
    Presentation createTemplatePresentation() {
        Presentation presentation = Presentation.newTemplatePresentation();
        if (presentation == null) {
            AnAction.$$$reportNull$$$0(13);
        }
        return presentation;
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1);

    protected void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
        ActionManager actionManager;
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(14);
        }
        if (this.myShortcutSet != shortcutSet && this.myShortcutSet != CustomShortcutSet.EMPTY && LoadingState.PROJECT_OPENED.isOccurred() && (actionManager = ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) != null && actionManager.getId(this) != null) {
            LOG.warn("ShortcutSet of global AnActions should not be changed outside of KeymapManager.\nThis is likely not what you wanted to do. Consider setting shortcut in keymap defaults, inheriting from other action using `use-shortcut-of` or wrapping with EmptyAction.wrap().", new Throwable(this.toString()));
        }
        this.myShortcutSet = shortcutSet;
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    @Deprecated(forRemoval=true)
    public boolean isTransparentUpdate() {
        return this instanceof TransparentUpdate;
    }

    @Deprecated
    public boolean startInTransaction() {
        return false;
    }

    public void addTextOverride(@NotNull String place, @NotNull String text) {
        if (place == null) {
            AnAction.$$$reportNull$$$0(15);
        }
        if (text == null) {
            AnAction.$$$reportNull$$$0(16);
        }
        this.addTextOverride(place, () -> text);
    }

    public void addTextOverride(@NotNull String place, @NotNull Supplier<String> text) {
        if (place == null) {
            AnAction.$$$reportNull$$$0(17);
        }
        if (text == null) {
            AnAction.$$$reportNull$$$0(18);
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus(place, text);
    }

    @ApiStatus.Internal
    public void copyActionTextOverride(@NotNull String fromPlace, @NotNull String toPlace, String id) {
        Supplier<String> value;
        if (fromPlace == null) {
            AnAction.$$$reportNull$$$0(19);
        }
        if (toPlace == null) {
            AnAction.$$$reportNull$$$0(20);
        }
        if ((value = this.myActionTextOverrides.get(fromPlace)) == null) {
            LOG.error("Missing override-text for action " + id + " and place specified in use-text-of-place: " + fromPlace);
            return;
        }
        this.myActionTextOverrides = this.myActionTextOverrides.plus(toPlace, value);
    }

    @ApiStatus.Internal
    public void applyTextOverride(@NotNull AnActionEvent event) {
        if (event == null) {
            AnAction.$$$reportNull$$$0(21);
        }
        this.applyTextOverride(event.getPlace(), event.getPresentation());
    }

    @ApiStatus.Internal
    public void applyTextOverride(@NotNull String place, @NotNull Presentation presentation) {
        Supplier<String> override;
        if (place == null) {
            AnAction.$$$reportNull$$$0(22);
        }
        if (presentation == null) {
            AnAction.$$$reportNull$$$0(23);
        }
        if ((override = this.myActionTextOverrides.get(place)) != null) {
            presentation.setText(override);
        }
    }

    @ApiStatus.Internal
    protected void copyActionTextOverrides(AnAction targetAction) {
        for (String place : this.myActionTextOverrides.keySet()) {
            targetAction.addTextOverride(place, Objects.requireNonNull(this.myActionTextOverrides.get(place)));
        }
    }

    public void addSynonym(@NotNull Supplier<@Nls String> text) {
        if (text == null) {
            AnAction.$$$reportNull$$$0(24);
        }
        if (this.mySynonyms == Collections.emptyList()) {
            this.mySynonyms = new SmartList<Supplier<String>>(text);
        } else {
            this.mySynonyms.add(text);
        }
    }

    public @NotNull List<Supplier<@Nls String>> getSynonyms() {
        List<Supplier<String>> list = this.mySynonyms;
        if (list == null) {
            AnAction.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    public static Project getEventProject(AnActionEvent e) {
        return e == null ? null : e.getData(CommonDataKeys.PROJECT);
    }

    @Nls
    public String toString() {
        return this.getTemplatePresentation().toString();
    }

    @Nullable
    @NlsActions.ActionText
    public String getTemplateText() {
        return this.getTemplatePresentation().getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 5: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPlace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPlace";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplatePresentation";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynonyms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 25: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomShortcutSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomShortcutSet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyShortcutFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setShortcutSet";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addTextOverride";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyActionTextOverride";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyTextOverride";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addSynonym";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated(forRemoval=true)
    public static interface TransparentUpdate {
    }
}

