/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.actionSystem;

import java.awt.event.InputEvent;
import sqldelight.com.intellij.ide.DataManager;
import sqldelight.com.intellij.openapi.actionSystem.ActionManager;
import sqldelight.com.intellij.openapi.actionSystem.AnAction;
import sqldelight.com.intellij.openapi.actionSystem.AnActionEventVisitor;
import sqldelight.com.intellij.openapi.actionSystem.CommonDataKeys;
import sqldelight.com.intellij.openapi.actionSystem.DataContext;
import sqldelight.com.intellij.openapi.actionSystem.DataContextWrapper;
import sqldelight.com.intellij.openapi.actionSystem.DataKey;
import sqldelight.com.intellij.openapi.actionSystem.InjectedDataKeys;
import sqldelight.com.intellij.openapi.actionSystem.Presentation;
import sqldelight.com.intellij.openapi.actionSystem.UpdateSession;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.ui.PlaceProvider;
import sqldelight.org.intellij.lang.annotations.JdkConstants;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class AnActionEvent
implements PlaceProvider {
    private final InputEvent myInputEvent;
    private final ActionManager myActionManager;
    private final DataContext myDataContext;
    private final String myPlace;
    private final Presentation myPresentation;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    private final boolean myIsContextMenuAction;
    private final boolean myIsActionToolbar;
    private boolean myWorksInInjected;
    private UpdateSession myUpdateSession;

    public AnActionEvent(@Nullable InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(0);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(2);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(3);
        }
        this(inputEvent, dataContext, place, presentation, actionManager, modifiers, false, false);
    }

    public AnActionEvent(@Nullable InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers, boolean isContextMenuAction, boolean isActionToolbar) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(4);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(5);
        }
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(6);
        }
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(7);
        }
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
        this.myIsContextMenuAction = isContextMenuAction;
        this.myIsActionToolbar = isActionToolbar;
    }

    @NotNull
    public AnActionEvent withDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(8);
        }
        if (this.myDataContext == dataContext) {
            AnActionEvent anActionEvent = this;
            if (anActionEvent == null) {
                AnActionEvent.$$$reportNull$$$0(9);
            }
            return anActionEvent;
        }
        AnActionEvent event = new AnActionEvent(this.myInputEvent, dataContext, this.myPlace, this.myPresentation, this.myActionManager, this.myModifiers, this.myIsContextMenuAction, this.myIsActionToolbar);
        event.setInjectedContext(this.myWorksInInjected);
        event.setUpdateSession(this.myUpdateSession);
        AnActionEvent anActionEvent = event;
        if (anActionEvent == null) {
            AnActionEvent.$$$reportNull$$$0(10);
        }
        return anActionEvent;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static AnActionEvent createFromInputEvent(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(11);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(12);
        }
        DataContext context2 = event == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(event.getComponent());
        return AnActionEvent.createFromAnAction(action, event, place, context2);
    }

    @NotNull
    public static AnActionEvent createFromAnAction(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place, @NotNull DataContext dataContext) {
        if (action == null) {
            AnActionEvent.$$$reportNull$$$0(13);
        }
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(14);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(15);
        }
        int modifiers = event == null ? 0 : event.getModifiers();
        Presentation presentation = action.getTemplatePresentation().clone();
        AnActionEvent anActionEvent = new AnActionEvent(event, dataContext, place, presentation, ActionManager.getInstance(), modifiers);
        anActionEvent.setInjectedContext(action.isInInjectedContext());
        AnActionEvent anActionEvent2 = anActionEvent;
        if (anActionEvent2 == null) {
            AnActionEvent.$$$reportNull$$$0(16);
        }
        return anActionEvent2;
    }

    @NotNull
    public static AnActionEvent createFromDataContext(@NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(17);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(18);
        }
        return new AnActionEvent(null, dataContext, place, presentation == null ? new Presentation() : presentation, ActionManager.getInstance(), 0);
    }

    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(19);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(20);
        }
        return AnActionEvent.createFromInputEvent(event, place, presentation, dataContext, false, false);
    }

    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext, boolean isContextMenuAction, boolean isToolbarAction) {
        if (place == null) {
            AnActionEvent.$$$reportNull$$$0(21);
        }
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(22);
        }
        return new AnActionEvent(event, dataContext, place, presentation == null ? new Presentation() : presentation, ActionManager.getInstance(), event == null ? 0 : event.getModifiers(), isContextMenuAction, isToolbarAction);
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    @Nullable
    public Project getProject() {
        return this.getData(CommonDataKeys.PROJECT);
    }

    @NotNull
    public static DataContext getInjectedDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(23);
        }
        if (dataContext instanceof InjectedDataContextSupplier) {
            DataContext dataContext2 = ((InjectedDataContextSupplier)((Object)dataContext)).getInjectedDataContext();
            if (dataContext2 == null) {
                AnActionEvent.$$$reportNull$$$0(24);
            }
            return dataContext2;
        }
        return dataContext instanceof InjectedDataContext ? dataContext : new InjectedDataContext(dataContext);
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.myWorksInInjected ? AnActionEvent.getInjectedDataContext(this.myDataContext) : this.myDataContext;
        if (dataContext == null) {
            AnActionEvent.$$$reportNull$$$0(25);
        }
        return dataContext;
    }

    @Nullable
    public <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            AnActionEvent.$$$reportNull$$$0(26);
        }
        return this.getDataContext().getData(key);
    }

    @NotNull
    public <T> T getRequiredData(@NotNull DataKey<T> key) {
        if (key == null) {
            AnActionEvent.$$$reportNull$$$0(27);
        }
        T data = this.getData(key);
        assert (data != null);
        T t = data;
        if (t == null) {
            AnActionEvent.$$$reportNull$$$0(28);
        }
        return t;
    }

    @Override
    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            AnActionEvent.$$$reportNull$$$0(29);
        }
        return string;
    }

    public boolean isFromActionToolbar() {
        return this.myIsActionToolbar;
    }

    @Deprecated(forRemoval=true)
    public boolean isFromContextMenu() {
        return this.myIsContextMenuAction;
    }

    @NotNull
    public Presentation getPresentation() {
        Presentation presentation = this.myPresentation;
        if (presentation == null) {
            AnActionEvent.$$$reportNull$$$0(30);
        }
        return presentation;
    }

    @JdkConstants.InputEventMask
    public int getModifiers() {
        return this.myModifiers;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            AnActionEvent.$$$reportNull$$$0(31);
        }
        return actionManager;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public void accept(@NotNull AnActionEventVisitor visitor) {
        if (visitor == null) {
            AnActionEvent.$$$reportNull$$$0(32);
        }
        visitor.visitEvent(this);
    }

    @Nullable
    public UpdateSession getUpdateSession() {
        return this.myUpdateSession;
    }

    public void setUpdateSession(@Nullable UpdateSession updateSession) {
        this.myUpdateSession = updateSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/actionSystem/AnActionEvent";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/actionSystem/AnActionEvent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withDataContext";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromAnAction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedDataContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredData";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withDataContext";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFromInputEvent";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFromAnAction";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createFromDataContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedDataContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InjectedDataContext
    extends DataContextWrapper {
        InjectedDataContext(@NotNull DataContext context2) {
            if (context2 == null) {
                InjectedDataContext.$$$reportNull$$$0(0);
            }
            super(context2);
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            String injectedId;
            if (dataId == null) {
                InjectedDataContext.$$$reportNull$$$0(1);
            }
            Object injected = (injectedId = InjectedDataKeys.injectedId(dataId)) != null ? super.getData(injectedId) : null;
            return injected != null ? injected : super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/openapi/actionSystem/AnActionEvent$InjectedDataContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static interface InjectedDataContextSupplier {
        @NotNull
        public DataContext getInjectedDataContext();
    }
}

