/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.actionSystem;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import sqldelight.com.intellij.DynamicBundle;
import sqldelight.com.intellij.ide.ui.UISettings;
import sqldelight.com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.Comparing;
import sqldelight.com.intellij.openapi.util.Key;
import sqldelight.com.intellij.openapi.util.NlsActions;
import sqldelight.com.intellij.openapi.util.NotNullLazyValue;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.openapi.util.text.TextWithMnemonic;
import sqldelight.com.intellij.util.BitUtil;
import sqldelight.com.intellij.util.SmartFMap;
import sqldelight.org.jetbrains.annotations.Nls;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(Presentation.class);
    public static final Supplier<String> NULL_STRING = () -> null;
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_TEXT_WITH_SUFFIX = "textWithSuffix";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final @NonNls Key<@Nls String> PROP_VALUE = Key.create("value");
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private static final int IS_ENABLED = 1;
    private static final int IS_VISIBLE = 2;
    private static final int IS_MULTI_CHOICE = 4;
    private static final int IS_POPUP_GROUP = 16;
    private static final int IS_PERFORM_GROUP = 32;
    private static final int IS_TEMPLATE = 4096;
    private int myFlags;
    private @NotNull Supplier<@NlsActions.ActionDescription String> myDescriptionSupplier;
    @NotNull
    private Supplier<TextWithMnemonic> myTextWithMnemonicSupplier;
    @NotNull
    private SmartFMap<String, Object> myUserMap;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    private PropertyChangeSupport myChangeSupport;
    private double myWeight;
    @NotNull
    private static final NotNullLazyValue<Boolean> removeMnemonics = NotNullLazyValue.createValue(() -> SystemInfoRt.isMac && DynamicBundle.LanguageBundleEP.EP_NAME.hasAnyExtensions());

    public static Presentation newTemplatePresentation() {
        Presentation presentation = new Presentation();
        presentation.myFlags = BitUtil.set(presentation.myFlags, 4096, true);
        return presentation;
    }

    public Presentation() {
        this.myFlags = 3;
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myUserMap = SmartFMap.emptyMap();
        this.myWeight = 0.0;
    }

    public Presentation(@NotNull @NlsActions.ActionText String text) {
        if (text == null) {
            Presentation.$$$reportNull$$$0(0);
        }
        this.myFlags = 3;
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myUserMap = SmartFMap.emptyMap();
        this.myWeight = 0.0;
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText(text);
    }

    public Presentation(@NotNull Supplier<@NlsActions.ActionText String> dynamicText) {
        if (dynamicText == null) {
            Presentation.$$$reportNull$$$0(1);
        }
        this.myFlags = 3;
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myUserMap = SmartFMap.emptyMap();
        this.myWeight = 0.0;
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText((String)dynamicText.get());
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support;
        if (l == null) {
            Presentation.$$$reportNull$$$0(2);
        }
        if ((support = this.myChangeSupport) == null) {
            this.myChangeSupport = support = new PropertyChangeSupport(this);
        }
        support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support;
        if (l == null) {
            Presentation.$$$reportNull$$$0(3);
        }
        if ((support = this.myChangeSupport) != null) {
            support.removePropertyChangeListener(l);
        }
    }

    @NlsActions.ActionText
    public String getText() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText();
    }

    @NlsActions.ActionText
    public String getText(boolean withSuffix) {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText(withSuffix);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text, boolean mayContainMnemonic) {
        if (text == null) {
            Presentation.$$$reportNull$$$0(4);
        }
        this.setTextWithMnemonic(this.getTextWithMnemonic(text, mayContainMnemonic));
    }

    public void setText(@Nullable @NlsActions.ActionText String text, boolean mayContainMnemonic) {
        this.setTextWithMnemonic(this.getTextWithMnemonic(() -> text, mayContainMnemonic));
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithMnemonic(@NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Title) String> text, boolean mayContainMnemonic) {
        if (text == null) {
            Presentation.$$$reportNull$$$0(5);
        }
        if (mayContainMnemonic) {
            Supplier<TextWithMnemonic> supplier = () -> {
                String s = (String)text.get();
                if (s == null) {
                    return null;
                }
                TextWithMnemonic parsed = TextWithMnemonic.parse(s);
                UISettings uiSettings = UISettings.getInstanceOrNull();
                boolean mnemonicsDisabled = uiSettings != null && uiSettings.getDisableMnemonicsInControls();
                return mnemonicsDisabled ? parsed.dropMnemonic(removeMnemonics.getValue()) : parsed;
            };
            if (supplier == null) {
                Presentation.$$$reportNull$$$0(6);
            }
            return supplier;
        }
        Supplier<TextWithMnemonic> supplier = () -> {
            String s = (String)text.get();
            return s == null ? null : TextWithMnemonic.fromPlainText(s);
        };
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(7);
        }
        return supplier;
    }

    public void setTextWithMnemonic(@NotNull Supplier<TextWithMnemonic> textWithMnemonicSupplier) {
        if (textWithMnemonicSupplier == null) {
            Presentation.$$$reportNull$$$0(8);
        }
        String oldText = this.getText();
        String oldTextWithSuffix = this.getText(true);
        int oldMnemonic = this.getMnemonic();
        int oldIndex = this.getDisplayedMnemonicIndex();
        this.myTextWithMnemonicSupplier = textWithMnemonicSupplier;
        this.fireObjectPropertyChange(PROP_TEXT, oldText, this.getText());
        this.fireObjectPropertyChange(PROP_TEXT_WITH_SUFFIX, oldTextWithSuffix, this.getText(true));
        this.fireObjectPropertyChange(PROP_MNEMONIC_KEY, oldMnemonic, this.getMnemonic());
        this.fireObjectPropertyChange(PROP_MNEMONIC_INDEX, oldIndex, this.getDisplayedMnemonicIndex());
    }

    public void setText(@Nullable @NlsActions.ActionText String text) {
        this.setText(() -> text, true);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text) {
        if (text == null) {
            Presentation.$$$reportNull$$$0(9);
        }
        this.setText(text, true);
    }

    @NlsActions.ActionText
    @Nullable
    public String getTextWithMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.toString();
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithPossibleMnemonic() {
        Supplier<TextWithMnemonic> supplier = this.myTextWithMnemonicSupplier;
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(10);
        }
        return supplier;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
    }

    @NlsActions.ActionDescription
    public String getDescription() {
        return this.myDescriptionSupplier.get();
    }

    public void setDescription(@NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription) {
        if (dynamicDescription == null) {
            Presentation.$$$reportNull$$$0(11);
        }
        Supplier<String> oldDescription = this.myDescriptionSupplier;
        this.myDescriptionSupplier = dynamicDescription;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescription.get(), this.myDescriptionSupplier.get());
    }

    public void setDescription(@NlsActions.ActionDescription String description) {
        Supplier<String> oldDescriptionSupplier = this.myDescriptionSupplier;
        this.myDescriptionSupplier = () -> description;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescriptionSupplier.get(), description);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon2) {
        Icon oldIcon = this.myIcon;
        this.myIcon = icon2;
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon2) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon2;
        this.fireObjectPropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.fireObjectPropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.fireObjectPropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? 0 : textWithMnemonic.getMnemonicCode();
    }

    public int getDisplayedMnemonicIndex() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? -1 : textWithMnemonic.getMnemonicIndex();
    }

    public boolean isVisible() {
        return BitUtil.isSet(this.myFlags, 2);
    }

    public void setVisible(boolean visible) {
        this.assertNotTemplatePresentation();
        boolean oldVisible = BitUtil.isSet(this.myFlags, 2);
        this.myFlags = BitUtil.set(this.myFlags, 2, visible);
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, visible);
    }

    public boolean isPopupGroup() {
        return BitUtil.isSet(this.myFlags, 16);
    }

    public void setPopupGroup(boolean popup) {
        this.myFlags = BitUtil.set(this.myFlags, 16, popup);
    }

    public boolean isPerformGroup() {
        return BitUtil.isSet(this.myFlags, 32);
    }

    public void setPerformGroup(boolean performing) {
        this.myFlags = BitUtil.set(this.myFlags, 32, performing);
    }

    boolean isTemplate() {
        return BitUtil.isSet(this.myFlags, 4096);
    }

    public boolean isEnabled() {
        return BitUtil.isSet(this.myFlags, 1);
    }

    public void setEnabled(boolean enabled) {
        this.assertNotTemplatePresentation();
        boolean oldEnabled = BitUtil.isSet(this.myFlags, 1);
        this.myFlags = BitUtil.set(this.myFlags, 1, enabled);
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, enabled);
    }

    public void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void fireBooleanPropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (oldValue != newValue && support != null) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void fireObjectPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null && !Objects.equals(oldValue, newValue)) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void assertNotTemplatePresentation() {
        if (BitUtil.isSet(this.myFlags, 4096)) {
            LOG.warn(new Throwable("Shall not be called on a template presentation"));
        }
    }

    public Presentation clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            clone.myFlags = BitUtil.set(clone.myFlags, 4096, false);
            clone.myChangeSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(@NotNull Presentation presentation) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(12);
        }
        this.copyFrom(presentation, null, false, false);
    }

    public void copyFrom(@NotNull Presentation presentation, @Nullable Component customComponent) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(13);
        }
        this.copyFrom(presentation, customComponent, true, false);
    }

    public void copyFrom(@NotNull Presentation presentation, @Nullable Component customComponent, boolean allFlags) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(14);
        }
        this.copyFrom(presentation, customComponent, true, allFlags);
    }

    private void copyFrom(@NotNull Presentation presentation, @Nullable Component customComponent, boolean forceNullComponent, boolean allFlags) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(15);
        }
        if (presentation == this) {
            return;
        }
        boolean oldEnabled = this.isEnabled();
        boolean oldVisible = this.isVisible();
        if (allFlags) {
            this.myFlags = BitUtil.set(presentation.myFlags, 4096, this.isTemplate());
        } else {
            this.myFlags = BitUtil.set(this.myFlags, 1, BitUtil.isSet(presentation.myFlags, 1));
            this.myFlags = BitUtil.set(this.myFlags, 2, BitUtil.isSet(presentation.myFlags, 2));
        }
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, this.isEnabled());
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, this.isVisible());
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
        this.setDescription(presentation.myDescriptionSupplier);
        this.setIcon(presentation.getIcon());
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        this.setWeight(presentation.getWeight());
        if (!this.myUserMap.equals(presentation.myUserMap)) {
            HashSet<String> allKeys = new HashSet<String>(presentation.myUserMap.keySet());
            allKeys.addAll(this.myUserMap.keySet());
            if (!allKeys.isEmpty()) {
                for (String key : allKeys) {
                    if (key.equals(CustomComponentAction.COMPONENT_KEY.toString()) && (customComponent != null || forceNullComponent)) {
                        this.putClientProperty(key, customComponent);
                        continue;
                    }
                    this.putClientProperty(key, presentation.getClientProperty(key));
                }
            }
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Key<T> key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(16);
        }
        return (T)this.myUserMap.get(key.toString());
    }

    public <T> void putClientProperty(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(17);
        }
        this.putClientProperty(key.toString(), value);
    }

    @Deprecated
    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(18);
        }
        return this.myUserMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value) {
        Object oldValue;
        if (key == null) {
            Presentation.$$$reportNull$$$0(19);
        }
        Presentation presentation = this;
        synchronized (presentation) {
            oldValue = this.myUserMap.get(key);
            if (Comparing.equal(oldValue, value)) {
                return;
            }
            if (key.equals(CustomComponentAction.COMPONENT_KEY.toString()) && oldValue != null) {
                LOG.error("Trying to reset custom component in a presentation", new Throwable());
            }
            this.myUserMap = value == null ? this.myUserMap.minus(key) : this.myUserMap.plus(key, value);
        }
        this.fireObjectPropertyChange(key, oldValue, value);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }

    @Nls
    public String toString() {
        return this.getText() + " (" + this.myDescriptionSupplier.get() + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    public void setMultipleChoice(boolean b) {
        this.myFlags = BitUtil.set(this.myFlags, 4, b);
    }

    public boolean isMultipleChoice() {
        return BitUtil.isSet(this.myFlags, 4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_TEXT;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithMnemonicSupplier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithMnemonic";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithPossibleMnemonic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithMnemonic";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTextWithMnemonic";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

