/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.application.ex;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.EdtReplacementThread;
import sqldelight.com.intellij.openapi.application.ModalityState;
import sqldelight.com.intellij.openapi.application.ex.ApplicationEx;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.progress.ProcessCanceledException;
import sqldelight.com.intellij.openapi.progress.ProgressIndicator;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.openapi.util.Computable;
import sqldelight.com.intellij.openapi.util.Ref;
import sqldelight.com.intellij.util.ExceptionUtil;
import sqldelight.com.intellij.util.concurrency.Semaphore;
import sqldelight.com.intellij.util.ui.EdtInvocationManager;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class ApplicationUtil {
    public static <T> T tryRunReadAction(@NotNull Computable<T> computable) throws CannotRunReadActionException {
        if (computable == null) {
            ApplicationUtil.$$$reportNull$$$0(0);
        }
        Ref result = new Ref();
        if (!((ApplicationEx)ApplicationManager.getApplication()).tryRunReadAction(() -> result.set(computable.compute()))) {
            throw CannotRunReadActionException.create();
        }
        return result.get();
    }

    public static <T> T runWithCheckCanceled(@NotNull Callable<? extends T> callable, @NotNull ProgressIndicator indicator) throws Exception {
        if (callable == null) {
            ApplicationUtil.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ApplicationUtil.$$$reportNull$$$0(2);
        }
        Ref result = Ref.create();
        Ref error = Ref.create();
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                result.set(callable.call());
            }
            catch (Throwable t) {
                error.set(t);
            }
        }, indicator));
        try {
            ApplicationUtil.runWithCheckCanceled(future, indicator);
            ExceptionUtil.rethrowAll((Throwable)error.get());
        }
        catch (ProcessCanceledException e) {
            future.cancel(false);
            throw e;
        }
        return result.get();
    }

    public static <T> T runWithCheckCanceled(@NotNull Future<T> future, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (future == null) {
            ApplicationUtil.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ApplicationUtil.$$$reportNull$$$0(4);
        }
        while (true) {
            indicator.checkCanceled();
            try {
                return future.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public static void showDialogAfterWriteAction(@NotNull Runnable runnable) {
        Application application;
        if (runnable == null) {
            ApplicationUtil.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            application.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public static void invokeLaterSomewhere(@NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState, @NotNull Runnable r) {
        if (thread == null) {
            ApplicationUtil.$$$reportNull$$$0(6);
        }
        if (modalityState == null) {
            ApplicationUtil.$$$reportNull$$$0(7);
        }
        if (r == null) {
            ApplicationUtil.$$$reportNull$$$0(8);
        }
        switch (thread) {
            case EDT: {
                SwingUtilities.invokeLater(r);
                break;
            }
            case WT: {
                ApplicationManager.getApplication().invokeLaterOnWriteThread(r, modalityState);
                break;
            }
            case EDT_WITH_IW: {
                ApplicationManager.getApplication().invokeLater(r, modalityState);
            }
        }
    }

    public static void invokeAndWaitSomewhere(@NotNull EdtReplacementThread thread, @NotNull ModalityState modalityState, @NotNull Runnable r) {
        if (thread == null) {
            ApplicationUtil.$$$reportNull$$$0(9);
        }
        if (modalityState == null) {
            ApplicationUtil.$$$reportNull$$$0(10);
        }
        if (r == null) {
            ApplicationUtil.$$$reportNull$$$0(11);
        }
        switch (thread) {
            case EDT: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                EdtInvocationManager.invokeAndWaitIfNeeded(r);
                break;
            }
            case WT: {
                if (ApplicationManager.getApplication().isWriteThread()) {
                    r.run();
                    break;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from EDT to WT");
                    break;
                }
                Semaphore s = new Semaphore(1);
                AtomicReference throwable = new AtomicReference();
                ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        throwable.set(t);
                    }
                    finally {
                        s.up();
                    }
                }, modalityState);
                s.waitFor();
                if (throwable.get() == null) break;
                ExceptionUtil.rethrow((Throwable)throwable.get());
                break;
            }
            case EDT_WITH_IW: {
                if (!SwingUtilities.isEventDispatchThread() && ApplicationManager.getApplication().isWriteThread()) {
                    Logger.getInstance(ApplicationUtil.class).error("Can't invokeAndWait from WT to EDT: probably leads to deadlock");
                }
                ApplicationManager.getApplication().invokeAndWait(r, modalityState);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/application/ex/ApplicationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryRunReadAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithCheckCanceled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAfterWriteAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeLaterSomewhere";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAndWaitSomewhere";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CannotRunReadActionException
    extends ProcessCanceledException {
        public static CannotRunReadActionException create() {
            return new CannotRunReadActionException();
        }

        private CannotRunReadActionException() {
        }
    }
}

