/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.editor;

import java.awt.Color;
import sqldelight.com.intellij.util.MathUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class CaretVisualAttributes {
    public static final CaretVisualAttributes DEFAULT = new CaretVisualAttributes(null, Weight.NORMAL, Shape.DEFAULT, 1.0f);
    @Nullable
    private final Color myColor;
    @NotNull
    private final Weight myWeight;
    @NotNull
    private final Shape myShape;
    private final float myThickness;

    public CaretVisualAttributes(@Nullable Color color, @NotNull Weight weight) {
        if (weight == null) {
            CaretVisualAttributes.$$$reportNull$$$0(0);
        }
        this(color, weight, Shape.DEFAULT, 1.0f);
    }

    public CaretVisualAttributes(@Nullable Color color, @NotNull Weight weight, @NotNull Shape shape, float thickness) {
        if (weight == null) {
            CaretVisualAttributes.$$$reportNull$$$0(1);
        }
        if (shape == null) {
            CaretVisualAttributes.$$$reportNull$$$0(2);
        }
        this.myColor = color;
        this.myWeight = weight;
        this.myShape = shape;
        this.myThickness = MathUtil.clamp(thickness, 0.0f, 1.0f);
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    @NotNull
    public Shape getShape() {
        Shape shape = this.myShape;
        if (shape == null) {
            CaretVisualAttributes.$$$reportNull$$$0(3);
        }
        return shape;
    }

    public float getThickness() {
        return this.myThickness;
    }

    @NotNull
    public Weight getWeight() {
        Weight weight = this.myWeight;
        if (weight == null) {
            CaretVisualAttributes.$$$reportNull$$$0(4);
        }
        return weight;
    }

    public int getWidth(int defaultWidth) {
        return Math.max(1, defaultWidth + this.myWeight.delta);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weight";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/editor/CaretVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/editor/CaretVisualAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShape";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Shape {
        DEFAULT,
        BLOCK,
        BAR,
        UNDERSCORE,
        BOX;

    }

    public static enum Weight {
        THIN(-1),
        NORMAL(0),
        HEAVY(1);

        private final int delta;

        private Weight(int delta) {
            this.delta = delta;
        }

        public int getDelta() {
            return this.delta;
        }
    }
}

