/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.editor.colors;

import java.awt.Color;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.editor.colors.EditorColorsListener;
import sqldelight.com.intellij.openapi.editor.colors.EditorColorsScheme;
import sqldelight.com.intellij.ui.ColorUtil;
import sqldelight.com.intellij.util.messages.Topic;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;

public abstract class EditorColorsManager {
    public static final Topic<EditorColorsListener> TOPIC = new Topic<EditorColorsListener>(EditorColorsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);
    @NonNls
    public static final String DEFAULT_SCHEME_NAME = "Default";
    @NonNls
    public static final String COLOR_SCHEME_FILE_EXTENSION = ".icls";

    public static EditorColorsManager getInstance() {
        return ApplicationManager.getApplication().getService(EditorColorsManager.class);
    }

    public abstract void addColorsScheme(@NotNull EditorColorsScheme var1);

    public abstract EditorColorsScheme @NotNull [] getAllSchemes();

    public abstract void setGlobalScheme(EditorColorsScheme var1);

    @NotNull
    public abstract EditorColorsScheme getGlobalScheme();

    public abstract EditorColorsScheme getScheme(@NotNull String var1);

    public abstract boolean isDefaultScheme(EditorColorsScheme var1);

    @Deprecated(forRemoval=true)
    public final void addEditorColorsListener(@NotNull EditorColorsListener listener) {
        if (listener == null) {
            EditorColorsManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(TOPIC, listener);
    }

    public abstract boolean isUseOnlyMonospacedFonts();

    public abstract void setUseOnlyMonospacedFonts(boolean var1);

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editorColorsScheme = this.getGlobalScheme();
        if (editorColorsScheme == null) {
            EditorColorsManager.$$$reportNull$$$0(1);
        }
        return editorColorsScheme;
    }

    public boolean isDarkEditor() {
        Color bg = this.getGlobalScheme().getDefaultBackground();
        return ColorUtil.isDark(bg);
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorsManager.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/editor/colors/EditorColorsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/editor/colors/EditorColorsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeForCurrentUITheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addEditorColorsListener";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemeParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

