/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.progress;

import java.util.concurrent.CancellationException;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import sqldelight.com.intellij.concurrency.ThreadContext;
import sqldelight.com.intellij.openapi.application.AccessToken;
import sqldelight.com.intellij.openapi.progress.JobCanceledException;
import sqldelight.com.intellij.openapi.util.ThrowableComputable;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return Cancellation.contextJob(ThreadContext.currentThreadContext());
    }

    @Nullable
    public static Job contextJob(@NotNull CoroutineContext context2) {
        if (context2 == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        return (Job)context2.get((CoroutineContext.Key)Job.Key);
    }

    public static boolean isCancelled() {
        Job job = Cancellation.currentJob();
        return job != null && job.isCancelled();
    }

    public static void checkCancelled() {
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive(currentJob);
            }
            catch (CancellationException e) {
                throw new JobCanceledException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Throwable> T withJob(@NotNull Job job, @NotNull ThrowableComputable<T, E> action) throws E, CancellationException {
        if (job == null) {
            Cancellation.$$$reportNull$$$0(1);
        }
        if (action == null) {
            Cancellation.$$$reportNull$$$0(2);
        }
        try (AccessToken ignored = ThreadContext.withThreadContext((CoroutineContext)job);){
            T t = action.compute();
            return t;
        }
        catch (JobCanceledException e) {
            if (job.isCancelled()) throw e.getCause();
            throw new IllegalStateException("JobCanceledException must be thrown by ProgressManager.checkCanceled()", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/progress/Cancellation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contextJob";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withJob";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

