/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.projectRoots;

import java.util.EventListener;
import java.util.List;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.WriteAction;
import sqldelight.com.intellij.openapi.projectRoots.Sdk;
import sqldelight.com.intellij.openapi.projectRoots.SdkTypeId;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.util.messages.Topic;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.annotations.TestOnly;

@ApiStatus.NonExtendable
public abstract class ProjectJdkTable {
    public static final Topic<Listener> JDK_TABLE_TOPIC = new Topic<Listener>(Listener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);

    public static ProjectJdkTable getInstance() {
        return ApplicationManager.getApplication().getService(ProjectJdkTable.class);
    }

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1);

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1, @NotNull String var2);

    public abstract Sdk @NotNull [] getAllJdks();

    @NotNull
    public abstract List<Sdk> getSdksOfType(@NotNull SdkTypeId var1);

    @Nullable
    public Sdk findMostRecentSdkOfType(@NotNull SdkTypeId type2) {
        if (type2 == null) {
            ProjectJdkTable.$$$reportNull$$$0(0);
        }
        return this.getSdksOfType(type2).stream().max(type2.versionComparator()).orElse(null);
    }

    public abstract void addJdk(@NotNull Sdk var1);

    @TestOnly
    public void addJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        Sdk existingJdk;
        if (jdk == null) {
            ProjectJdkTable.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            ProjectJdkTable.$$$reportNull$$$0(2);
        }
        if ((existingJdk = this.findJdk(jdk.getName(), jdk.getSdkType().getName())) != null && existingJdk.getSdkAdditionalData() == jdk.getSdkAdditionalData()) {
            return;
        }
        this.addJdk(jdk);
        Disposer.register(parentDisposable, () -> WriteAction.runAndWait(() -> this.removeJdk(jdk)));
    }

    public abstract void removeJdk(@NotNull Sdk var1);

    public abstract void updateJdk(@NotNull Sdk var1, @NotNull Sdk var2);

    @NotNull
    public abstract SdkTypeId getDefaultSdkType();

    @NotNull
    public abstract SdkTypeId getSdkTypeByName(@NotNull String var1);

    @NotNull
    public abstract Sdk createSdk(@NotNull String var1, @NotNull SdkTypeId var2);

    public void preconfigure() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/projectRoots/ProjectJdkTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMostRecentSdkOfType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addJdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener
    extends EventListener {
        default public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (previousName == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousName";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/openapi/projectRoots/ProjectJdkTable$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkRemoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkNameChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

