/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import sqldelight.com.intellij.openapi.roots.SyntheticLibrary;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class ImmutableSyntheticLibrary
extends SyntheticLibrary {
    private final List<VirtualFile> mySourceRoots;
    private final List<VirtualFile> myBinaryRoots;
    private final Set<VirtualFile> myExcludedRoots;
    private final Condition<? super VirtualFile> myExcludeCondition;
    private final int hashCode;

    ImmutableSyntheticLibrary(@NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(0);
        }
        if (binaryRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(1);
        }
        if (excludedRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(2);
        }
        this.mySourceRoots = ImmutableSyntheticLibrary.immutableOrEmptyList(sourceRoots);
        this.myBinaryRoots = ImmutableSyntheticLibrary.immutableOrEmptyList(binaryRoots);
        this.myExcludedRoots = ContainerUtil.unmodifiableOrEmptySet(excludedRoots);
        this.myExcludeCondition = excludeCondition;
        this.hashCode = 31 * (31 * sourceRoots.hashCode() + binaryRoots.hashCode()) + excludedRoots.hashCode();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots() {
        List<VirtualFile> list = this.mySourceRoots;
        if (list == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list = this.myBinaryRoots;
        if (list == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = this.myExcludedRoots;
        if (set == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return this.myExcludeCondition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSyntheticLibrary library = (ImmutableSyntheticLibrary)o;
        if (!this.mySourceRoots.equals(library.getSourceRoots())) {
            return false;
        }
        if (!this.myBinaryRoots.equals(library.getBinaryRoots())) {
            return false;
        }
        if (!this.myExcludedRoots.equals(library.getExcludedRoots())) {
            return false;
        }
        return Objects.equals(this.myExcludeCondition, library.getExcludeFileCondition());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    private static <E> List<E> immutableOrEmptyList(@NotNull List<? extends E> list) {
        if (list == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(6);
        }
        List<Object> list2 = list.isEmpty() ? Collections.emptyList() : ContainerUtil.immutableList(list);
        if (list2 == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableOrEmptyList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "immutableOrEmptyList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

