/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.application.ReadAction;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.roots.ContentIterator;
import sqldelight.com.intellij.openapi.roots.ModuleFileIndex;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderRootType;
import sqldelight.com.intellij.openapi.roots.RootPolicy;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryIndex;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.FileIndexBase;
import sqldelight.com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import sqldelight.com.intellij.openapi.roots.impl.RootIndex;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileFilter;
import sqldelight.com.intellij.util.IncorrectOperationException;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    @NotNull
    private final Module myModule;

    public ModuleFileIndexImpl(@NotNull Module module) {
        if (module == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(DirectoryIndex.getInstance(module.getProject()));
        this.myModule = module;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter) {
        if (processor == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(1);
        }
        Set<VirtualFile> contentRoots = this.getModuleRootsToIterate();
        for (VirtualFile contentRoot : contentRoots) {
            if (this.iterateContentUnderDirectory(contentRoot, processor, filter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Set<VirtualFile> getModuleRootsToIterate() {
        Set set = ReadAction.compute(() -> {
            if (this.myModule.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>();
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(this.myModule);
            Iterator iterator = Arrays.asList(moduleRootManager.getContentRoots(), moduleRootManager.getSourceRoots()).iterator();
            while (iterator.hasNext()) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = (VirtualFile[])iterator.next()) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject(root) || (parent = root.getParent()) != null && this.myModule.equals((parentInfo = this.myDirectoryIndex.getInfoForFile(parent)).getModule())) continue;
                    result.add(root);
                }
            }
            return result;
        });
        if (set == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(3);
        }
        return this.isInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(4);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule());
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(5);
        }
        return ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    @Override
    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(6);
        }
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(fileOrDir)));
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(7);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && this.isTestSourcesRoot(info);
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(8);
        }
        if (rootTypes == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(9);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && this.myModule.equals(info.getModule()) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    public static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> orderEntries) {
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(10);
        }
        if (orderEntries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(11);
        }
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> entries) {
        int lastIndex;
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(12);
        }
        if (entries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(13);
        }
        if (entries.isEmpty()) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            ArrayList<OrderEntry> arrayList = entry.getOwnerModule() == ownerModule ? new ArrayList<OrderEntry>(entries) : Collections.emptyList();
            if (arrayList == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        return new ArrayList<OrderEntry>(entries.subList(firstIndex, lastIndex));
    }

    @Override
    protected boolean isInContent(@NotNull VirtualFile file, @NotNull DirectoryInfo info) {
        if (file == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(17);
        }
        if (info == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(18);
        }
        return ProjectFileIndexImpl.isFileInContent(file, info) && this.myModule.equals(info.getModule());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootsToIterate";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrderEntryWithOwnerModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        FakeOrderEntry(@NotNull Module ownerModule) {
            if (ownerModule == null) {
                FakeOrderEntry.$$$reportNull$$$0(0);
            }
            this.myOwnerModule = ownerModule;
        }

        @Override
        public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type2) {
            if (type2 == null) {
                FakeOrderEntry.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                FakeOrderEntry.$$$reportNull$$$0(2);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        @Override
        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public Module getOwnerModule() {
            Module module = this.myOwnerModule;
            if (module == null) {
                FakeOrderEntry.$$$reportNull$$$0(3);
            }
            return module;
        }

        @Override
        public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
            if (policy == null) {
                FakeOrderEntry.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public int compareTo(@NotNull OrderEntry o) {
            if (o == null) {
                FakeOrderEntry.$$$reportNull$$$0(5);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

