/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.List;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfo;
import sqldelight.com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.util.Processor;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class NonProjectDirectoryInfo
extends DirectoryInfo {
    static final NonProjectDirectoryInfo IGNORED = new NonProjectDirectoryInfo("ignored"){

        @Override
        public boolean isIgnored() {
            return true;
        }
    };
    static final NonProjectDirectoryInfo EXCLUDED = new NonProjectDirectoryInfo("excluded from project"){

        @Override
        public boolean isExcluded() {
            return true;
        }
    };
    static final NonProjectDirectoryInfo NOT_UNDER_PROJECT_ROOTS = new NonProjectDirectoryInfo("not under project roots"){

        @Override
        boolean hasContentEntriesBeneath() {
            return false;
        }
    };
    static final NonProjectDirectoryInfo INVALID = new NonProjectDirectoryInfo("invalid");
    static final NonProjectDirectoryInfo OUTSIDE_PROJECT_ROOTS_BUT_HAS_CONTENT_BENEATH = new NonProjectDirectoryInfo("outside project root but has content beneath");
    private final String myDebugName;

    private NonProjectDirectoryInfo(@NotNull String debugName) {
        if (debugName == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(0);
        }
        this.myDebugName = debugName;
    }

    @Override
    public boolean isInProject(@NotNull VirtualFile file) {
        if (file == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(1);
        }
        return false;
    }

    public String toString() {
        return "DirectoryInfo: " + this.myDebugName;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    @Nullable
    public VirtualFile getSourceRoot() {
        return null;
    }

    @Override
    public VirtualFile getLibraryClassRoot() {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return null;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isExcluded() {
        return false;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        if (file == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(3);
        }
        return this.isExcluded();
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file) {
        if (file == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    public Module getModule() {
        return null;
    }

    @Override
    public String getUnloadedModuleName() {
        return null;
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder() {
        return null;
    }

    @Override
    public boolean processContentBeneathExcluded(@NotNull VirtualFile dir, @NotNull Processor<? super VirtualFile> processor) {
        if (dir == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            NonProjectDirectoryInfo.$$$reportNull$$$0(6);
        }
        return true;
    }

    boolean hasContentEntriesBeneath() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/NonProjectDirectoryInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInLibrarySource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcluded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInModuleSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processContentBeneathExcluded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class WithBeneathInfo
    extends NonProjectDirectoryInfo {
        @NotNull
        private final NonProjectDirectoryInfo myDelegate;
        final List<DirectoryInfoImpl> myContentInfosBeneath;

        WithBeneathInfo(@NotNull NonProjectDirectoryInfo delegate) {
            if (delegate == null) {
                WithBeneathInfo.$$$reportNull$$$0(0);
            }
            super(delegate.myDebugName);
            this.myContentInfosBeneath = new SmartList<DirectoryInfoImpl>();
            this.myDelegate = delegate;
        }

        @Override
        public boolean processContentBeneathExcluded(@NotNull VirtualFile dir, @NotNull Processor<? super VirtualFile> processor) {
            if (dir == null) {
                WithBeneathInfo.$$$reportNull$$$0(1);
            }
            if (processor == null) {
                WithBeneathInfo.$$$reportNull$$$0(2);
            }
            return this.isExcluded(dir) && ContainerUtil.process(this.myContentInfosBeneath, child -> !VfsUtilCore.isAncestor(dir, child.myRoot, false) || processor.process(child.myRoot));
        }

        @Override
        public boolean isInProject(@NotNull VirtualFile file) {
            if (file == null) {
                WithBeneathInfo.$$$reportNull$$$0(3);
            }
            return this.myDelegate.isInProject(file);
        }

        @Override
        public String toString() {
            return "WithBeneathInfo: " + this.myDelegate + " with roots beneath: " + this.myContentInfosBeneath;
        }

        @Override
        public boolean isIgnored() {
            return this.myDelegate.isIgnored();
        }

        @Override
        @Nullable
        public VirtualFile getSourceRoot() {
            return this.myDelegate.getSourceRoot();
        }

        @Override
        public VirtualFile getLibraryClassRoot() {
            return this.myDelegate.getLibraryClassRoot();
        }

        @Override
        @Nullable
        public VirtualFile getContentRoot() {
            return this.myDelegate.getContentRoot();
        }

        @Override
        public boolean isInLibrarySource(@NotNull VirtualFile file) {
            if (file == null) {
                WithBeneathInfo.$$$reportNull$$$0(4);
            }
            return this.myDelegate.isInLibrarySource(file);
        }

        @Override
        public boolean isExcluded() {
            return this.myDelegate.isExcluded();
        }

        @Override
        public boolean isExcluded(@NotNull VirtualFile file) {
            if (file == null) {
                WithBeneathInfo.$$$reportNull$$$0(5);
            }
            return this.myDelegate.isExcluded(file);
        }

        @Override
        public boolean isInModuleSource(@NotNull VirtualFile file) {
            if (file == null) {
                WithBeneathInfo.$$$reportNull$$$0(6);
            }
            return this.myDelegate.isInModuleSource(file);
        }

        @Override
        public Module getModule() {
            return this.myDelegate.getModule();
        }

        @Override
        public String getUnloadedModuleName() {
            return this.myDelegate.getUnloadedModuleName();
        }

        @Override
        @Nullable
        public SourceFolder getSourceRootFolder() {
            return this.myDelegate.getSourceRootFolder();
        }

        @Override
        public boolean hasLibraryClassRoot() {
            return this.myDelegate.hasLibraryClassRoot();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/NonProjectDirectoryInfo$WithBeneathInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContentBeneathExcluded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInLibrarySource";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExcluded";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInModuleSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

