/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.progress.ProgressManager;
import sqldelight.com.intellij.openapi.roots.DependencyScope;
import sqldelight.com.intellij.openapi.roots.ExportableOrderEntry;
import sqldelight.com.intellij.openapi.roots.JdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.LibraryOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleOrderEntry;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.ModuleRootModel;
import sqldelight.com.intellij.openapi.roots.ModuleSourceOrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderEnumerationHandler;
import sqldelight.com.intellij.openapi.roots.OrderEnumerator;
import sqldelight.com.intellij.openapi.roots.OrderEnumeratorSettings;
import sqldelight.com.intellij.openapi.roots.OrderRootType;
import sqldelight.com.intellij.openapi.roots.OrderRootsEnumerator;
import sqldelight.com.intellij.openapi.roots.RootModelProvider;
import sqldelight.com.intellij.openapi.roots.RootPolicy;
import sqldelight.com.intellij.openapi.roots.impl.OrderRootsCache;
import sqldelight.com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl;
import sqldelight.com.intellij.openapi.roots.libraries.Library;
import sqldelight.com.intellij.openapi.util.Condition;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileManager;
import sqldelight.com.intellij.util.NotNullFunction;
import sqldelight.com.intellij.util.PairProcessor;
import sqldelight.com.intellij.util.Processor;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

abstract class OrderEnumeratorBase
extends OrderEnumerator
implements OrderEnumeratorSettings {
    private static final Logger LOG = Logger.getInstance(OrderEnumeratorBase.class);
    private boolean myProductionOnly;
    private boolean myCompileOnly;
    private boolean myRuntimeOnly;
    private boolean myWithoutJdk;
    private boolean myWithoutLibraries;
    boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    boolean myRecursively;
    boolean myRecursivelyExportedOnly;
    private boolean myExportedOnly;
    private Condition<? super OrderEntry> myCondition;
    RootModelProvider myModulesProvider;
    private final OrderRootsCache myCache;

    OrderEnumeratorBase(@Nullable OrderRootsCache cache) {
        this.myCache = cache;
    }

    @NotNull
    static List<OrderEnumerationHandler> getCustomHandlers(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(0);
        }
        SmartList<OrderEnumerationHandler> customHandlers = null;
        for (OrderEnumerationHandler.Factory handlerFactory : OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!handlerFactory.isApplicable(module)) continue;
            if (customHandlers == null) {
                customHandlers = new SmartList<OrderEnumerationHandler>();
            }
            customHandlers.add(handlerFactory.createHandler(module));
        }
        List<OrderEnumerationHandler> list = customHandlers == null ? Collections.emptyList() : customHandlers;
        if (list == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public OrderEnumerator productionOnly() {
        this.myProductionOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(2);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator compileOnly() {
        this.myCompileOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(3);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(4);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator withoutSdk() {
        this.myWithoutJdk = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(5);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator withoutLibraries() {
        this.myWithoutLibraries = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(6);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator withoutDepModules() {
        this.myWithoutDepModules = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(7);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(8);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator recursively() {
        this.myRecursively = true;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(9);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(10);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator satisfying(@NotNull Condition<? super OrderEntry> condition) {
        if (condition == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(11);
        }
        this.myCondition = condition;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(12);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderEnumerator using(@NotNull RootModelProvider provider) {
        if (provider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(13);
        }
        this.myModulesProvider = provider;
        OrderEnumeratorBase orderEnumeratorBase = this;
        if (orderEnumeratorBase == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(14);
        }
        return orderEnumeratorBase;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator classes() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.CLASSES);
    }

    @Override
    @NotNull
    public OrderRootsEnumerator sources() {
        return new OrderRootsEnumeratorImpl(this, OrderRootType.SOURCES);
    }

    @Override
    @NotNull
    public OrderRootsEnumerator roots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(15);
        }
        return new OrderRootsEnumeratorImpl(this, rootType);
    }

    @Override
    @NotNull
    public OrderRootsEnumerator roots(@NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        if (rootTypeProvider == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(16);
        }
        return new OrderRootsEnumeratorImpl(this, rootTypeProvider);
    }

    ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(17);
        }
        if (this.myModulesProvider != null) {
            return this.myModulesProvider.getRootModel(module);
        }
        return ModuleRootManager.getInstance(module);
    }

    @NotNull
    OrderRootsCache getCache() {
        LOG.assertTrue(this.myCache != null, "Caching is not supported for ModifiableRootModel");
        LOG.assertTrue(this.myCondition == null, "Caching not supported for OrderEnumerator with 'satisfying(Condition)' option");
        LOG.assertTrue(this.myModulesProvider == null, "Caching not supported for OrderEnumerator with 'using(ModulesProvider)' option");
        OrderRootsCache orderRootsCache = this.myCache;
        if (orderRootsCache == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(18);
        }
        return orderRootsCache;
    }

    public int getFlags() {
        int flags = 0;
        if (this.myProductionOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myCompileOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRuntimeOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutJdk) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutLibraries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutDepModules) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myWithoutModuleSourceEntries) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursively) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myRecursivelyExportedOnly) {
            flags |= 1;
        }
        flags <<= 1;
        if (this.myExportedOnly) {
            flags |= 1;
        }
        return flags;
    }

    @Override
    public boolean shouldRecurse(@NotNull ModuleOrderEntry entry, @NotNull List<? extends OrderEnumerationHandler> handlers) {
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(19);
        }
        if (handlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(20);
        }
        ProcessEntryAction action = this.shouldAddOrRecurse(entry, true, handlers);
        return action.type == ProcessEntryActionType.RECURSE;
    }

    @NotNull
    private ProcessEntryAction shouldAddOrRecurse(@NotNull OrderEntry entry, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        ModuleOrderEntry moduleOrderEntry;
        Module depModule;
        boolean exported;
        OrderEnumerationHandler handler;
        if (entry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(21);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(22);
        }
        if (this.myCondition != null && !this.myCondition.value(entry)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(23);
            }
            return processEntryAction;
        }
        if (entry instanceof JdkOrderEntry && (this.myWithoutJdk || !firstLevel)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(24);
            }
            return processEntryAction;
        }
        if (this.myWithoutLibraries && entry instanceof LibraryOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(25);
            }
            return processEntryAction;
        }
        if (this.myWithoutDepModules) {
            if (!this.myRecursively && entry instanceof ModuleOrderEntry) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(26);
                }
                return processEntryAction;
            }
            if (entry instanceof ModuleSourceOrderEntry && !this.isRootModuleModel(((ModuleSourceOrderEntry)entry).getRootModel())) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(27);
                }
                return processEntryAction;
            }
        }
        if (this.myWithoutModuleSourceEntries && entry instanceof ModuleSourceOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(28);
            }
            return processEntryAction;
        }
        OrderEnumerationHandler.AddDependencyType shouldAdd = OrderEnumerationHandler.AddDependencyType.DEFAULT;
        Iterator<? extends OrderEnumerationHandler> iterator = customHandlers.iterator();
        while (iterator.hasNext() && (shouldAdd = (handler = iterator.next()).shouldAddDependency(entry, this)) == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
        }
        if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DO_NOT_ADD) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(29);
            }
            return processEntryAction;
        }
        boolean bl = exported = !(entry instanceof JdkOrderEntry);
        if (entry instanceof ExportableOrderEntry) {
            ExportableOrderEntry exportableEntry = (ExportableOrderEntry)entry;
            if (shouldAdd == OrderEnumerationHandler.AddDependencyType.DEFAULT) {
                boolean forTestCompile;
                DependencyScope scope = exportableEntry.getScope();
                boolean bl2 = forTestCompile = scope.isForTestCompile() || scope == DependencyScope.RUNTIME && OrderEnumeratorBase.shouldAddRuntimeDependenciesToTestCompilationClasspath(customHandlers);
                if (this.myCompileOnly && !scope.isForProductionCompile() && !forTestCompile) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(30);
                    }
                    return processEntryAction;
                }
                if (this.myRuntimeOnly && !scope.isForProductionRuntime() && !scope.isForTestRuntime()) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(31);
                    }
                    return processEntryAction;
                }
                if (this.myProductionOnly && (!scope.isForProductionCompile() && !scope.isForProductionRuntime() || this.myCompileOnly && !scope.isForProductionCompile() || this.myRuntimeOnly && !scope.isForProductionRuntime())) {
                    ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                    if (processEntryAction == null) {
                        OrderEnumeratorBase.$$$reportNull$$$0(32);
                    }
                    return processEntryAction;
                }
            }
            exported = exportableEntry.isExported();
        }
        if (!exported) {
            if (this.myExportedOnly) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(33);
                }
                return processEntryAction;
            }
            if (this.myRecursivelyExportedOnly && !firstLevel) {
                ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
                if (processEntryAction == null) {
                    OrderEnumeratorBase.$$$reportNull$$$0(34);
                }
                return processEntryAction;
            }
        }
        if (this.myRecursively && entry instanceof ModuleOrderEntry && (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) != null && OrderEnumeratorBase.shouldProcessRecursively(customHandlers)) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.RECURSE(depModule);
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(35);
            }
            return processEntryAction;
        }
        if (this.myWithoutDepModules && entry instanceof ModuleOrderEntry) {
            ProcessEntryAction processEntryAction = ProcessEntryAction.SKIP;
            if (processEntryAction == null) {
                OrderEnumeratorBase.$$$reportNull$$$0(36);
            }
            return processEntryAction;
        }
        ProcessEntryAction processEntryAction = ProcessEntryAction.PROCESS;
        if (processEntryAction == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(37);
        }
        return processEntryAction;
    }

    protected void processEntries(@NotNull ModuleRootModel rootModel, @Nullable Set<? super Module> processed, boolean firstLevel, @NotNull List<? extends OrderEnumerationHandler> customHandlers, @NotNull PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>> processor) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(38);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(40);
        }
        ProgressManager.checkCanceled();
        if (processed != null && !processed.add(rootModel.getModule())) {
            return;
        }
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            ProcessEntryAction action = this.shouldAddOrRecurse(entry, firstLevel, customHandlers);
            if (action.type == ProcessEntryActionType.SKIP) continue;
            if (action.type == ProcessEntryActionType.RECURSE) {
                this.processEntries(this.getRootModel(action.recurseOnModule), processed, false, customHandlers, processor);
                continue;
            }
            assert (action.type == ProcessEntryActionType.PROCESS);
            if (processor.process(entry, customHandlers)) continue;
            return;
        }
    }

    private static boolean shouldAddRuntimeDependenciesToTestCompilationClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(41);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (!orderEnumerationHandler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldProcessRecursively(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(42);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forEach(@NotNull Processor<? super OrderEntry> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(43);
        }
        this.forEach((? super OrderEntry entry, ? super List<? extends OrderEnumerationHandler> __) -> processor.process((OrderEntry)entry));
    }

    protected abstract void forEach(@NotNull PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>> var1);

    @Override
    public void forEachLibrary(@NotNull Processor<? super Library> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(44);
        }
        this.forEach((? super OrderEntry entry, ? super List<? extends OrderEnumerationHandler> __) -> {
            Library library;
            if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null) {
                return processor.process(library);
            }
            return true;
        });
    }

    @Override
    public void forEachModule(@NotNull Processor<? super Module> processor) {
        if (processor == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(45);
        }
        this.forEach((? super OrderEntry orderEntry, ? super List<? extends OrderEnumerationHandler> customHandlers) -> {
            Module module;
            if (this.myRecursively && orderEntry instanceof ModuleSourceOrderEntry) {
                Module module2 = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule();
                return processor.process(module2);
            }
            if (!(!(orderEntry instanceof ModuleOrderEntry) || this.myRecursively && OrderEnumeratorBase.shouldProcessRecursively(customHandlers) || (module = ((ModuleOrderEntry)orderEntry).getModule()) == null)) {
                return processor.process(module);
            }
            return true;
        });
    }

    @Override
    public <R> R process(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(46);
        }
        OrderEntryProcessor<R> processor = new OrderEntryProcessor<R>(policy, initialValue);
        this.forEach(processor);
        return processor.myValue;
    }

    static boolean shouldIncludeTestsFromDependentModulesToTestClasspath(@NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(47);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            if (orderEnumerationHandler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    static boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type2, @NotNull Collection<? super VirtualFile> result, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(48);
        }
        if (type2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(49);
        }
        if (result == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(50);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(51);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = orderEnumerationHandler.addCustomRootsForLibrary(forOrderEntry, type2, urls);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result, VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootUrlsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type2, @NotNull Collection<? super String> result, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (forOrderEntry == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(52);
        }
        if (type2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(53);
        }
        if (result == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(54);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(55);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = orderEnumerationHandler.addCustomRootsForLibrary(forOrderEntry, type2, urls);
            result.addAll(urls);
            if (!added) continue;
            return true;
        }
        return false;
    }

    static boolean addCustomRootsForModule(@NotNull OrderRootType type2, @NotNull ModuleRootModel rootModel, @NotNull Collection<? super VirtualFile> result, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (type2 == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(56);
        }
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(57);
        }
        if (result == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(58);
        }
        if (customHandlers == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(59);
        }
        for (OrderEnumerationHandler orderEnumerationHandler : customHandlers) {
            ArrayList<String> urls = new ArrayList<String>();
            boolean added = orderEnumerationHandler.addCustomModuleRoots(type2, rootModel, urls, includeProduction, includeTests);
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result, VirtualFileManager.getInstance().findFileByUrl(url));
            }
            if (!added) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRuntimeOnly() {
        return this.myRuntimeOnly;
    }

    @Override
    public boolean isCompileOnly() {
        return this.myCompileOnly;
    }

    @Override
    public boolean isProductionOnly() {
        return this.myProductionOnly;
    }

    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            OrderEnumeratorBase.$$$reportNull$$$0(60);
        }
        return false;
    }

    public abstract void processRootModules(@NotNull Processor<? super Module> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 22: 
            case 39: 
            case 41: 
            case 42: 
            case 47: 
            case 51: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 38: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 40: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOrderEntry";
                break;
            }
            case 49: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 50: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/OrderEnumeratorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHandlers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "productionOnly";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compileOnly";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeOnly";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutDepModules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutModuleSourceEntries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "recursively";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "exportedOnly";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "satisfying";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "using";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldAddOrRecurse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomHandlers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "satisfying";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "using";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "roots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootModel";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecurse";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddOrRecurse";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processEntries";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddRuntimeDependenciesToTestCompilationClasspath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessRecursively";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "forEachLibrary";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "forEachModule";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeTestsFromDependentModulesToTestClasspath";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForLibrary";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootUrlsForLibrary";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRootsForModule";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isRootModuleModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OrderEntryProcessor<R>
    implements PairProcessor<OrderEntry, List<? extends OrderEnumerationHandler>> {
        private R myValue;
        private final RootPolicy<R> myPolicy;

        private OrderEntryProcessor(@NotNull RootPolicy<R> policy, R initialValue) {
            if (policy == null) {
                OrderEntryProcessor.$$$reportNull$$$0(0);
            }
            this.myPolicy = policy;
            this.myValue = initialValue;
        }

        @Override
        public boolean process(OrderEntry orderEntry, List<? extends OrderEnumerationHandler> __) {
            this.myValue = orderEntry.accept(this.myPolicy, this.myValue);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "sqldelight/com/intellij/openapi/roots/impl/OrderEnumeratorBase$OrderEntryProcessor", "<init>"));
        }
    }

    protected static final class ProcessEntryAction {
        @NotNull
        public ProcessEntryActionType type;
        @Nullable
        Module recurseOnModule;
        public static final ProcessEntryAction SKIP = new ProcessEntryAction(ProcessEntryActionType.SKIP);
        public static final ProcessEntryAction PROCESS = new ProcessEntryAction(ProcessEntryActionType.PROCESS);

        private ProcessEntryAction(@NotNull ProcessEntryActionType type2) {
            if (type2 == null) {
                ProcessEntryAction.$$$reportNull$$$0(0);
            }
            this.type = type2;
        }

        @NotNull
        static ProcessEntryAction RECURSE(@NotNull Module module) {
            if (module == null) {
                ProcessEntryAction.$$$reportNull$$$0(1);
            }
            ProcessEntryAction result = new ProcessEntryAction(ProcessEntryActionType.RECURSE);
            result.recurseOnModule = module;
            ProcessEntryAction processEntryAction = result;
            if (processEntryAction == null) {
                ProcessEntryAction.$$$reportNull$$$0(2);
            }
            return processEntryAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/OrderEnumeratorBase$ProcessEntryAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "RECURSE";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "RECURSE";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum ProcessEntryActionType {
        SKIP,
        RECURSE,
        PROCESS;

    }
}

