/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.WriteAction;
import sqldelight.com.intellij.openapi.components.PersistentStateComponent;
import sqldelight.com.intellij.openapi.components.State;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.ProjectExtensionPointName;
import sqldelight.com.intellij.openapi.module.Module;
import sqldelight.com.intellij.openapi.module.ModuleManager;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.project.RootsChangeIndexingInfo;
import sqldelight.com.intellij.openapi.projectRoots.ProjectJdkTable;
import sqldelight.com.intellij.openapi.projectRoots.Sdk;
import sqldelight.com.intellij.openapi.roots.ModuleRootManager;
import sqldelight.com.intellij.openapi.roots.ModuleRootManagerEx;
import sqldelight.com.intellij.openapi.roots.OrderEnumerator;
import sqldelight.com.intellij.openapi.roots.ProjectExtension;
import sqldelight.com.intellij.openapi.roots.ProjectFileIndex;
import sqldelight.com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import sqldelight.com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import sqldelight.com.intellij.openapi.roots.impl.OrderRootsCache;
import sqldelight.com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import sqldelight.com.intellij.util.EventDispatcher;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;
import sqldelight.org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="ProjectRootManager")
public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerImpl.class);
    private static final ProjectExtensionPointName<ProjectExtension> EP_NAME = new ProjectExtensionPointName("sqldelight.com.intellij.projectExtension");
    private static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    private static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    private static final String ATTRIBUTE_VERSION = "version";
    protected final Project myProject;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher;
    private String myProjectSdkName;
    private String myProjectSdkType;
    private final OrderRootsCache myRootsCache;
    protected boolean myStartupActivityPerformed;
    private boolean myStateLoaded;
    protected final BatchSession<RootsChangeIndexingInfo, List<RootsChangeIndexingInfo>> myRootsChanged;
    protected final BatchSession<Boolean, Boolean> myFileTypesChanged;
    private final VirtualFilePointerListener myEmptyRootsValidityChangedListener;
    protected boolean isFiringEvent;

    @ApiStatus.Internal
    public BatchSession<RootsChangeIndexingInfo, List<RootsChangeIndexingInfo>> getRootsChanged() {
        return this.myRootsChanged;
    }

    public static ProjectRootManagerImpl getInstanceImpl(Project project) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance(project);
    }

    public ProjectRootManagerImpl(@NotNull Project project) {
        if (project == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
        this.myRootsChanged = new BatchSession<RootsChangeIndexingInfo, List<RootsChangeIndexingInfo>>(false){

            @Override
            protected boolean fireRootsChanged(@NotNull List<RootsChangeIndexingInfo> changes) {
                if (changes == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectRootManagerImpl.this.fireRootsChanged(false, changes);
            }

            @Override
            @NotNull
            protected List<RootsChangeIndexingInfo> accumulate(@NotNull List<RootsChangeIndexingInfo> currentPair, @NotNull RootsChangeIndexingInfo cause) {
                if (currentPair == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (cause == null) {
                    1.$$$reportNull$$$0(2);
                }
                currentPair.add(cause);
                List<RootsChangeIndexingInfo> list = currentPair;
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            @Override
            @NotNull
            protected RootsChangeIndexingInfo getGenericChange() {
                RootsChangeIndexingInfo rootsChangeIndexingInfo = RootsChangeIndexingInfo.TOTAL_REINDEX;
                if (rootsChangeIndexingInfo == null) {
                    1.$$$reportNull$$$0(4);
                }
                return rootsChangeIndexingInfo;
            }

            @Override
            @NotNull
            protected List<RootsChangeIndexingInfo> initiateChangelist(@NotNull RootsChangeIndexingInfo info) {
                if (info == null) {
                    1.$$$reportNull$$$0(5);
                }
                return new SmartList<RootsChangeIndexingInfo>(info);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changes";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentPair";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cause";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "accumulate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGenericChange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fireRootsChanged";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "accumulate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "initiateChangelist";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myFileTypesChanged = new BatchSession<Boolean, Boolean>(true){

            @Override
            protected boolean fireRootsChanged(@NotNull Boolean aBoolean) {
                if (aBoolean == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ProjectRootManagerImpl.this.fireRootsChanged(true, Collections.emptyList());
            }

            @Override
            @NotNull
            protected Boolean accumulate(@NotNull Boolean current, @NotNull Boolean change) {
                if (current == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (change == null) {
                    2.$$$reportNull$$$0(2);
                }
                Boolean bl = current != false || change != false;
                if (bl == null) {
                    2.$$$reportNull$$$0(3);
                }
                return bl;
            }

            @Override
            @NotNull
            protected Boolean getGenericChange() {
                Boolean bl = Boolean.TRUE;
                if (bl == null) {
                    2.$$$reportNull$$$0(4);
                }
                return bl;
            }

            @Override
            @NotNull
            protected Boolean initiateChangelist(@NotNull Boolean aBoolean) {
                if (aBoolean == null) {
                    2.$$$reportNull$$$0(5);
                }
                Boolean bl = aBoolean;
                if (bl == null) {
                    2.$$$reportNull$$$0(6);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aBoolean";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "current";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "change";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "accumulate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGenericChange";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "initiateChangelist";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fireRootsChanged";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "accumulate";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "initiateChangelist";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myEmptyRootsValidityChangedListener = new VirtualFilePointerListener(){};
        this.myProject = project;
        this.myRootsCache = this.getOrderRootsCache(project);
        project.getMessageBus().connect().subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, new ProjectJdkTable.Listener(){

            @Override
            public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
                String currentName;
                if (jdk == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (previousName == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (previousName.equals(currentName = ProjectRootManagerImpl.this.getProjectSdkName())) {
                    ProjectRootManagerImpl.this.myProjectSdkName = jdk.getName();
                    ProjectRootManagerImpl.this.myProjectSdkType = jdk.getSdkType().getName();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "jdk";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "previousName";
                        break;
                    }
                }
                objectArray[1] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl$4";
                objectArray[2] = "jdkNameChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @NotNull
    public ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(this.myProject);
        if (projectFileIndex == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(1);
        }
        return projectFileIndex;
    }

    @Override
    @NotNull
    public List<String> getContentRootUrls() {
        Module[] modules = this.getModuleManager().getModules();
        ArrayList<String> result = new ArrayList<String>(modules.length);
        for (Module module : modules) {
            ContainerUtil.addAll(result, ModuleRootManager.getInstance(module).getContentRootUrls());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public VirtualFile @NotNull [] getContentRoots() {
        Module[] modules = this.getModuleManager().getModules();
        ArrayList result = new ArrayList(modules.length);
        for (Module module : modules) {
            VirtualFile[] contentRoots = ModuleRootManager.getInstance(module).getContentRoots();
            if (modules.length == 1) {
                if (contentRoots == null) {
                    ProjectRootManagerImpl.$$$reportNull$$$0(3);
                }
                return contentRoots;
            }
            ContainerUtil.addAll(result, contentRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getContentSourceRoots() {
        Module[] modules = this.getModuleManager().getModules();
        ArrayList result = new ArrayList(modules.length);
        for (Module module : modules) {
            ContainerUtil.addAll(result, ModuleRootManager.getInstance(module).getSourceRoots());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(6);
        }
        Module[] modules = this.getModuleManager().getModules();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(modules.length);
        for (Module module : modules) {
            roots.addAll(ModuleRootManager.getInstance(module).getSourceRoots(rootTypes));
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries() {
        return new ProjectOrderEnumerator(this.myProject, this.myRootsCache);
    }

    @Override
    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(8);
        }
        return new ModulesOrderEnumerator(modules);
    }

    @Override
    public VirtualFile @NotNull [] getContentRootsFromAllModules() {
        Module[] modules = this.getModuleManager().getSortedModules();
        ArrayList result = new ArrayList(modules.length + 1);
        for (Module module : modules) {
            Collections.addAll(result, ModuleRootManager.getInstance(module).getContentRoots());
        }
        ContainerUtil.addIfNotNull(result, this.myProject.getBaseDir());
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(9);
        }
        return virtualFileArray;
    }

    @Override
    public Sdk getProjectSdk() {
        if (this.myProjectSdkName == null) {
            return null;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        if (this.myProjectSdkType == null) {
            return projectJdkTable.findJdk(this.myProjectSdkName);
        }
        return projectJdkTable.findJdk(this.myProjectSdkName, this.myProjectSdkType);
    }

    @Override
    @Nullable
    public String getProjectSdkName() {
        return this.myProjectSdkName;
    }

    @Override
    @Nullable
    public String getProjectSdkTypeName() {
        return this.myProjectSdkType;
    }

    @Override
    public void setProjectSdk(@Nullable Sdk sdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (sdk == null) {
            this.myProjectSdkName = null;
            this.myProjectSdkType = null;
        } else {
            this.myProjectSdkName = sdk.getName();
            this.myProjectSdkType = sdk.getSdkType().getName();
        }
        this.projectJdkChanged();
    }

    public void projectJdkChanged() {
        this.incModificationCount();
        this.mergeRootsChangesDuring(this.getActionToRunWhenProjectJdkChanges());
        this.fireJdkChanged();
    }

    private void fireJdkChanged() {
        Sdk sdk = this.getProjectSdk();
        for (ProjectExtension extension : EP_NAME.getExtensions(this.myProject)) {
            extension.projectSdkChanged(sdk);
        }
    }

    @NotNull
    protected Runnable getActionToRunWhenProjectJdkChanges() {
        Runnable runnable = () -> this.myProjectJdkEventDispatcher.getMulticaster().projectJdkChanged();
        if (runnable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(10);
        }
        return runnable;
    }

    @Override
    public void setProjectSdkName(@NotNull String name, @NotNull String sdkTypeName) {
        if (name == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(11);
        }
        if (sdkTypeName == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectSdkName = name;
        this.myProjectSdkType = sdkTypeName;
        this.projectJdkChanged();
    }

    @Override
    public void addProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener) {
        if (listener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(13);
        }
        this.myProjectJdkEventDispatcher.addListener(listener);
    }

    @Override
    public void removeProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener) {
        if (listener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(14);
        }
        this.myProjectJdkEventDispatcher.removeListener(listener);
    }

    @Override
    public void loadState(@NotNull Element element) {
        if (element == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(15);
        }
        for (ProjectExtension extension : EP_NAME.getExtensions(this.myProject)) {
            extension.readExternal(element);
        }
        this.myProjectSdkName = element.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectSdkType = element.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            Runnable runnable = this.myStateLoaded ? () -> this.projectJdkChanged() : () -> this.fireJdkChanged();
            app.invokeLater(() -> app.runWriteAction(runnable), app.getNoneModalityState());
        }
        this.myStateLoaded = true;
    }

    @Override
    public void noStateLoaded() {
        this.myStateLoaded = true;
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        element.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension : EP_NAME.getExtensions(this.myProject)) {
            extension.writeExternal(element);
        }
        if (this.myProjectSdkName != null) {
            element.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectSdkName);
        }
        if (this.myProjectSdkType != null) {
            element.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectSdkType);
        }
        if (element.getAttributes().size() == 1) {
            element.removeAttribute(ATTRIBUTE_VERSION);
        }
        return element;
    }

    @Override
    public void mergeRootsChangesDuring(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        BatchSession<RootsChangeIndexingInfo, List<RootsChangeIndexingInfo>> batchSession = this.myRootsChanged;
        batchSession.levelUp();
        try {
            runnable.run();
        }
        finally {
            batchSession.levelDown();
        }
    }

    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        this.myRootsCache.clearCache();
        for (Module module : modules = ModuleManager.getInstance(this.myProject).getModules()) {
            ModuleRootManagerEx.getInstanceEx(module).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeRootsChange(@NotNull Runnable runnable, boolean fileTypes, boolean fireEvents) {
        if (runnable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(17);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        BatchSession<Object, Object> session = fileTypes ? this.myFileTypesChanged : this.myRootsChanged;
        try {
            if (fireEvents) {
                session.beforeRootsChanged();
            }
            runnable.run();
        }
        finally {
            if (fireEvents) {
                session.rootsChanged();
            }
        }
    }

    private void fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, "Do not use API that changes roots from roots events. Try using invoke later or something else.");
        this.fireBeforeRootsChangeEvent(fileTypes);
    }

    @ApiStatus.Internal
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private boolean fireRootsChanged(boolean fileTypes, @NotNull List<? extends RootsChangeIndexingInfo> indexingInfos) {
        if (indexingInfos == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(18);
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, "Do not use API that changes roots from roots events. Try using invoke later or something else.");
        this.clearScopesCaches();
        this.incModificationCount();
        this.fireRootsChangedEvent(fileTypes, indexingInfos);
        return true;
    }

    @ApiStatus.Internal
    protected void fireRootsChangedEvent(boolean fileTypes, @NotNull List<? extends RootsChangeIndexingInfo> indexingInfos) {
        if (indexingInfos == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(19);
        }
    }

    @ApiStatus.Internal
    protected OrderRootsCache getOrderRootsCache(@NotNull Project project) {
        if (project == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(20);
        }
        return new OrderRootsCache(project);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(21);
        }
        return project;
    }

    @NotNull
    public static String extractLocalPath(@NotNull String url) {
        String path;
        int separatorIndex;
        if (url == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(22);
        }
        String string = (separatorIndex = (path = VfsUtilCore.urlToPath(url)).indexOf("!/")) > 0 ? path.substring(0, separatorIndex) : path;
        if (string == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private ModuleManager getModuleManager() {
        ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
        if (moduleManager == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(24);
        }
        return moduleManager;
    }

    @Override
    public void markRootsForRefresh() {
    }

    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myEmptyRootsValidityChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(25);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeName";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingInfos";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSourceRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSourceRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootsFromAllModules";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionToRunWhenProjectJdkChanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleManager";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSourceRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orderEntries";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProjectSdkName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addProjectJdkListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectJdkListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeRootsChangesDuring";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeRootsChange";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireRootsChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireRootsChangedEvent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrderRootsCache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public abstract class BatchSession<Change, ChangeList> {
        private final boolean myFileTypes;
        private int myBatchLevel;
        private int myPendingRootsChanged;
        private boolean myChanged;
        private ChangeList myChanges;

        private BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
                this.myChanges = null;
            }
            ++this.myBatchLevel;
        }

        void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                try {
                    if (this.myChanges == null) {
                        this.myChanges = this.initiateChangelist(this.getGenericChange());
                    }
                    --this.myPendingRootsChanged;
                    WriteAction.run(() -> this.fireRootsChanged(this.myChanges));
                }
                finally {
                    if (this.myPendingRootsChanged == 0) {
                        this.myChanged = false;
                        this.myChanges = null;
                    }
                }
            }
        }

        public void beforeRootsChanged() {
            if (this.myBatchLevel == 0 || !this.myChanged) {
                ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes);
                ++this.myPendingRootsChanged;
                this.myChanged = true;
            }
        }

        public void rootsChanged(@NotNull Change change) {
            if (change == null) {
                BatchSession.$$$reportNull$$$0(0);
            }
            ChangeList ChangeList = this.myChanges = this.myChanges == null ? this.initiateChangelist(change) : this.accumulate(this.myChanges, change);
            if (this.myBatchLevel == 0 && this.myChanged) {
                --this.myPendingRootsChanged;
                if (this.fireRootsChanged(this.myChanges) && this.myPendingRootsChanged == 0) {
                    this.myChanged = false;
                    this.myChanges = null;
                }
            }
        }

        public void rootsChanged() {
            this.rootsChanged(this.getGenericChange());
        }

        protected abstract boolean fireRootsChanged(@NotNull ChangeList var1);

        @NotNull
        protected abstract ChangeList initiateChangelist(@NotNull Change var1);

        @NotNull
        protected abstract ChangeList accumulate(@NotNull ChangeList var1, @NotNull Change var2);

        @NotNull
        protected abstract Change getGenericChange();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "sqldelight/com/intellij/openapi/roots/impl/ProjectRootManagerImpl$BatchSession", "rootsChanged"));
        }
    }
}

