/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.impl;

import java.util.List;
import sqldelight.com.intellij.model.ModelBranch;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.module.UnloadedModuleDescription;
import sqldelight.com.intellij.openapi.projectRoots.Sdk;
import sqldelight.com.intellij.openapi.roots.ContentEntry;
import sqldelight.com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import sqldelight.com.intellij.openapi.roots.OrderRootType;
import sqldelight.com.intellij.openapi.roots.SourceFolder;
import sqldelight.com.intellij.openapi.roots.impl.libraries.LibraryEx;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileManager;
import sqldelight.com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

class RootFileSupplier {
    private static final Logger LOG = Logger.getInstance(RootFileSupplier.class);
    static final RootFileSupplier INSTANCE = new RootFileSupplier();

    RootFileSupplier() {
    }

    @NotNull
    @NotNull List<@NotNull VirtualFile> getUnloadedContentRoots(UnloadedModuleDescription description) {
        List<VirtualFile> list = ContainerUtil.mapNotNull(description.getContentRoots(), VirtualFilePointer::getFile);
        if (list == null) {
            RootFileSupplier.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    VirtualFile correctRoot(@NotNull VirtualFile file, @NotNull Object container, @Nullable Object containerProvider) {
        if (file == null) {
            RootFileSupplier.$$$reportNull$$$0(1);
        }
        if (container == null) {
            RootFileSupplier.$$$reportNull$$$0(2);
        }
        if (!RootFileSupplier.ensureValid(file, container, containerProvider)) {
            return null;
        }
        return file;
    }

    @Nullable
    VirtualFile findFileByUrl(String url) {
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    VirtualFile @NotNull [] getExcludedRoots(LibraryEx library) {
        VirtualFile[] virtualFileArray = library.getExcludedRoots();
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    VirtualFile @NotNull [] getLibraryRoots(LibraryOrSdkOrderEntry entry, OrderRootType type2) {
        VirtualFile[] virtualFileArray = entry.getRootFiles(type2);
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    VirtualFile @NotNull [] getSdkRoots(@NotNull Sdk entry, OrderRootType type2) {
        if (entry == null) {
            RootFileSupplier.$$$reportNull$$$0(5);
        }
        VirtualFile[] virtualFileArray = entry.getRootProvider().getFiles(type2);
        if (virtualFileArray == null) {
            RootFileSupplier.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    @Nullable
    VirtualFile getContentRoot(ContentEntry contentEntry) {
        return contentEntry.getFile();
    }

    @Nullable
    VirtualFile getSourceRoot(SourceFolder sourceFolder) {
        return sourceFolder.getFile();
    }

    static RootFileSupplier forBranch(final ModelBranch branch) {
        return new RootFileSupplier(){

            @Override
            protected VirtualFile @NotNull [] getExcludedRoots(LibraryEx library) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(library.getExcludedRootUrls(), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFileArray;
            }

            @Override
            protected VirtualFile @NotNull [] getLibraryRoots(LibraryOrSdkOrderEntry entry, OrderRootType type2) {
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(entry.getRootUrls(type2), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return virtualFileArray;
            }

            @Override
            VirtualFile @NotNull [] getSdkRoots(@NotNull Sdk sdk, OrderRootType type2) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(2);
                }
                VirtualFile[] virtualFileArray = ContainerUtil.mapNotNull(sdk.getRootProvider().getUrls(type2), this::findFileByUrl).toArray(VirtualFile.EMPTY_ARRAY);
                if (virtualFileArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return virtualFileArray;
            }

            @Override
            @Nullable
            protected VirtualFile getContentRoot(ContentEntry contentEntry) {
                return this.findFileByUrl(contentEntry.getUrl());
            }

            @Override
            @Nullable
            protected VirtualFile getSourceRoot(SourceFolder sourceFolder) {
                return this.findFileByUrl(sourceFolder.getUrl());
            }

            @Override
            @NotNull
            protected @NotNull List<@NotNull VirtualFile> getUnloadedContentRoots(UnloadedModuleDescription description) {
                List<VirtualFile> list = ContainerUtil.mapNotNull(description.getContentRoots(), p -> this.findFileByUrl(p.getUrl()));
                if (list == null) {
                    1.$$$reportNull$$$0(4);
                }
                return list;
            }

            @Override
            @Nullable
            protected VirtualFile correctRoot(@NotNull VirtualFile file, @NotNull Object container, @Nullable Object containerProvider) {
                if (file == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (container == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((file = super.correctRoot(file, container, containerProvider)) != null && !(file = branch.findFileCopy(file)).isValid()) {
                    return null;
                }
                return file;
            }

            @Override
            @Nullable
            protected VirtualFile findFileByUrl(String url) {
                return branch.findFileByUrl(url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootFileSupplier$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdk";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "container";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExcludedRoots";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLibraryRoots";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootFileSupplier$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSdkRoots";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedContentRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSdkRoots";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "correctRoot";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static boolean ensureValid(@NotNull VirtualFile file, @NotNull Object container, @Nullable Object containerProvider) {
        if (file == null) {
            RootFileSupplier.$$$reportNull$$$0(7);
        }
        if (container == null) {
            RootFileSupplier.$$$reportNull$$$0(8);
        }
        if (!file.isValid()) {
            if (containerProvider != null) {
                LOG.error("Invalid root " + file + " in " + container + " provided by " + containerProvider.getClass());
            } else {
                LOG.error("Invalid root " + file + " in " + container);
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/roots/impl/RootFileSupplier";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedContentRoots";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/roots/impl/RootFileSupplier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "correctRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

