/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.libraries;

import java.util.HashMap;
import java.util.Map;
import sqldelight.com.intellij.openapi.roots.libraries.LibraryKindRegistry;
import sqldelight.com.intellij.openapi.roots.libraries.TemporaryLibraryKind;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class LibraryKind {
    private final String myKindId;
    private static final Map<String, LibraryKind> ourAllKinds = new HashMap<String, LibraryKind>();

    public LibraryKind(@NotNull @NonNls String kindId) {
        if (kindId == null) {
            LibraryKind.$$$reportNull$$$0(0);
        }
        this.myKindId = kindId;
        LibraryKind kind = ourAllKinds.get(kindId);
        if (kind != null && !(kind instanceof TemporaryLibraryKind)) {
            throw new IllegalArgumentException("Kind " + kindId + " is not unique");
        }
        ourAllKinds.put(kindId, this);
    }

    public final String getKindId() {
        return this.myKindId;
    }

    public String toString() {
        return "LibraryKind:" + this.myKindId;
    }

    public static LibraryKind create(@NotNull @NonNls String kindId) {
        if (kindId == null) {
            LibraryKind.$$$reportNull$$$0(1);
        }
        return new LibraryKind(kindId);
    }

    @Deprecated
    public static LibraryKind findById(String kindId) {
        return LibraryKindRegistry.getInstance().findKindById(kindId);
    }

    @Nullable
    static LibraryKind findByIdInternal(@Nullable String kindId) {
        return ourAllKinds.get(kindId);
    }

    @ApiStatus.Internal
    public static void unregisterKind(@NotNull LibraryKind kind) {
        if (kind == null) {
            LibraryKind.$$$reportNull$$$0(2);
        }
        ourAllKinds.remove(kind.getKindId());
    }

    @ApiStatus.Internal
    public static void registerKind(@NotNull LibraryKind kind) {
        if (kind == null) {
            LibraryKind.$$$reportNull$$$0(3);
        }
        ourAllKinds.put(kind.getKindId(), kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/roots/libraries/LibraryKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerKind";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

