/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import java.awt.Image;
import java.awt.image.ImageFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import sqldelight.com.intellij.openapi.util.IconLoader;
import sqldelight.com.intellij.ui.icons.IconTransform;
import sqldelight.com.intellij.ui.icons.ImageDataLoader;
import sqldelight.com.intellij.ui.scale.ScaleContext;
import sqldelight.com.intellij.util.ImageLoader;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImageDataByUrlLoader
implements ImageDataLoader {
    private static final URL UNRESOLVED_URL;
    @Nullable
    private final Class<?> ownerClass;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final String overriddenPath;
    @NotNull
    private final IconLoader.HandleNotFound handleNotFound;
    private volatile URL url;
    private final boolean useCacheOnLoad;

    ImageDataByUrlLoader(@NotNull URL url, @Nullable ClassLoader classLoader, boolean useCacheOnLoad) {
        if (url == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(0);
        }
        this.ownerClass = null;
        this.overriddenPath = null;
        this.classLoader = classLoader;
        this.url = url;
        this.handleNotFound = IconLoader.HandleNotFound.IGNORE;
        this.useCacheOnLoad = useCacheOnLoad;
    }

    public ImageDataByUrlLoader(@NotNull URL url, @NotNull String path, @Nullable ClassLoader classLoader, boolean useCacheOnLoad) {
        if (url == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(1);
        }
        if (path == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(2);
        }
        this.ownerClass = null;
        this.overriddenPath = path;
        this.classLoader = classLoader;
        this.url = url;
        this.handleNotFound = IconLoader.HandleNotFound.IGNORE;
        this.useCacheOnLoad = useCacheOnLoad;
    }

    ImageDataByUrlLoader(@NotNull String path, @Nullable Class<?> ownerClass, @Nullable ClassLoader classLoader, @NotNull IconLoader.HandleNotFound handleNotFound, boolean useCacheOnLoad) {
        if (path == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(3);
        }
        if (handleNotFound == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(4);
        }
        this.overriddenPath = path;
        this.ownerClass = ownerClass;
        this.classLoader = classLoader;
        this.handleNotFound = handleNotFound;
        this.useCacheOnLoad = useCacheOnLoad;
        this.url = UNRESOLVED_URL;
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull List<? extends ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
        String path;
        if (filters == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(5);
        }
        if (scaleContext == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(6);
        }
        int flags = 9;
        if (this.useCacheOnLoad) {
            flags |= 2;
        }
        if (isDark) {
            flags |= 4;
        }
        if ((path = this.overriddenPath) == null || this.ownerClass == null && (this.classLoader == null || path.charAt(0) != '/')) {
            URL url = this.getURL();
            if (url == null) {
                return null;
            }
            path = url.toString();
        }
        return ImageLoader.loadImage(path, filters, this.ownerClass, this.classLoader, flags, scaleContext, !path.endsWith(".svg"));
    }

    public void resolve() {
        this.getURL();
    }

    @Override
    @Nullable
    public URL getURL() {
        URL result = this.url;
        if (result == UNRESOLVED_URL) {
            result = null;
            try {
                result = IconLoader.doResolve(this.overriddenPath, this.classLoader, this.ownerClass, this.handleNotFound);
            }
            finally {
                this.url = result;
            }
        }
        return result;
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform) {
        if (originalPath == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(7);
        }
        if (transform == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(8);
        }
        return IconLoader.createNewResolverIfNeeded(this.classLoader, originalPath, transform);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            ImageDataByUrlLoader.$$$reportNull$$$0(9);
        }
        return this.classLoader == classLoader;
    }

    public String toString() {
        return "UrlResolver{ownerClass=" + (this.ownerClass == null ? "null" : this.ownerClass.getName()) + ", classLoader=" + this.classLoader + ", overriddenPath='" + this.overriddenPath + "', url=" + this.url + ", useCacheOnLoad=" + this.useCacheOnLoad + "}";
    }

    static {
        try {
            UNRESOLVED_URL = new URL("file:///unresolved");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handleNotFound";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/util/ImageDataByUrlLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadImage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "patch";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

