/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import java.util.function.Supplier;
import sqldelight.com.intellij.openapi.util.AtomicNullableLazyValue;
import sqldelight.com.intellij.openapi.util.Factory;
import sqldelight.com.intellij.openapi.util.RecursionGuard;
import sqldelight.com.intellij.openapi.util.RecursionManager;
import sqldelight.com.intellij.openapi.util.VolatileNullableLazyValue;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public abstract class NullableLazyValue<T> {
    private boolean myComputed;
    @Nullable
    private T myValue;

    @Nullable
    protected abstract T compute();

    @Nullable
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    public boolean isComputed() {
        return this.myComputed;
    }

    @NotNull
    public static <T> NullableLazyValue<T> lazyNullable(final @NotNull Supplier<? extends T> value) {
        if (value == null) {
            NullableLazyValue.$$$reportNull$$$0(0);
        }
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.get();
            }
        };
    }

    @NotNull
    public static <T> NullableLazyValue<T> atomicLazyNullable(final @NotNull Supplier<? extends T> value) {
        if (value == null) {
            NullableLazyValue.$$$reportNull$$$0(1);
        }
        return new AtomicNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.get();
            }
        };
    }

    @NotNull
    public static <T> NullableLazyValue<T> volatileLazyNullable(final @NotNull Supplier<? extends T> value) {
        if (value == null) {
            NullableLazyValue.$$$reportNull$$$0(2);
        }
        return new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.get();
            }
        };
    }

    @Deprecated
    @NotNull
    public static <T> NullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value) {
        if (value == null) {
            NullableLazyValue.$$$reportNull$$$0(3);
        }
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "value";
        objectArray2[1] = "sqldelight/com/intellij/openapi/util/NullableLazyValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lazyNullable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "atomicLazyNullable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "volatileLazyNullable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

