/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import sqldelight.com.intellij.openapi.util.Factory;
import sqldelight.com.intellij.openapi.util.NullableLazyValue;
import sqldelight.com.intellij.openapi.util.RecursionGuard;
import sqldelight.com.intellij.openapi.util.RecursionManager;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class VolatileNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile boolean myComputed;
    @Nullable
    private volatile T myValue;

    @Deprecated
    protected VolatileNullableLazyValue() {
    }

    @Override
    @Nullable
    public T getValue() {
        boolean computed = this.myComputed;
        T value = this.myValue;
        if (!computed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    @Override
    public boolean isComputed() {
        return this.myComputed;
    }

    @Deprecated
    @NotNull
    public static <T> VolatileNullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value) {
        if (value == null) {
            VolatileNullableLazyValue.$$$reportNull$$$0(0);
        }
        return new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "sqldelight/com/intellij/openapi/util/VolatileNullableLazyValue", "createValue"));
    }
}

