/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util.io;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import sqldelight.com.intellij.openapi.util.NlsSafe;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class NioFiles {
    private NioFiles() {
    }

    @Nullable
    public static Path toPath(@NotNull String path) {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(0);
        }
        try {
            return Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull Path path) {
        Path name;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        String string = ((name = path.getFileName()) != null ? name : path).toString();
        if (string == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        if (path == null) {
            NioFiles.$$$reportNull$$$0(3);
        }
        try {
            NioFiles.tryCreateDirectory(path);
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (IOException e) {
            Path parent = path.getParent();
            if (parent == null) {
                throw e;
            }
            NioFiles.createDirectories(parent);
            NioFiles.tryCreateDirectory(path);
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(4);
        }
        return path2;
    }

    private static void tryCreateDirectory(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    public static void setReadOnly(@NotNull Path path, boolean value) throws IOException {
        PosixFileAttributeView posixView;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(5);
        }
        if ((posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }

    public static void setExecutable(@NotNull Path file) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view;
        if (file == null) {
            NioFiles.$$$reportNull$$$0(6);
        }
        if ((view = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0])) != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        ArrayList<Path> arrayList;
        if (directory == null) {
            NioFiles.$$$reportNull$$$0(7);
        }
        try {
            ArrayList<Path> files = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    files.add(path);
                }
            }
            arrayList = files;
        }
        catch (IOException e) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                NioFiles.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (arrayList == null) {
            NioFiles.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(10);
        }
        FileUtilRt.deleteRecursivelyNIO(fileOrDirectory, null);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory, @NotNull Consumer<Path> callback) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(11);
        }
        if (callback == null) {
            NioFiles.$$$reportNull$$$0(12);
        }
        FileUtilRt.deleteRecursivelyNIO(fileOrDirectory, o -> callback.accept((Path)o));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectories";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

