/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.vfs.local;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.openapi.util.io.NioFiles;
import sqldelight.com.intellij.openapi.vfs.VFileProperty;
import sqldelight.com.intellij.openapi.vfs.VfsUtilCore;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileSystem;
import sqldelight.com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class CoreLocalVirtualFile
extends VirtualFile {
    private final CoreLocalFileSystem myFileSystem;
    private final Path myFile;
    private BasicFileAttributes myAttributes;
    private VirtualFile[] myChildren;

    @Deprecated
    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(0);
        }
        if (ioFile == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(1);
        }
        this(fileSystem, ioFile.toPath());
    }

    @Deprecated
    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull File ioFile, boolean isDirectory) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(2);
        }
        if (ioFile == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(3);
        }
        this(fileSystem, ioFile.toPath(), isDirectory);
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull Path file) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(5);
        }
        this.myFileSystem = fileSystem;
        this.myFile = file;
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull Path file, boolean isDirectory) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(7);
        }
        this.myFileSystem = fileSystem;
        this.myFile = file;
        this.myAttributes = isDirectory ? new IncompleteDirectoryAttributes() : null;
    }

    public CoreLocalVirtualFile(@NotNull CoreLocalFileSystem fileSystem, @NotNull Path file, @NotNull BasicFileAttributes attributes) {
        if (fileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(9);
        }
        if (attributes == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(10);
        }
        this.myFileSystem = fileSystem;
        this.myFile = file;
        this.myAttributes = attributes;
    }

    @NotNull
    protected Path getFile() {
        Path path = this.myFile;
        if (path == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(11);
        }
        return path;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myFileSystem;
        if (coreLocalFileSystem == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(12);
        }
        return coreLocalFileSystem;
    }

    @Override
    @NotNull
    public String getName() {
        String string = NioFiles.getFileName(this.myFile);
        if (string == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(this.myFile.toString());
        if (string == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        BasicFileAttributes attrs = this.getAttributes(false);
        return attrs != null && attrs.isDirectory();
    }

    @Override
    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(15);
        }
        BasicFileAttributes attrs = this.getAttributes(true);
        if (property == VFileProperty.HIDDEN) {
            return attrs instanceof DosFileAttributes && ((DosFileAttributes)attrs).isHidden() || NioFiles.getFileName(this.myFile).startsWith(".");
        }
        if (property == VFileProperty.SYMLINK) {
            return attrs != null && attrs.isSymbolicLink();
        }
        if (property == VFileProperty.SPECIAL) {
            return attrs != null && attrs.isOther();
        }
        return super.is(property);
    }

    @Override
    public long getTimeStamp() {
        BasicFileAttributes attrs = this.getAttributes(true);
        return attrs != null ? attrs.lastModifiedTime().toMillis() : -1L;
    }

    @Override
    public long getLength() {
        BasicFileAttributes attrs = this.getAttributes(false);
        return attrs != null ? attrs.size() : -1L;
    }

    @Nullable
    protected BasicFileAttributes getAttributes(boolean full) {
        if (this.myAttributes == null || full && this.myAttributes instanceof IncompleteDirectoryAttributes) {
            try {
                this.myAttributes = Files.readAttributes(this.myFile, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.myAttributes;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        Path parentFile = this.myFile.getParent();
        return parentFile != null ? new CoreLocalVirtualFile(this.myFileSystem, parentFile, new IncompleteDirectoryAttributes()) : null;
    }

    @Override
    public VirtualFile[] getChildren() {
        if (this.myChildren == null) {
            List<Path> files = NioFiles.list(this.myFile);
            if (files.isEmpty()) {
                this.myChildren = EMPTY_ARRAY;
            } else {
                VirtualFile[] result = new VirtualFile[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    result[i] = new CoreLocalVirtualFile(this.myFileSystem, files.get(i));
                }
                this.myChildren = result;
            }
        }
        return this.myChildren;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        byte[] byArray = Files.readAllBytes(this.myFile);
        if (byArray == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(16);
        }
        return byArray;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(this.myFile, new OpenOption[0])), this);
        if (inputStream == null) {
            CoreLocalVirtualFile.$$$reportNull$$$0(17);
        }
        return inputStream;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    @Override
    public boolean isInLocalFileSystem() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreLocalVirtualFile that = (CoreLocalVirtualFile)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/vfs/local/CoreLocalVirtualFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/vfs/local/CoreLocalVirtualFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IncompleteDirectoryAttributes
    implements BasicFileAttributes {
        private IncompleteDirectoryAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime lastAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime creationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isSymbolicLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOther() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException();
        }
    }
}

