/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.vfs.newvfs.events;

import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.openapi.vfs.VirtualFileSystem;
import sqldelight.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import sqldelight.com.intellij.util.LocalTimeCounter;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class VFileContentChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;
    private final long myOldTimestamp;
    private final long myNewTimestamp;
    private final long myOldLength;
    private final long myNewLength;
    private static final int UNDEFINED_TIMESTAMP_OR_LENGTH = -1;

    /*
     * WARNING - void declaration
     */
    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file, long oldModificationStamp, long newModificationStamp, boolean bl) {
        void isFromRefresh;
        if (file == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(0);
        }
        this(requestor, file, oldModificationStamp, newModificationStamp, -1L, -1L, -1L, -1L, (boolean)isFromRefresh);
    }

    /*
     * WARNING - void declaration
     */
    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file, long oldModificationStamp, long newModificationStamp, long oldTimestamp, long newTimestamp, long l, long l2, boolean bl) {
        void newLength;
        void oldLength;
        void isFromRefresh;
        if (file == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(1);
        }
        super(requestor, (boolean)isFromRefresh);
        this.myFile = file;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp == -1L ? LocalTimeCounter.currentTime() : newModificationStamp;
        this.myOldTimestamp = oldTimestamp;
        this.myNewTimestamp = newTimestamp;
        this.myOldLength = oldLength;
        this.myNewLength = newLength;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public long getModificationStamp() {
        return this.myNewModificationStamp;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    public long getOldTimestamp() {
        return this.myOldTimestamp;
    }

    public long getNewTimestamp() {
        return this.myNewTimestamp;
    }

    public long getOldLength() {
        return this.myOldLength;
    }

    public long getNewLength() {
        return this.myNewLength;
    }

    public boolean isLengthAndTimestampDiffProvided() {
        return this.myOldTimestamp != -1L || this.myNewTimestamp != -1L || this.myOldLength != -1L || this.myNewLength != -1L;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[update: " + this.myFile.getPresentableUrl() + ", oldTimestamp:" + this.myOldTimestamp + ", newTimestamp:" + this.myNewTimestamp + ", oldModificationStamp:" + this.myOldModificationStamp + ", newModificationStamp:" + this.myNewModificationStamp + ", oldLength:" + this.myOldLength + ", newLength:" + this.myNewLength + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        String string = this.myFile.getPath();
        if (string == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFileContentChangeEvent.$$$reportNull$$$0(4);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getModificationStamp() == this.myOldModificationStamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileContentChangeEvent event = (VFileContentChangeEvent)o;
        if (this.myNewModificationStamp != event.myNewModificationStamp) {
            return false;
        }
        if (this.myOldModificationStamp != event.myOldModificationStamp) {
            return false;
        }
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + (int)(this.myOldModificationStamp ^ this.myOldModificationStamp >>> 32);
        result = 31 * result + (int)(this.myNewModificationStamp ^ this.myNewModificationStamp >>> 32);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

