/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi;

import java.util.List;
import java.util.Set;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.util.UserDataHolderEx;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiManager;
import sqldelight.com.intellij.psi.PsiReference;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public interface FileViewProvider
extends Cloneable,
UserDataHolderEx {
    @NotNull
    public PsiManager getManager();

    public Document getDocument();

    @NotNull
    public CharSequence getContents();

    @NotNull
    public VirtualFile getVirtualFile();

    @NotNull
    public Language getBaseLanguage();

    @NotNull
    public Set<Language> getLanguages();

    default public boolean hasLanguage(@NotNull Language language) {
        if (language == null) {
            FileViewProvider.$$$reportNull$$$0(0);
        }
        return this.getLanguages().contains(language);
    }

    public PsiFile getPsi(@NotNull Language var1);

    @NotNull
    public List<PsiFile> getAllFiles();

    public boolean isEventSystemEnabled();

    public boolean isPhysical();

    public long getModificationStamp();

    public boolean supportsIncrementalReparse(@NotNull Language var1);

    public void rootChanged(@NotNull PsiFile var1);

    public void beforeContentsSynchronized();

    public void contentsSynchronized();

    public FileViewProvider clone();

    @Nullable
    public PsiElement findElementAt(int var1);

    @Nullable
    public PsiReference findReferenceAt(int var1);

    @Nullable
    public PsiElement findElementAt(int var1, @NotNull Language var2);

    @Nullable
    public PsiElement findElementAt(int var1, @NotNull Class<? extends Language> var2);

    @Nullable
    public PsiReference findReferenceAt(int var1, @NotNull Language var2);

    @NotNull
    public FileViewProvider createCopy(@NotNull VirtualFile var1);

    @NotNull
    public PsiFile getStubBindingRoot();

    @NotNull
    public FileType getFileType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "sqldelight/com/intellij/psi/FileViewProvider", "hasLanguage"));
    }
}

